% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_describe_snapshots}
\alias{fsx_describe_snapshots}
\title{Returns the description of specific Amazon FSx for OpenZFS snapshots, if
a SnapshotIds value is provided}
\usage{
fsx_describe_snapshots(
  SnapshotIds = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  IncludeShared = NULL
)
}
\arguments{
\item{SnapshotIds}{The IDs of the snapshots that you want to retrieve. This parameter value
overrides any filters. If any IDs aren't found, a \code{SnapshotNotFound}
error occurs.}

\item{Filters}{The filters structure. The supported names are \code{file-system-id} or
\code{volume-id}.}

\item{MaxResults}{}

\item{NextToken}{}

\item{IncludeShared}{Set to \code{false} (default) if you want to only see the snapshots in your
Amazon Web Services account. Set to \code{true} if you want to see the
snapshots in your account and the ones shared with you from another
account.}
}
\description{
Returns the description of specific Amazon FSx for OpenZFS snapshots, if a \code{SnapshotIds} value is provided. Otherwise, this operation returns all snapshots owned by your Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.

See \url{https://www.paws-r-sdk.com/docs/fsx_describe_snapshots/} for full documentation.
}
\keyword{internal}
