% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_object}
\alias{s3_get_object}
\title{Retrieves objects from Amazon S3}
\usage{
s3_get_object(
  Bucket,
  IfMatch = NULL,
  IfModifiedSince = NULL,
  IfNoneMatch = NULL,
  IfUnmodifiedSince = NULL,
  Key,
  Range = NULL,
  ResponseCacheControl = NULL,
  ResponseContentDisposition = NULL,
  ResponseContentEncoding = NULL,
  ResponseContentLanguage = NULL,
  ResponseContentType = NULL,
  ResponseExpires = NULL,
  VersionId = NULL,
  SSECustomerAlgorithm = NULL,
  SSECustomerKey = NULL,
  SSECustomerKeyMD5 = NULL,
  RequestPayer = NULL,
  PartNumber = NULL,
  ExpectedBucketOwner = NULL,
  ChecksumMode = NULL
)
}
\arguments{
\item{Bucket}{[required] The bucket name containing the object.

When using this action with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

When using an Object Lambda access point the hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-object-lambda.\emph{Region}.amazonaws.com.

When you use this action with Amazon S3 on Outposts, you must direct
requests to the S3 on Outposts hostname. The S3 on Outposts hostname
takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When you use this action with S3 on Outposts through the Amazon Web
Services SDKs, you provide the Outposts access point ARN in place of the
bucket name. For more information about S3 on Outposts ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{What is S3 on Outposts?}
in the \emph{Amazon S3 User Guide}.}

\item{IfMatch}{Return the object only if its entity tag (ETag) is the same as the one
specified; otherwise, return a 412 (precondition failed) error.}

\item{IfModifiedSince}{Return the object only if it has been modified since the specified time;
otherwise, return a 304 (not modified) error.}

\item{IfNoneMatch}{Return the object only if its entity tag (ETag) is different from the
one specified; otherwise, return a 304 (not modified) error.}

\item{IfUnmodifiedSince}{Return the object only if it has not been modified since the specified
time; otherwise, return a 412 (precondition failed) error.}

\item{Key}{[required] Key of the object to get.}

\item{Range}{Downloads the specified range bytes of an object. For more information
about the HTTP Range header, see
\url{https://www.rfc-editor.org/rfc/rfc9110.html#name-range}.

Amazon S3 doesn't support retrieving multiple ranges of data per \code{GET}
request.}

\item{ResponseCacheControl}{Sets the \code{Cache-Control} header of the response.}

\item{ResponseContentDisposition}{Sets the \code{Content-Disposition} header of the response}

\item{ResponseContentEncoding}{Sets the \code{Content-Encoding} header of the response.}

\item{ResponseContentLanguage}{Sets the \code{Content-Language} header of the response.}

\item{ResponseContentType}{Sets the \code{Content-Type} header of the response.}

\item{ResponseExpires}{Sets the \code{Expires} header of the response.}

\item{VersionId}{VersionId used to reference a specific version of the object.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when decrypting the object (for
example, AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 used to
encrypt the data. This value is used to decrypt the object when
recovering it and must match the one used when storing the data. The key
must be appropriate for use with the algorithm specified in the
\code{x-amz-server-side-encryption-customer-algorithm} header.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
that the encryption key was transmitted without error.}

\item{RequestPayer}{}

\item{PartNumber}{Part number of the object being read. This is a positive integer between
1 and 10,000. Effectively performs a 'ranged' GET request for the part
specified. Useful for downloading just a part of an object.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}

\item{ChecksumMode}{To retrieve the checksum, this mode must be enabled.}
}
\description{
Retrieves objects from Amazon S3. To use \code{GET}, you must have \code{READ} access to the object. If you grant \code{READ} access to the anonymous user, you can return the object without using an authorization header.

See \url{https://www.paws-r-sdk.com/docs/s3_get_object/} for full documentation.
}
\keyword{internal}
