% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_copy_object}
\alias{s3_copy_object}
\title{Creates a copy of an object that is already stored in Amazon S3}
\usage{
s3_copy_object(
  ACL = NULL,
  Bucket,
  CacheControl = NULL,
  ChecksumAlgorithm = NULL,
  ContentDisposition = NULL,
  ContentEncoding = NULL,
  ContentLanguage = NULL,
  ContentType = NULL,
  CopySource,
  CopySourceIfMatch = NULL,
  CopySourceIfModifiedSince = NULL,
  CopySourceIfNoneMatch = NULL,
  CopySourceIfUnmodifiedSince = NULL,
  Expires = NULL,
  GrantFullControl = NULL,
  GrantRead = NULL,
  GrantReadACP = NULL,
  GrantWriteACP = NULL,
  Key,
  Metadata = NULL,
  MetadataDirective = NULL,
  TaggingDirective = NULL,
  ServerSideEncryption = NULL,
  StorageClass = NULL,
  WebsiteRedirectLocation = NULL,
  SSECustomerAlgorithm = NULL,
  SSECustomerKey = NULL,
  SSECustomerKeyMD5 = NULL,
  SSEKMSKeyId = NULL,
  SSEKMSEncryptionContext = NULL,
  BucketKeyEnabled = NULL,
  CopySourceSSECustomerAlgorithm = NULL,
  CopySourceSSECustomerKey = NULL,
  CopySourceSSECustomerKeyMD5 = NULL,
  RequestPayer = NULL,
  Tagging = NULL,
  ObjectLockMode = NULL,
  ObjectLockRetainUntilDate = NULL,
  ObjectLockLegalHoldStatus = NULL,
  ExpectedBucketOwner = NULL,
  ExpectedSourceBucketOwner = NULL
)
}
\arguments{
\item{ACL}{The canned ACL to apply to the object.

This action is not supported by Amazon S3 on Outposts.}

\item{Bucket}{[required] The name of the destination bucket.

When using this action with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

When you use this action with Amazon S3 on Outposts, you must direct
requests to the S3 on Outposts hostname. The S3 on Outposts hostname
takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When you use this action with S3 on Outposts through the Amazon Web
Services SDKs, you provide the Outposts access point ARN in place of the
bucket name. For more information about S3 on Outposts ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{What is S3 on Outposts}
in the \emph{Amazon S3 User Guide}.}

\item{CacheControl}{Specifies caching behavior along the request/reply chain.}

\item{ChecksumAlgorithm}{Indicates the algorithm you want Amazon S3 to use to create the checksum
for the object. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.}

\item{ContentDisposition}{Specifies presentational information for the object.}

\item{ContentEncoding}{Specifies what content encodings have been applied to the object and
thus what decoding mechanisms must be applied to obtain the media-type
referenced by the Content-Type header field.}

\item{ContentLanguage}{The language the content is in.}

\item{ContentType}{A standard MIME type describing the format of the object data.}

\item{CopySource}{[required] Specifies the source object for the copy operation. You specify the
value in one of two formats, depending on whether you want to access the
source object through an \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html}{access point}:
\itemize{
\item For objects not accessed through an access point, specify the name
of the source bucket and the key of the source object, separated by
a slash (/). For example, to copy the object \code{reports/january.pdf}
from the bucket \code{awsexamplebucket}, use
\code{awsexamplebucket/reports/january.pdf}. The value must be
URL-encoded.
\item For objects accessed through access points, specify the Amazon
Resource Name (ARN) of the object as accessed through the access
point, in the format
\verb{arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>}.
For example, to copy the object \code{reports/january.pdf} through access
point \code{my-access-point} owned by account \code{123456789012} in Region
\code{us-west-2}, use the URL encoding of
\code{arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf}.
The value must be URL encoded.

Amazon S3 supports copy operations using access points only when the
source and destination buckets are in the same Amazon Web Services
Region.

Alternatively, for objects accessed through Amazon S3 on Outposts,
specify the ARN of the object as accessed in the format
\verb{arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>}.
For example, to copy the object \code{reports/january.pdf} through
outpost \code{my-outpost} owned by account \code{123456789012} in Region
\code{us-west-2}, use the URL encoding of
\code{arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf}.
The value must be URL-encoded.
}

To copy a specific version of an object, append
\verb{?versionId=<version-id>} to the value (for example,
\code{awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893}).
If you don't specify a version ID, Amazon S3 copies the latest version
of the source object.}

\item{CopySourceIfMatch}{Copies the object if its entity tag (ETag) matches the specified tag.}

\item{CopySourceIfModifiedSince}{Copies the object if it has been modified since the specified time.}

\item{CopySourceIfNoneMatch}{Copies the object if its entity tag (ETag) is different than the
specified ETag.}

\item{CopySourceIfUnmodifiedSince}{Copies the object if it hasn't been modified since the specified time.}

\item{Expires}{The date and time at which the object is no longer cacheable.}

\item{GrantFullControl}{Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the
object.

This action is not supported by Amazon S3 on Outposts.}

\item{GrantRead}{Allows grantee to read the object data and its metadata.

This action is not supported by Amazon S3 on Outposts.}

\item{GrantReadACP}{Allows grantee to read the object ACL.

This action is not supported by Amazon S3 on Outposts.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable object.

This action is not supported by Amazon S3 on Outposts.}

\item{Key}{[required] The key of the destination object.}

\item{Metadata}{A map of metadata to store with the object in S3.}

\item{MetadataDirective}{Specifies whether the metadata is copied from the source object or
replaced with metadata provided in the request.}

\item{TaggingDirective}{Specifies whether the object tag-set are copied from the source object
or replaced with tag-set provided in the request.}

\item{ServerSideEncryption}{The server-side encryption algorithm used when storing this object in
Amazon S3 (for example, AES256, \code{aws:kms}).}

\item{StorageClass}{By default, Amazon S3 uses the STANDARD Storage Class to store newly
created objects. The STANDARD storage class provides high durability and
high availability. Depending on performance needs, you can specify a
different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS
Storage Class. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html}{Storage Classes}
in the \emph{Amazon S3 User Guide}.}

\item{WebsiteRedirectLocation}{If the bucket is configured as a website, redirects requests for this
object to another object in the same bucket or to an external URL.
Amazon S3 stores the value of this header in the object metadata. This
value is unique to each object and is not copied when using the
\code{x-amz-metadata-directive} header. Instead, you may opt to provide this
header in combination with the directive.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when encrypting the object (for
example, AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon S3 does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
\code{x-amz-server-side-encryption-customer-algorithm} header.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
that the encryption key was transmitted without error.}

\item{SSEKMSKeyId}{Specifies the Amazon Web Services KMS key ID to use for object
encryption. All GET and PUT requests for an object protected by Amazon
Web Services KMS will fail if not made via SSL or using SigV4. For
information about configuring using any of the officially supported
Amazon Web Services SDKs and Amazon Web Services CLI, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingAWSSDK.html#specify-signature-version}{Specifying the Signature Version in Request Authentication}
in the \emph{Amazon S3 User Guide}.}

\item{SSEKMSEncryptionContext}{Specifies the Amazon Web Services KMS Encryption Context to use for
object encryption. The value of this header is a base64-encoded UTF-8
string holding JSON with the encryption context key-value pairs.}

\item{BucketKeyEnabled}{Specifies whether Amazon S3 should use an S3 Bucket Key for object
encryption with server-side encryption using AWS KMS (SSE-KMS). Setting
this header to \code{true} causes Amazon S3 to use an S3 Bucket Key for
object encryption with SSE-KMS.

Specifying this header with a COPY action doesn’t affect bucket-level
settings for S3 Bucket Key.}

\item{CopySourceSSECustomerAlgorithm}{Specifies the algorithm to use when decrypting the source object (for
example, AES256).}

\item{CopySourceSSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use to
decrypt the source object. The encryption key provided in this header
must be one that was used when the source object was created.}

\item{CopySourceSSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
that the encryption key was transmitted without error.}

\item{RequestPayer}{}

\item{Tagging}{The tag-set for the object destination object this value must be used in
conjunction with the \code{TaggingDirective}. The tag-set must be encoded as
URL Query parameters.}

\item{ObjectLockMode}{The Object Lock mode that you want to apply to the copied object.}

\item{ObjectLockRetainUntilDate}{The date and time when you want the copied object's Object Lock to
expire.}

\item{ObjectLockLegalHoldStatus}{Specifies whether you want to apply a legal hold to the copied object.}

\item{ExpectedBucketOwner}{The account ID of the expected destination bucket owner. If the
destination bucket is owned by a different account, the request fails
with the HTTP status code \verb{403 Forbidden} (access denied).}

\item{ExpectedSourceBucketOwner}{The account ID of the expected source bucket owner. If the source bucket
is owned by a different account, the request fails with the HTTP status
code \verb{403 Forbidden} (access denied).}
}
\description{
Creates a copy of an object that is already stored in Amazon S3.

See \url{https://www.paws-r-sdk.com/docs/s3_copy_object/} for full documentation.
}
\keyword{internal}
