% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_acl}
\alias{s3_get_bucket_acl}
\title{This implementation of the GET action uses the acl subresource to return
the access control list (ACL) of a bucket}
\usage{
s3_get_bucket_acl(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] Specifies the S3 bucket whose ACL is being requested.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
This implementation of the \code{GET} action uses the \code{acl} subresource to return the access control list (ACL) of a bucket. To use \code{GET} to return the ACL of the bucket, you must have \code{READ_ACP} access to the bucket. If \code{READ_ACP} permission is granted to the anonymous user, you can return the ACL of the bucket without using an authorization header.

See \url{https://paws-r.github.io/docs/s3/get_bucket_acl.html} for full documentation.
}
\keyword{internal}
