% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_update_volume}
\alias{fsx_update_volume}
\title{Updates the configuration of an Amazon FSx for NetApp ONTAP or Amazon
FSx for OpenZFS volume}
\usage{
fsx_update_volume(
  ClientRequestToken = NULL,
  VolumeId,
  OntapConfiguration = NULL,
  Name = NULL,
  OpenZFSConfiguration = NULL
)
}
\arguments{
\item{ClientRequestToken}{}

\item{VolumeId}{[required] The ID of the volume that you want to update, in the format
\verb{fsvol-0123456789abcdef0}.}

\item{OntapConfiguration}{The configuration of the ONTAP volume that you are updating.}

\item{Name}{The name of the OpenZFS volume. OpenZFS root volumes are automatically
named \code{FSX}. Child volume names must be unique among their parent
volume's children. The name of the volume is part of the mount string
for the OpenZFS volume.}

\item{OpenZFSConfiguration}{The configuration of the OpenZFS volume that you are updating.}
}
\description{
Updates the configuration of an Amazon FSx for NetApp ONTAP or Amazon FSx for OpenZFS volume.

See \url{https://paws-r.github.io/docs/fsx/update_volume.html} for full documentation.
}
\keyword{internal}
