% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_cachedi_scsi_volumes}
\alias{storagegateway_describe_cachedi_scsi_volumes}
\title{Returns a description of the gateway volumes specified in the request}
\usage{
storagegateway_describe_cachedi_scsi_volumes(VolumeARNs)
}
\arguments{
\item{VolumeARNs}{[required] An array of strings where each string represents the Amazon Resource
Name (ARN) of a cached volume. All of the specified cached volumes must
be from the same gateway. Use ListVolumes to get volume ARNs for a
gateway.}
}
\description{
Returns a description of the gateway volumes specified in the request.
This operation is only supported in the cached volume gateway types.
}
\details{
The list of gateway volumes in the request must be from one gateway. In
the response, AWS Storage Gateway returns volume information sorted by
volume Amazon Resource Name (ARN).
}
\section{Request syntax}{
\preformatted{svc$describe_cachedi_scsi_volumes(
  VolumeARNs = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# Returns a description of the gateway cached iSCSI volumes specified in
# the request.
svc$describe_cachedi_scsi_volumes(
  VolumeARNs = list(
    "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB"
  )
)
}

}
\keyword{internal}
