% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_update_file_system}
\alias{fsx_update_file_system}
\title{Updates a file system configuration}
\usage{
fsx_update_file_system(FileSystemId, ClientRequestToken,
  WindowsConfiguration, LustreConfiguration)
}
\arguments{
\item{FileSystemId}{[required]}

\item{ClientRequestToken}{(Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
ensure idempotent updates. This string is automatically filled on your
behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS
SDK.}

\item{WindowsConfiguration}{The configuration update for this Microsoft Windows file system. The
only supported options are for backup and maintenance and for
self-managed Active Directory configuration.}

\item{LustreConfiguration}{}
}
\description{
Updates a file system configuration.
}
\section{Request syntax}{
\preformatted{svc$update_file_system(
  FileSystemId = "string",
  ClientRequestToken = "string",
  WindowsConfiguration = list(
    WeeklyMaintenanceStartTime = "string",
    DailyAutomaticBackupStartTime = "string",
    AutomaticBackupRetentionDays = 123,
    SelfManagedActiveDirectoryConfiguration = list(
      UserName = "string",
      Password = "string",
      DnsIps = list(
        "string"
      )
    )
  ),
  LustreConfiguration = list(
    WeeklyMaintenanceStartTime = "string"
  )
)
}
}

\examples{
\dontrun{
# This operation updates an existing file system.
svc$update_file_system(
  FileSystemId = "fs-0498eed5fe91001ec",
  WindowsConfiguration = list(
    AutomaticBackupRetentionDays = 10L,
    DailyAutomaticBackupStartTime = "06:00",
    WeeklyMaintenanceStartTime = "3:06:00"
  )
)
}

}
\keyword{internal}
