% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_list_access_points}
\alias{s3control_list_access_points}
\title{Returns a list of the access points currently associated with the
specified bucket}
\usage{
s3control_list_access_points(AccountId, Bucket, NextToken, MaxResults)
}
\arguments{
\item{AccountId}{[required] The AWS account ID for owner of the bucket whose access points you want
to list.}

\item{Bucket}{The name of the bucket whose associated access points you want to list.

For using this parameter with Amazon S3 on Outposts with the REST API,
you must specify the name and the x-amz-outpost-id as well.

For using this parameter with S3 on Outposts with the AWS SDK and CLI,
you must specify the ARN of the bucket accessed in the format
\verb{arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>}.
For example, to access the bucket \code{reports} through outpost \code{my-outpost}
owned by account \code{123456789012} in Region \code{us-west-2}, use the URL
encoding of
\code{arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports}.
The value must be URL encoded.}

\item{NextToken}{A continuation token. If a previous call to
\code{\link[=s3control_list_access_points]{list_access_points}} returned a
continuation token in the \code{NextToken} field, then providing that value
here causes Amazon S3 to retrieve the next page of results.}

\item{MaxResults}{The maximum number of access points that you want to include in the
list. If the specified bucket has more than this number of access
points, then the response will include a continuation token in the
\code{NextToken} field that you can use to retrieve the next page of access
points.}
}
\value{
A list with the following syntax:\preformatted{list(
  AccessPointList = list(
    list(
      Name = "string",
      NetworkOrigin = "Internet"|"VPC",
      VpcConfiguration = list(
        VpcId = "string"
      ),
      Bucket = "string",
      AccessPointArn = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of the access points currently associated with the
specified bucket. You can retrieve up to 1000 access points per call. If
the specified bucket has more than 1,000 access points (or the number
specified in \code{maxResults}, whichever is less), the response will include
a continuation token that you can use to list the additional access
points.

All Amazon S3 on Outposts REST API requests for this action require an
additional parameter of \code{x-amz-outpost-id} to be passed with the request
and an S3 on Outposts endpoint hostname prefix instead of \code{s3-control}.
For an example of the request syntax for Amazon S3 on Outposts that uses
the S3 on Outposts endpoint hostname prefix and the \code{x-amz-outpost-id}
derived using the access point ARN, see the
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples}{Examples}
section.

The following actions are related to
\code{\link[=s3control_list_access_points]{list_access_points}}:
\itemize{
\item \code{\link[=s3control_create_access_point]{create_access_point}}
\item \code{\link[=s3control_delete_access_point]{delete_access_point}}
\item \code{\link[=s3control_get_access_point]{get_access_point}}
}
}
\section{Request syntax}{
\preformatted{svc$list_access_points(
  AccountId = "string",
  Bucket = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
