% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_update_job_priority}
\alias{s3control_update_job_priority}
\title{Updates an existing S3 Batch Operations job's priority}
\usage{
s3control_update_job_priority(AccountId, JobId, Priority)
}
\arguments{
\item{AccountId}{[required]}

\item{JobId}{[required] The ID for the job whose priority you want to update.}

\item{Priority}{[required] The priority you want to assign to this job.}
}
\value{
A list with the following syntax:\preformatted{list(
  JobId = "string",
  Priority = 123
)
}
}
\description{
Updates an existing S3 Batch Operations job's priority. For more
information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops-basics.html}{S3 Batch Operations}
in the \emph{Amazon Simple Storage Service Developer Guide}.

Related actions include:
\itemize{
\item \code{\link[=s3control_create_job]{create_job}}
\item \code{\link[=s3control_list_jobs]{list_jobs}}
\item \code{\link[=s3control_describe_job]{describe_job}}
\item \code{\link[=s3control_update_job_status]{update_job_status}}
}
}
\section{Request syntax}{
\preformatted{svc$update_job_priority(
  AccountId = "string",
  JobId = "string",
  Priority = 123
)
}
}

\keyword{internal}
