% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsmv2_service.R
\name{cloudhsmv2}
\alias{cloudhsmv2}
\title{AWS CloudHSM V2}
\usage{
cloudhsmv2(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
For more information about CloudHSM, see
\href{https://aws.amazon.com/cloudhsm/}{CloudHSM} and the \href{https://docs.aws.amazon.com/cloudhsm/latest/userguide/}{CloudHSM User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- cloudhsmv2(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=cloudhsmv2_copy_backup_to_region]{copy_backup_to_region} \tab Copy an CloudHSM cluster backup to a different region\cr
\link[=cloudhsmv2_create_cluster]{create_cluster} \tab Creates a new CloudHSM cluster\cr
\link[=cloudhsmv2_create_hsm]{create_hsm} \tab Creates a new hardware security module (HSM) in the specified CloudHSM cluster\cr
\link[=cloudhsmv2_delete_backup]{delete_backup} \tab Deletes a specified CloudHSM backup\cr
\link[=cloudhsmv2_delete_cluster]{delete_cluster} \tab Deletes the specified CloudHSM cluster\cr
\link[=cloudhsmv2_delete_hsm]{delete_hsm} \tab Deletes the specified HSM\cr
\link[=cloudhsmv2_delete_resource_policy]{delete_resource_policy} \tab Deletes an CloudHSM resource policy\cr
\link[=cloudhsmv2_describe_backups]{describe_backups} \tab Gets information about backups of CloudHSM clusters\cr
\link[=cloudhsmv2_describe_clusters]{describe_clusters} \tab Gets information about CloudHSM clusters\cr
\link[=cloudhsmv2_get_resource_policy]{get_resource_policy} \tab Retrieves the resource policy document attached to a given resource\cr
\link[=cloudhsmv2_initialize_cluster]{initialize_cluster} \tab Claims an CloudHSM cluster by submitting the cluster certificate issued by your issuing certificate authority (CA) and the CA's root certificate\cr
\link[=cloudhsmv2_list_tags]{list_tags} \tab Gets a list of tags for the specified CloudHSM cluster\cr
\link[=cloudhsmv2_modify_backup_attributes]{modify_backup_attributes} \tab Modifies attributes for CloudHSM backup\cr
\link[=cloudhsmv2_modify_cluster]{modify_cluster} \tab Modifies CloudHSM cluster\cr
\link[=cloudhsmv2_put_resource_policy]{put_resource_policy} \tab Creates or updates an CloudHSM resource policy\cr
\link[=cloudhsmv2_restore_backup]{restore_backup} \tab Restores a specified CloudHSM backup that is in the PENDING_DELETION state\cr
\link[=cloudhsmv2_tag_resource]{tag_resource} \tab Adds or overwrites one or more tags for the specified CloudHSM cluster\cr
\link[=cloudhsmv2_untag_resource]{untag_resource} \tab Removes the specified tag or tags from the specified CloudHSM cluster
}
}

\examples{
\dontrun{
svc <- cloudhsmv2()
svc$copy_backup_to_region(
  Foo = 123
)
}

}
