% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macie2_operations.R
\name{macie2_get_usage_statistics}
\alias{macie2_get_usage_statistics}
\title{Retrieves (queries) quotas and aggregated usage data for one or more
accounts}
\usage{
macie2_get_usage_statistics(
  filterBy = NULL,
  maxResults = NULL,
  nextToken = NULL,
  sortBy = NULL,
  timeRange = NULL
)
}
\arguments{
\item{filterBy}{An array of objects, one for each condition to use to filter the query
results. If you specify more than one condition, Amazon Macie uses an
AND operator to join the conditions.}

\item{maxResults}{The maximum number of items to include in each page of the response.}

\item{nextToken}{The nextToken string that specifies which page of results to return in a
paginated response.}

\item{sortBy}{The criteria to use to sort the query results.}

\item{timeRange}{The inclusive time period to query usage data for. Valid values are:
MONTH_TO_DATE, for the current calendar month to date; and,
PAST_30_DAYS, for the preceding 30 days. If you don't specify a value,
Amazon Macie provides usage data for the preceding 30 days.}
}
\description{
Retrieves (queries) quotas and aggregated usage data for one or more accounts.

See \url{https://www.paws-r-sdk.com/docs/macie2_get_usage_statistics/} for full documentation.
}
\keyword{internal}
