% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_forgot_password}
\alias{cognitoidentityprovider_forgot_password}
\title{Calling this API causes a message to be sent to the end user with a
confirmation code that is required to change the user's password}
\usage{
cognitoidentityprovider_forgot_password(
  ClientId,
  SecretHash = NULL,
  UserContextData = NULL,
  Username,
  AnalyticsMetadata = NULL,
  ClientMetadata = NULL
)
}
\arguments{
\item{ClientId}{[required] The ID of the client associated with the user pool.}

\item{SecretHash}{A keyed-hash message authentication code (HMAC) calculated using the
secret key of a user pool client and username plus the client ID in the
message.}

\item{UserContextData}{Contextual data about your user session, such as the device fingerprint,
IP address, or location. Amazon Cognito advanced security evaluates the
risk of an authentication event based on the context that your app
generates and passes to Amazon Cognito when it makes API requests.}

\item{Username}{[required] The username of the user that you want to query or modify. The value of
this parameter is typically your user's username, but it can be any of
their alias attributes. If \code{username} isn't an alias attribute in your
user pool, this value must be the \code{sub} of a local user or the username
of a user from a third-party IdP.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata that contributes to your metrics
for \code{\link[=cognitoidentityprovider_forgot_password]{forgot_password}} calls.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

You create custom workflows by assigning Lambda functions to user pool
triggers. When you use the ForgotPassword API action, Amazon Cognito
invokes any functions that are assigned to the following triggers: \emph{pre
sign-up}, \emph{custom message}, and \emph{user migration}. When Amazon Cognito
invokes any of these functions, it passes a JSON payload, which the
function receives as input. This payload contains a \code{clientMetadata}
attribute, which provides the data that you assigned to the
ClientMetadata parameter in your ForgotPassword request. In your
function code in Lambda, you can process the \code{clientMetadata} value to
enhance your workflow for your specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-working-with-lambda-triggers.html}{Customizing user pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

When you use the ClientMetadata parameter, remember that Amazon Cognito
won't do the following:
\itemize{
\item Store the ClientMetadata value. This data is available only to
Lambda triggers that are assigned to a user pool to support custom
workflows. If your user pool configuration doesn't include triggers,
the ClientMetadata parameter serves no purpose.
\item Validate the ClientMetadata value.
\item Encrypt the ClientMetadata value. Don't use Amazon Cognito to
provide sensitive information.
}}
}
\description{
Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password. For the \code{Username} parameter, you can use the username or user alias. The method used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html}{Recovering User Accounts} in the \emph{Amazon Cognito Developer Guide}. To use the confirmation code for resetting the password, call \code{\link[=cognitoidentityprovider_confirm_forgot_password]{confirm_forgot_password}}.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_forgot_password/} for full documentation.
}
\keyword{internal}
