% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_list_outgoing_typed_links}
\alias{clouddirectory_list_outgoing_typed_links}
\title{Returns a paginated list of all the outgoing TypedLinkSpecifier
information for an object}
\usage{
clouddirectory_list_outgoing_typed_links(
  DirectoryArn,
  ObjectReference,
  FilterAttributeRanges = NULL,
  FilterTypedLink = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  ConsistencyLevel = NULL
)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) of the directory where you want to list
the typed links.}

\item{ObjectReference}{[required] A reference that identifies the object whose attributes will be listed.}

\item{FilterAttributeRanges}{Provides range filters for multiple attributes. When providing ranges to
typed link selection, any inexact ranges must be specified at the end.
Any attributes that do not have a range specified are presumed to match
the entire range.}

\item{FilterTypedLink}{Filters are interpreted in the order of the attributes defined on the
typed link facet, not the order they are supplied to any API calls.}

\item{NextToken}{The pagination token.}

\item{MaxResults}{The maximum number of results to retrieve.}

\item{ConsistencyLevel}{The consistency level to execute the request at.}
}
\description{
Returns a paginated list of all the outgoing TypedLinkSpecifier information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see \href{https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink}{Typed Links}.

See \url{https://www.paws-r-sdk.com/docs/clouddirectory_list_outgoing_typed_links/} for full documentation.
}
\keyword{internal}
