% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_update_organization_configuration}
\alias{guardduty_update_organization_configuration}
\title{Configures the delegated administrator account with the provided values}
\usage{
guardduty_update_organization_configuration(
  DetectorId,
  AutoEnable = NULL,
  DataSources = NULL,
  Features = NULL,
  AutoEnableOrganizationMembers = NULL
)
}
\arguments{
\item{DetectorId}{[required] The ID of the detector that configures the delegated administrator.}

\item{AutoEnable}{Indicates whether to automatically enable member accounts in the
organization.

Even though this is still supported, we recommend using
\code{AutoEnableOrganizationMembers} to achieve the similar results.}

\item{DataSources}{Describes which data sources will be updated.}

\item{Features}{A list of features that will be configured for the organization.}

\item{AutoEnableOrganizationMembers}{Indicates the auto-enablement configuration of GuardDuty for the member
accounts in the organization.
\itemize{
\item \code{NEW}: Indicates that when a new account joins the organization,
they will have GuardDuty enabled automatically.
\item \code{ALL}: Indicates that all accounts in the Amazon Web Services
Organization have GuardDuty enabled automatically. This includes
\code{NEW} accounts that join the organization and accounts that may have
been suspended or removed from the organization in GuardDuty.
\item \code{NONE}: Indicates that GuardDuty will not be automatically enabled
for any accounts in the organization. GuardDuty must be managed for
each account individually by the administrator.
}}
}
\description{
Configures the delegated administrator account with the provided values. You must provide the value for either \code{autoEnableOrganizationMembers} or \code{autoEnable}.

See \url{https://www.paws-r-sdk.com/docs/guardduty_update_organization_configuration/} for full documentation.
}
\keyword{internal}
