% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_import_key_material}
\alias{kms_import_key_material}
\title{Imports key material into an existing symmetric encryption KMS key that
was created without key material}
\usage{
kms_import_key_material(
  KeyId,
  ImportToken,
  EncryptedKeyMaterial,
  ValidTo = NULL,
  ExpirationModel = NULL
)
}
\arguments{
\item{KeyId}{[required] The identifier of the symmetric encryption KMS key that receives the
imported key material. This must be the same KMS key specified in the
\code{KeyID} parameter of the corresponding
\code{\link[=kms_get_parameters_for_import]{get_parameters_for_import}} request.
The \code{Origin} of the KMS key must be \code{EXTERNAL}. You cannot perform this
operation on an asymmetric KMS key, an HMAC KMS key, a KMS key in a
custom key store, or on a KMS key in a different Amazon Web Services
account

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{ImportToken}{[required] The import token that you received in the response to a previous
\code{\link[=kms_get_parameters_for_import]{get_parameters_for_import}} request. It
must be from the same response that contained the public key that you
used to encrypt the key material.}

\item{EncryptedKeyMaterial}{[required] The encrypted key material to import. The key material must be encrypted
with the public wrapping key that
\code{\link[=kms_get_parameters_for_import]{get_parameters_for_import}} returned,
using the wrapping algorithm that you specified in the same
\code{\link[=kms_get_parameters_for_import]{get_parameters_for_import}} request.}

\item{ValidTo}{The time at which the imported key material expires. When the key
material expires, KMS deletes the key material and the KMS key becomes
unusable. You must omit this parameter when the \code{ExpirationModel}
parameter is set to \code{KEY_MATERIAL_DOES_NOT_EXPIRE}. Otherwise it is
required.}

\item{ExpirationModel}{Specifies whether the key material expires. The default is
\code{KEY_MATERIAL_EXPIRES}, in which case you must include the \code{ValidTo}
parameter. When this parameter is set to \code{KEY_MATERIAL_DOES_NOT_EXPIRE},
you must omit the \code{ValidTo} parameter.}
}
\description{
Imports key material into an existing symmetric encryption KMS key that was created without key material. After you successfully import key material into a KMS key, you can \href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#reimport-key-material}{reimport the same key material} into that KMS key, but you cannot import different key material.

See \url{https://paws-r.github.io/docs/kms/import_key_material.html} for full documentation.
}
\keyword{internal}
