% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iamrolesanywhere_operations.R
\name{iamrolesanywhere_update_profile}
\alias{iamrolesanywhere_update_profile}
\title{Updates the profile}
\usage{
iamrolesanywhere_update_profile(
  durationSeconds = NULL,
  managedPolicyArns = NULL,
  name = NULL,
  profileId,
  roleArns = NULL,
  sessionPolicy = NULL
)
}
\arguments{
\item{durationSeconds}{The number of seconds the vended session credentials are valid for.}

\item{managedPolicyArns}{A list of managed policy ARNs that apply to the vended session
credentials.}

\item{name}{The name of the profile.}

\item{profileId}{[required] The unique identifier of the profile.}

\item{roleArns}{A list of IAM roles that this profile can assume in a
\href{https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/}{CreateSession}
operation.}

\item{sessionPolicy}{A session policy that applies to the trust boundary of the vended
session credentials.}
}
\description{
Updates the profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted to assume. In addition, by applying a profile you can scope-down permissions with IAM managed policies.

See \url{https://paws-r.github.io/docs/iamrolesanywhere/update_profile.html} for full documentation.
}
\keyword{internal}
