% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_untag_policy}
\alias{iam_untag_policy}
\title{Removes the specified tags from the customer managed policy}
\usage{
iam_untag_policy(PolicyArn, TagKeys)
}
\arguments{
\item{PolicyArn}{[required] The ARN of the IAM customer managed policy from which you want to remove
tags.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{TagKeys}{[required] A list of key names as a simple array of strings. The tags with matching
keys are removed from the specified policy.}
}
\description{
Removes the specified tags from the customer managed policy. For more information about tagging, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html}{Tagging IAM resources} in the \emph{IAM User Guide}.

See \url{https://paws-r.github.io/docs/iam/untag_policy.html} for full documentation.
}
\keyword{internal}
