% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_import_certificate_authority_certificate}
\alias{acmpca_import_certificate_authority_certificate}
\title{Imports a signed private CA certificate into ACM Private CA}
\usage{
acmpca_import_certificate_authority_certificate(
  CertificateAuthorityArn,
  Certificate,
  CertificateChain = NULL
)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
\code{\link[=acmpca_create_certificate_authority]{create_certificate_authority}}.
This must be of the form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 }}

\item{Certificate}{[required] The PEM-encoded certificate for a private CA. This may be a self-signed
certificate in the case of a root CA, or it may be signed by another CA
that you control.}

\item{CertificateChain}{A PEM-encoded file that contains all of your certificates, other than
the certificate you're importing, chaining up to your root CA. Your ACM
Private CA-hosted or on-premises root certificate is the last in the
chain, and each certificate in the chain signs the one preceding.

This parameter must be supplied when you import a subordinate CA. When
you import a root CA, there is no chain.}
}
\description{
Imports a signed private CA certificate into ACM Private CA. This action is used when you are using a chain of trust whose root is located outside ACM Private CA. Before you can call this action, the following preparations must in place:

See \url{https://paws-r.github.io/docs/acmpca/import_certificate_authority_certificate.html} for full documentation.
}
\keyword{internal}
