% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_create_key}
\alias{kms_create_key}
\title{Creates a unique customer managed KMS key in your Amazon Web Services
account and Region}
\usage{
kms_create_key(
  Policy = NULL,
  Description = NULL,
  KeyUsage = NULL,
  CustomerMasterKeySpec = NULL,
  KeySpec = NULL,
  Origin = NULL,
  CustomKeyStoreId = NULL,
  BypassPolicyLockoutSafetyCheck = NULL,
  Tags = NULL,
  MultiRegion = NULL
)
}
\arguments{
\item{Policy}{The key policy to attach to the KMS key. If you do not specify a key
policy, KMS attaches a default key policy to the KMS key. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default}{Default key policy}
in the \emph{Key Management Service Developer Guide}.

If you provide a key policy, it must meet the following criteria:
\itemize{
\item If you don't set \code{BypassPolicyLockoutSafetyCheck} to \code{True}, the key
policy must allow the principal that is making the
\code{\link[=kms_create_key]{create_key}} request to make a subsequent
\code{\link[=kms_put_key_policy]{put_key_policy}} request on the KMS key. This
reduces the risk that the KMS key becomes unmanageable. For more
information, refer to the scenario in the \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam}{Default Key Policy}
section of the \emph{Key Management Service Developer Guide} .
\item Each statement in the key policy must contain one or more
principals. The principals in the key policy must exist and be
visible to KMS. When you create a new Amazon Web Services principal
(for example, an IAM user or role), you might need to enforce a
delay before including the new principal in a key policy because the
new principal might not be immediately visible to KMS. For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency}{Changes that I make are not always immediately visible}
in the \emph{Amazon Web Services Identity and Access Management User
Guide}.
}

A key policy document can include only the following characters:
\itemize{
\item Printable ASCII characters from the space character (\code{U+0020})
through the end of the ASCII character range.
\item Printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF}).
\item The tab (\code{U+0009}), line feed (\verb{U+000A}), and carriage return
(\verb{U+000D}) special characters
}

For information about key policies, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html}{Key policies in KMS}
in the \emph{Key Management Service Developer Guide}. For help writing and
formatting a JSON policy document, see the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html}{IAM JSON Policy Reference}
in the \emph{Identity and Access Management User Guide} .}

\item{Description}{A description of the KMS key.

Use a description that helps you decide whether the KMS key is
appropriate for a task. The default value is an empty string (no
description).

To set or change the description after the key is created, use
\code{\link[=kms_update_key_description]{update_key_description}}.}

\item{KeyUsage}{Determines the \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations}{cryptographic operations}
for which you can use the KMS key. The default value is
\code{ENCRYPT_DECRYPT}. This parameter is optional when you are creating a
symmetric encryption KMS key; otherwise, it is required. You can't
change the \code{KeyUsage} value after the KMS key is created.

Select only one valid value.
\itemize{
\item For symmetric encryption KMS keys, omit the parameter or specify
\code{ENCRYPT_DECRYPT}.
\item For HMAC KMS keys (symmetric), specify \code{GENERATE_VERIFY_MAC}.
\item For asymmetric KMS keys with RSA key material, specify
\code{ENCRYPT_DECRYPT} or \code{SIGN_VERIFY}.
\item For asymmetric KMS keys with ECC key material, specify
\code{SIGN_VERIFY}.
\item For asymmetric KMS keys with SM2 key material (China Regions only),
specify \code{ENCRYPT_DECRYPT} or \code{SIGN_VERIFY}.
}}

\item{CustomerMasterKeySpec}{Instead, use the \code{KeySpec} parameter.

The \code{KeySpec} and \code{CustomerMasterKeySpec} parameters work the same way.
Only the names differ. We recommend that you use \code{KeySpec} parameter in
your code. However, to avoid breaking changes, KMS will support both
parameters.}

\item{KeySpec}{Specifies the type of KMS key to create. The default value,
\code{SYMMETRIC_DEFAULT}, creates a KMS key with a 256-bit AES-GCM key that
is used for encryption and decryption, except in China Regions, where it
creates a 128-bit symmetric key that uses SM4 encryption. For help
choosing a key spec for your KMS key, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-types.html#symm-asymm-choose}{Choosing a KMS key type}
in the \emph{Key Management Service Developer Guide} .

The \code{KeySpec} determines whether the KMS key contains a symmetric key or
an asymmetric key pair. It also determines the cryptographic algorithms
that the KMS key supports. You can't change the \code{KeySpec} after the KMS
key is created. To further restrict the algorithms that can be used with
the KMS key, use a condition key in its key policy or IAM policy. For
more information, see
\href{https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-encryption-algorithm}{kms:EncryptionAlgorithm},
\href{https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-mac-algorithm}{kms:MacAlgorithm}
or \href{https://docs.aws.amazon.com/kms/latest/developerguide/policy-conditions.html#conditions-kms-signing-algorithm}{kms:Signing Algorithm}
in the \emph{Key Management Service Developer Guide} .

\href{https://aws.amazon.com/kms/features/#AWS_Service_Integration}{Amazon Web Services services that are integrated with KMS} use
symmetric encryption KMS keys to protect your data. These services do
not support asymmetric KMS keys or HMAC KMS keys.

KMS supports the following key specs for KMS keys:
\itemize{
\item Symmetric encryption key (default)
\itemize{
\item \code{SYMMETRIC_DEFAULT}
}
\item HMAC keys (symmetric)
\itemize{
\item \code{HMAC_224}
\item \code{HMAC_256}
\item \code{HMAC_384}
\item \code{HMAC_512}
}
\item Asymmetric RSA key pairs
\itemize{
\item \code{RSA_2048}
\item \code{RSA_3072}
\item \code{RSA_4096}
}
\item Asymmetric NIST-recommended elliptic curve key pairs
\itemize{
\item \code{ECC_NIST_P256} (secp256r1)
\item \code{ECC_NIST_P384} (secp384r1)
\item \code{ECC_NIST_P521} (secp521r1)
}
\item Other asymmetric elliptic curve key pairs
\itemize{
\item \code{ECC_SECG_P256K1} (secp256k1), commonly used for
cryptocurrencies.
}
\item SM2 key pairs (China Regions only)
\itemize{
\item \code{SM2}
}
}}

\item{Origin}{The source of the key material for the KMS key. You cannot change the
origin after you create the KMS key. The default is \code{AWS_KMS}, which
means that KMS creates the key material.

To create a KMS key with no key material (for imported key material),
set the value to \code{EXTERNAL}. For more information about importing key
material into KMS, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html}{Importing Key Material}
in the \emph{Key Management Service Developer Guide}. This value is valid
only for symmetric encryption KMS keys.

To create a KMS key in an KMS \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store}
and create its key material in the associated CloudHSM cluster, set this
value to \code{AWS_CLOUDHSM}. You must also use the \code{CustomKeyStoreId}
parameter to identify the custom key store. This value is valid only for
symmetric encryption KMS keys.}

\item{CustomKeyStoreId}{Creates the KMS key in the specified \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store}
and the key material in its associated CloudHSM cluster. To create a KMS
key in a custom key store, you must also specify the \code{Origin} parameter
with a value of \code{AWS_CLOUDHSM}. The CloudHSM cluster that is associated
with the custom key store must have at least two active HSMs, each in a
different Availability Zone in the Region.

This parameter is valid only for symmetric encryption KMS keys in a
single Region. You cannot create any other type of KMS key in a custom
key store.

To find the ID of a custom key store, use the
\code{\link[=kms_describe_custom_key_stores]{describe_custom_key_stores}}
operation.

The response includes the custom key store ID and the ID of the CloudHSM
cluster.

This operation is part of the \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store feature}
feature in KMS, which combines the convenience and extensive integration
of KMS with the isolation and control of a single-tenant key store.}

\item{BypassPolicyLockoutSafetyCheck}{A flag to indicate whether to bypass the key policy lockout safety
check.

Setting this value to true increases the risk that the KMS key becomes
unmanageable. Do not set this value to true indiscriminately.

For more information, refer to the scenario in the \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam}{Default Key Policy}
section in the \emph{Key Management Service Developer Guide} .

Use this parameter only when you include a policy in the request and you
intend to prevent the principal that is making the request from making a
subsequent \code{\link[=kms_put_key_policy]{put_key_policy}} request on the KMS
key.

The default value is false.}

\item{Tags}{Assigns one or more tags to the KMS key. Use this parameter to tag the
KMS key when it is created. To tag an existing KMS key, use the
\code{\link[=kms_tag_resource]{tag_resource}} operation.

Tagging or untagging a KMS key can allow or deny permission to the KMS
key. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/abac.html}{ABAC in KMS} in
the \emph{Key Management Service Developer Guide}.

To use this parameter, you must have
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:TagResource}
permission in an IAM policy.

Each tag consists of a tag key and a tag value. Both the tag key and the
tag value are required, but the tag value can be an empty (null) string.
You cannot have more than one tag on a KMS key with the same tag key. If
you specify an existing tag key with a different tag value, KMS replaces
the current tag value with the specified one.

When you add tags to an Amazon Web Services resource, Amazon Web
Services generates a cost allocation report with usage and costs
aggregated by tags. Tags can also be used to control access to a KMS
key. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html}{Tagging Keys}.}

\item{MultiRegion}{Creates a multi-Region primary key that you can replicate into other
Amazon Web Services Regions. You cannot change this value after you
create the KMS key.

For a multi-Region key, set this parameter to \code{True}. For a
single-Region KMS key, omit this parameter or set it to \code{False}. The
default value is \code{False}.

This operation supports \emph{multi-Region keys}, an KMS feature that lets
you create multiple interoperable KMS keys in different Amazon Web
Services Regions. Because these KMS keys have the same key ID, key
material, and other metadata, you can use them interchangeably to
encrypt data in one Amazon Web Services Region and decrypt it in a
different Amazon Web Services Region without re-encrypting the data or
making a cross-Region call. For more information about multi-Region
keys, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html}{Multi-Region keys in KMS}
in the \emph{Key Management Service Developer Guide}.

This value creates a \emph{primary key}, not a replica. To create a \emph{replica
key}, use the \code{\link[=kms_replicate_key]{replicate_key}} operation.

You can create a multi-Region version of a symmetric encryption KMS key,
an HMAC KMS key, an asymmetric KMS key, or a KMS key with imported key
material. However, you cannot create a multi-Region key in a custom key
store.}
}
\description{
Creates a unique customer managed \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms-keys}{KMS key} in your Amazon Web Services account and Region.

See \url{https://paws-r.github.io/docs/kms/create_key.html} for full documentation.
}
\keyword{internal}
