% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_tag_role}
\alias{iam_tag_role}
\title{Adds one or more tags to an IAM role}
\usage{
iam_tag_role(RoleName, Tags)
}
\arguments{
\item{RoleName}{[required] The name of the IAM role to which you want to add tags.

This parameter accepts (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
that consist of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Tags}{[required] The list of tags that you want to attach to the IAM role. Each tag
consists of a key name and an associated value.}
}
\description{
Adds one or more tags to an IAM role. The role can be a regular role or a service-linked role. If a tag with the same key name already exists, then that tag is overwritten with the new value.

See \url{https://paws-r.github.io/docs/iam/tag_role.html} for full documentation.
}
\keyword{internal}
