% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_create_permission}
\alias{acmpca_create_permission}
\title{Grants one or more permissions on a private CA to the Certificate
Manager (ACM) service principal (acm}
\usage{
acmpca_create_permission(
  CertificateAuthorityArn,
  Principal,
  SourceAccount = NULL,
  Actions
)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) of the CA that grants the permissions.
You can find the ARN by calling the
\code{\link[=acmpca_list_certificate_authorities]{list_certificate_authorities}}
action. This must have the following form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 }.}

\item{Principal}{[required] The Amazon Web Services service or identity that receives the
permission. At this time, the only valid principal is
\code{acm.amazonaws.com}.}

\item{SourceAccount}{The ID of the calling account.}

\item{Actions}{[required] The actions that the specified Amazon Web Services service principal can
use. These include \code{\link[=acmpca_issue_certificate]{issue_certificate}},
\code{\link[=acmpca_get_certificate]{get_certificate}}, and
\code{\link[=acmpca_list_permissions]{list_permissions}}.}
}
\description{
Grants one or more permissions on a private CA to the Certificate Manager (ACM) service principal (\code{acm.amazonaws.com}). These permissions allow ACM to issue and renew ACM certificates that reside in the same Amazon Web Services account as the CA.

See \url{https://paws-r.github.io/docs/acmpca/create_permission.html} for full documentation.
}
\keyword{internal}
