% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_create_certificate_authority}
\alias{acmpca_create_certificate_authority}
\title{Creates a root or subordinate private certificate authority (CA)}
\usage{
acmpca_create_certificate_authority(
  CertificateAuthorityConfiguration,
  RevocationConfiguration = NULL,
  CertificateAuthorityType,
  IdempotencyToken = NULL,
  KeyStorageSecurityStandard = NULL,
  Tags = NULL
)
}
\arguments{
\item{CertificateAuthorityConfiguration}{[required] Name and bit size of the private key algorithm, the name of the signing
algorithm, and X.500 certificate subject information.}

\item{RevocationConfiguration}{Contains information to enable Online Certificate Status Protocol (OCSP)
support, to enable a certificate revocation list (CRL), to enable both,
or to enable neither. The default is for both certificate validation
mechanisms to be disabled. For more information, see the
OcspConfiguration and CrlConfiguration types.}

\item{CertificateAuthorityType}{[required] The type of the certificate authority.}

\item{IdempotencyToken}{Custom string that can be used to distinguish between calls to the
\strong{CreateCertificateAuthority} action. Idempotency tokens for
\strong{CreateCertificateAuthority} time out after five minutes. Therefore,
if you call \strong{CreateCertificateAuthority} multiple times with the same
idempotency token within five minutes, ACM Private CA recognizes that
you are requesting only certificate authority and will issue only one.
If you change the idempotency token for each call, PCA recognizes that
you are requesting multiple certificate authorities.}

\item{KeyStorageSecurityStandard}{Specifies a cryptographic key management compliance standard used for
handling CA keys.

Default: FIPS_140_2_LEVEL_3_OR_HIGHER

\emph{Note:} \code{FIPS_140_2_LEVEL_3_OR_HIGHER} is not supported in the following
Regions:
\itemize{
\item ap-northeast-3
\item ap-southeast-3
}

When creating a CA in these Regions, you must provide
\code{FIPS_140_2_LEVEL_2_OR_HIGHER} as the argument for
\code{KeyStorageSecurityStandard}. Failure to do this results in an
\code{InvalidArgsException} with the message, "A certificate authority cannot
be created in this region with the specified security standard."}

\item{Tags}{Key-value pairs that will be attached to the new private CA. You can
associate up to 50 tags with a private CA. For information using tags
with IAM to manage permissions, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html}{Controlling Access Using IAM Tags}.}
}
\description{
Creates a root or subordinate private certificate authority (CA). You must specify the CA configuration, an optional configuration for Online Certificate Status Protocol (OCSP) and/or a certificate revocation list (CRL), the CA type, and an optional idempotency token to avoid accidental creation of multiple CAs. The CA configuration specifies the name of the algorithm and key size to be used to create the CA private key, the type of signing algorithm that the CA uses, and X.500 subject information. The OCSP configuration can optionally specify a custom URL for the OCSP responder. The CRL configuration specifies the CRL expiration period in days (the validity period of the CRL), the Amazon S3 bucket that will contain the CRL, and a CNAME alias for the S3 bucket that is included in certificates issued by the CA. If successful, this action returns the Amazon Resource Name (ARN) of the CA.

See \url{https://paws-r.github.io/docs/acmpca/create_certificate_authority.html} for full documentation.
}
\keyword{internal}
