% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_detach_user_policy}
\alias{iam_detach_user_policy}
\title{Removes the specified managed policy from the specified user}
\usage{
iam_detach_user_policy(UserName, PolicyArn)
}
\arguments{
\item{UserName}{[required] The name (friendly name, not ARN) of the IAM user to detach the policy
from.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}

\item{PolicyArn}{[required] The Amazon Resource Name (ARN) of the IAM policy you want to detach.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}
}
\description{
Removes the specified managed policy from the specified user.
}
\details{
A user can also have inline policies embedded with it. To delete an
inline policy, use the DeleteUserPolicy API. For information about
policies, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$detach_user_policy(
  UserName = "string",
  PolicyArn = "string"
)
}
}

\keyword{internal}
