% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield_operations.R
\name{shield_associate_drt_log_bucket}
\alias{shield_associate_drt_log_bucket}
\title{Authorizes the DDoS Response team (DRT) to access the specified Amazon
S3 bucket containing your AWS WAF logs}
\usage{
shield_associate_drt_log_bucket(LogBucket)
}
\arguments{
\item{LogBucket}{[required] The Amazon S3 bucket that contains your AWS WAF logs.}
}
\description{
Authorizes the DDoS Response team (DRT) to access the specified Amazon
S3 bucket containing your AWS WAF logs. You can associate up to 10
Amazon S3 buckets with your subscription.
}
\details{
To use the services of the DRT and make an \code{AssociateDRTLogBucket}
request, you must be subscribed to the \href{https://aws.amazon.com/premiumsupport/business-support/}{Business Support plan} or the
\href{https://aws.amazon.com/premiumsupport/enterprise-support/}{Enterprise Support plan}.
}
\section{Request syntax}{
\preformatted{svc$associate_drt_log_bucket(
  LogBucket = "string"
)
}
}

\keyword{internal}
