% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_create_resource_share}
\alias{ram_create_resource_share}
\title{Creates a resource share}
\usage{
ram_create_resource_share(name, resourceArns, principals, tags,
  allowExternalPrincipals, clientToken, permissionArns)
}
\arguments{
\item{name}{[required] The name of the resource share.}

\item{resourceArns}{The Amazon Resource Names (ARN) of the resources to associate with the
resource share.}

\item{principals}{The principals to associate with the resource share. The possible values
are IDs of AWS accounts, the ARN of an OU or organization from AWS
Organizations.}

\item{tags}{One or more tags.}

\item{allowExternalPrincipals}{Indicates whether principals outside your AWS organization can be
associated with a resource share.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}

\item{permissionArns}{The ARNs of the permissions to associate with the resource share. If you
do not specify an ARN for the permission, AWS RAM automatically attaches
the default version of the permission for each resource type.}
}
\description{
Creates a resource share.
}
\section{Request syntax}{
\preformatted{svc$create_resource_share(
  name = "string",
  resourceArns = list(
    "string"
  ),
  principals = list(
    "string"
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  allowExternalPrincipals = TRUE|FALSE,
  clientToken = "string",
  permissionArns = list(
    "string"
  )
)
}
}

\keyword{internal}
