# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' Amazon Macie
#'
#' @description
#' Amazon Macie is a security service that uses machine learning to
#' automatically discover, classify, and protect sensitive data in AWS.
#' Macie recognizes sensitive data such as personally identifiable
#' information (PII) or intellectual property, and provides you with
#' dashboards and alerts that give visibility into how this data is being
#' accessed or moved. For more information, see the [Macie User
#' Guide](https://docs.aws.amazon.com/macie/latest/userguide/what-is-macie.html).
#'
#' @examples
#' \donttest{svc <- macie()
#' svc$associate_member_account(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=macie_associate_member_account]{associate_member_account} \tab Associates a specified AWS account with Amazon Macie as a member account \cr
#'  \link[=macie_associate_s3_resources]{associate_s3_resources} \tab Associates specified S3 resources with Amazon Macie for monitoring and data classification\cr
#'  \link[=macie_disassociate_member_account]{disassociate_member_account} \tab Removes the specified member account from Amazon Macie \cr
#'  \link[=macie_disassociate_s3_resources]{disassociate_s3_resources} \tab Removes specified S3 resources from being monitored by Amazon Macie \cr
#'  \link[=macie_list_member_accounts]{list_member_accounts} \tab Lists all Amazon Macie member accounts for the current Amazon Macie master account \cr
#'  \link[=macie_list_s3_resources]{list_s3_resources} \tab Lists all the S3 resources associated with Amazon Macie \cr
#'  \link[=macie_update_s3_resources]{update_s3_resources} \tab Updates the classification types for the specified S3 resources 
#' }
#'
#' @rdname macie
#' @export
macie <- function() {
  .macie$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.macie <- list()

.macie$operations <- list()

.macie$metadata <- list(
  service_name = "macie",
  endpoints = list("*" = list(endpoint = "macie.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "macie.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Macie",
  api_version = "2017-12-19",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "MacieService"
)

.macie$handlers <- new_handlers("jsonrpc", "v4")

.macie$service <- function() {
  new_service(.macie$metadata, .macie$handlers)
}
