% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_merge_developer_identities}
\alias{cognitoidentity_merge_developer_identities}
\title{Merges two users having different IdentityIds, existing in the same
identity pool, and identified by the same developer provider}
\usage{
cognitoidentity_merge_developer_identities(SourceUserIdentifier,
  DestinationUserIdentifier, DeveloperProviderName, IdentityPoolId)
}
\arguments{
\item{SourceUserIdentifier}{[required] User identifier for the source user. The value should be a
\code{DeveloperUserIdentifier}.}

\item{DestinationUserIdentifier}{[required] User identifier for the destination user. The value should be a
\code{DeveloperUserIdentifier}.}

\item{DeveloperProviderName}{[required] The "domain" by which Cognito will refer to your users. This is a
(pseudo) domain name that you provide while creating an identity pool.
This name acts as a placeholder that allows your backend and the Cognito
service to communicate about the developer provider. For the
\code{DeveloperProviderName}, you can use letters as well as period (.),
underscore (\_), and dash (-).}

\item{IdentityPoolId}{[required] An identity pool ID in the format REGION:GUID.}
}
\description{
Merges two users having different \code{IdentityId}s, existing in the same
identity pool, and identified by the same developer provider. You can
use this action to request that discrete users be merged and identified
as a single user in the Cognito environment. Cognito associates the
given source user (\code{SourceUserIdentifier}) with the \code{IdentityId} of the
\code{DestinationUserIdentifier}. Only developer-authenticated users can be
merged. If the users to be merged are associated with the same public
provider, but as two different users, an exception will be thrown.
}
\details{
The number of linked logins is limited to 20. So, the number of linked
logins for the source user, \code{SourceUserIdentifier}, and the destination
user, \code{DestinationUserIdentifier}, together should not be larger than
20. Otherwise, an exception will be thrown.

You must use AWS Developer credentials to call this API.
}
\section{Request syntax}{
\preformatted{svc$merge_developer_identities(
  SourceUserIdentifier = "string",
  DestinationUserIdentifier = "string",
  DeveloperProviderName = "string",
  IdentityPoolId = "string"
)
}
}

\keyword{internal}
