% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsm_operations.R
\name{cloudhsm_describe_hapg}
\alias{cloudhsm_describe_hapg}
\title{This is documentation for AWS CloudHSM Classic}
\usage{
cloudhsm_describe_hapg(HapgArn)
}
\arguments{
\item{HapgArn}{[required] The ARN of the high-availability partition group to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  HapgArn = "string",
  HapgSerial = "string",
  HsmsLastActionFailed = list(
    "string"
  ),
  HsmsPendingDeletion = list(
    "string"
  ),
  HsmsPendingRegistration = list(
    "string"
  ),
  Label = "string",
  LastModifiedTimestamp = "string",
  PartitionSerialList = list(
    "string"
  ),
  State = "READY"|"UPDATING"|"DEGRADED"
)
}
}
\description{
This is documentation for \strong{AWS CloudHSM Classic}. For more
information, see \href{https://aws.amazon.com/cloudhsm/faqs/}{AWS CloudHSM Classic FAQs}, the \href{https://docs.aws.amazon.com/cloudhsm/classic/userguide/}{AWS CloudHSM Classic User Guide},
and the \href{https://docs.aws.amazon.com/cloudhsm/classic/APIReference/}{AWS CloudHSM Classic API Reference}.

\strong{For information about the current version of AWS CloudHSM}, see \href{https://aws.amazon.com/cloudhsm/}{AWS CloudHSM}, the \href{https://docs.aws.amazon.com/cloudhsm/latest/userguide/}{AWS CloudHSM User Guide}, and the
\href{https://docs.aws.amazon.com/cloudhsm/latest/APIReference/}{AWS CloudHSM API Reference}.

Retrieves information about a high-availability partition group.
}
\section{Request syntax}{
\preformatted{svc$describe_hapg(
  HapgArn = "string"
)
}
}

\keyword{internal}
