% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_policy}
\alias{iam_create_policy}
\title{Creates a new managed policy for your AWS account}
\usage{
iam_create_policy(PolicyName, Path, PolicyDocument, Description)
}
\arguments{
\item{PolicyName}{[required] The friendly name of the policy.

IAM user, group, role, and policy names must be unique within the
account. Names are not distinguished by case. For example, you cannot
create resources named both "MyResource" and "myresource".}

\item{Path}{The path for the policy.

For more information about paths, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{IAM Identifiers}
in the \emph{IAM User Guide}.

This parameter is optional. If it is not included, it defaults to a
slash (/).

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\verb{\\u0021}) through the DEL character
(\verb{\\u007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{PolicyDocument}{[required] The JSON policy document that you want to use as the content for the new
policy.

You must provide policies in JSON format in IAM. However, for AWS
CloudFormation templates formatted in YAML, you can provide the policy
in JSON or YAML format. AWS CloudFormation always converts a YAML policy
to JSON format before submitting it to IAM.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\verb{\\u0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{\\u00FF})
\item The special characters tab (\verb{\\u0009}), line feed (\verb{\\u000A}), and
carriage return (\verb{\\u000D})
}}

\item{Description}{A friendly description of the policy.

Typically used to store information about the permissions defined in the
policy. For example, "Grants access to production DynamoDB tables."

The policy description is immutable. After a value is assigned, it
cannot be changed.}
}
\value{
A list with the following syntax:\preformatted{list(
  Policy = list(
    PolicyName = "string",
    PolicyId = "string",
    Arn = "string",
    Path = "string",
    DefaultVersionId = "string",
    AttachmentCount = 123,
    PermissionsBoundaryUsageCount = 123,
    IsAttachable = TRUE|FALSE,
    Description = "string",
    CreateDate = as.POSIXct(
      "2015-01-01"
    ),
    UpdateDate = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Creates a new managed policy for your AWS account.

This operation creates a policy version with a version identifier of
\code{v1} and sets v1 as the policy's default version. For more information
about policy versions, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-versioning.html}{Versioning for Managed Policies}
in the \emph{IAM User Guide}.

For more information about managed policies in general, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_policy(
  PolicyName = "string",
  Path = "string",
  PolicyDocument = "string",
  Description = "string"
)
}
}

\keyword{internal}
