% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_detach_role_policy}
\alias{iam_detach_role_policy}
\title{Removes the specified managed policy from the specified role}
\usage{
iam_detach_role_policy(RoleName, PolicyArn)
}
\arguments{
\item{RoleName}{[required] The name (friendly name, not ARN) of the IAM role to detach the policy
from.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}

\item{PolicyArn}{[required] The Amazon Resource Name (ARN) of the IAM policy you want to detach.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}
}
\description{
Removes the specified managed policy from the specified role.

A role can also have inline policies embedded with it. To delete an
inline policy, use the DeleteRolePolicy API. For information about
policies, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$detach_role_policy(
  RoleName = "string",
  PolicyArn = "string"
)
}
}

\keyword{internal}
