% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_create_trust}
\alias{directoryservice_create_trust}
\title{AWS Directory Service for Microsoft Active Directory allows you to
configure trust relationships}
\usage{
directoryservice_create_trust(DirectoryId, RemoteDomainName,
  TrustPassword, TrustDirection, TrustType, ConditionalForwarderIpAddrs,
  SelectiveAuth)
}
\arguments{
\item{DirectoryId}{[required] The Directory ID of the AWS Managed Microsoft AD directory for which to
establish the trust relationship.}

\item{RemoteDomainName}{[required] The Fully Qualified Domain Name (FQDN) of the external domain for which
to create the trust relationship.}

\item{TrustPassword}{[required] The trust password. The must be the same password that was used when
creating the trust relationship on the external domain.}

\item{TrustDirection}{[required] The direction of the trust relationship.}

\item{TrustType}{The trust relationship type. \code{Forest} is the default.}

\item{ConditionalForwarderIpAddrs}{The IP addresses of the remote DNS server associated with
RemoteDomainName.}

\item{SelectiveAuth}{Optional parameter to enable selective authentication for the trust.}
}
\description{
AWS Directory Service for Microsoft Active Directory allows you to
configure trust relationships. For example, you can establish a trust
between your AWS Managed Microsoft AD directory, and your existing
on-premises Microsoft Active Directory. This would allow you to provide
users and groups access to resources in either domain, with a single set
of credentials.

This action initiates the creation of the AWS side of a trust
relationship between an AWS Managed Microsoft AD directory and an
external domain. You can create either a forest trust or an external
trust.
}
\section{Request syntax}{
\preformatted{svc$create_trust(
  DirectoryId = "string",
  RemoteDomainName = "string",
  TrustPassword = "string",
  TrustDirection = "One-Way: Outgoing"|"One-Way: Incoming"|"Two-Way",
  TrustType = "Forest"|"External",
  ConditionalForwarderIpAddrs = list(
    "string"
  ),
  SelectiveAuth = "Enabled"|"Disabled"
)
}
}

\keyword{internal}
