% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsm_operations.R
\name{cloudhsm_create_hsm}
\alias{cloudhsm_create_hsm}
\title{This is documentation for AWS CloudHSM Classic}
\usage{
cloudhsm_create_hsm(SubnetId, SshKey, EniIp, IamRoleArn, ExternalId,
  SubscriptionType, ClientToken, SyslogIp)
}
\arguments{
\item{SubnetId}{[required] The identifier of the subnet in your VPC in which to place the HSM.}

\item{SshKey}{[required] The SSH public key to install on the HSM.}

\item{EniIp}{The IP address to assign to the HSM's ENI.

If an IP address is not specified, an IP address will be randomly chosen
from the CIDR range of the subnet.}

\item{IamRoleArn}{[required] The ARN of an IAM role to enable the AWS CloudHSM service to allocate an
ENI on your behalf.}

\item{ExternalId}{The external ID from \code{IamRoleArn}, if present.}

\item{SubscriptionType}{[required]}

\item{ClientToken}{A user-defined token to ensure idempotence. Subsequent calls to this
operation with the same token will be ignored.}

\item{SyslogIp}{The IP address for the syslog monitoring server. The AWS CloudHSM
service only supports one syslog monitoring server.}
}
\description{
This is documentation for \strong{AWS CloudHSM Classic}. For more
information, see \href{https://aws.amazon.com/cloudhsm/faqs/}{AWS CloudHSM Classic FAQs}, the \href{https://docs.aws.amazon.com/cloudhsm/classic/userguide/}{AWS CloudHSM Classic User Guide},
and the \href{https://docs.aws.amazon.com/cloudhsm/classic/APIReference/}{AWS CloudHSM Classic API Reference}.

\strong{For information about the current version of AWS CloudHSM}, see \href{https://aws.amazon.com/cloudhsm/}{AWS CloudHSM}, the \href{https://docs.aws.amazon.com/cloudhsm/latest/userguide/}{AWS CloudHSM User Guide}, and the
\href{https://docs.aws.amazon.com/cloudhsm/latest/APIReference/}{AWS CloudHSM API Reference}.

Creates an uninitialized HSM instance.

There is an upfront fee charged for each HSM instance that you create
with the \code{CreateHsm} operation. If you accidentally provision an HSM and
want to request a refund, delete the instance using the DeleteHsm
operation, go to the AWS Support Center, create a new case, and select
\strong{Account and Billing Support}.

It can take up to 20 minutes to create and provision an HSM. You can
monitor the status of the HSM with the DescribeHsm operation. The HSM is
ready to be initialized when the status changes to \code{RUNNING}.
}
\section{Request syntax}{
\preformatted{svc$create_hsm(
  SubnetId = "string",
  SshKey = "string",
  EniIp = "string",
  IamRoleArn = "string",
  ExternalId = "string",
  SubscriptionType = "PRODUCTION",
  ClientToken = "string",
  SyslogIp = "string"
)
}
}

\keyword{internal}
