% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_role}
\alias{iam_get_role}
\title{Retrieves information about the specified role, including the role's
path, GUID, ARN, and the role's trust policy that grants permission to
assume the role}
\usage{
iam_get_role(RoleName)
}
\arguments{
\item{RoleName}{[required] The name of the IAM role to get information about.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-}
}
\description{
Retrieves information about the specified role, including the role's
path, GUID, ARN, and the role's trust policy that grants permission to
assume the role. For more information about roles, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html}{Working with Roles}.
}
\details{
Policies returned by this API are URL-encoded compliant with \href{https://tools.ietf.org/html/rfc3986}{RFC 3986}. You can use a URL decoding
method to convert the policy back to plain JSON text. For example, if
you use Java, you can use the \code{decode} method of the
\code{java.net.URLDecoder} utility class in the Java SDK. Other languages and
SDKs provide similar functionality.
}
\section{Request syntax}{
\preformatted{svc$get_role(
  RoleName = "string"
)
}
}

\examples{
# The following command gets information about the role named Test-Role.
\donttest{svc$get_role(
  RoleName = "Test-Role"
)}

}
\keyword{internal}
