% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_create_direct_connect_gateway_association}
\alias{directconnect_create_direct_connect_gateway_association}
\title{Creates an association between a Direct Connect gateway and a virtual
private gateway}
\usage{
directconnect_create_direct_connect_gateway_association(
  directConnectGatewayId,
  gatewayId = NULL,
  addAllowedPrefixesToDirectConnectGateway = NULL,
  virtualGatewayId = NULL
)
}
\arguments{
\item{directConnectGatewayId}{[required] The ID of the Direct Connect gateway.}

\item{gatewayId}{The ID of the virtual private gateway or transit gateway.}

\item{addAllowedPrefixesToDirectConnectGateway}{The Amazon VPC prefixes to advertise to the Direct Connect gateway

This parameter is required when you create an association to a transit
gateway.

For information about how to set the prefixes, see \href{https://docs.aws.amazon.com/directconnect/latest/UserGuide/multi-account-associate-vgw.html#allowed-prefixes}{Allowed Prefixes}
in the \emph{Direct Connect User Guide}.}

\item{virtualGatewayId}{The ID of the virtual private gateway.}
}
\description{
Creates an association between a Direct Connect gateway and a virtual private gateway. The virtual private gateway must be attached to a VPC and must not be associated with another Direct Connect gateway.

See \url{https://paws-r.github.io/docs/directconnect/create_direct_connect_gateway_association.html} for full documentation.
}
\keyword{internal}
