% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_create_resolver_rule}
\alias{route53resolver_create_resolver_rule}
\title{For DNS queries that originate in your VPCs, specifies which resolver
endpoint the queries pass through, one domain name that you want to
forward to your network, and the IP addresses of the DNS resolvers in
your network}
\usage{
route53resolver_create_resolver_rule(CreatorRequestId, Name, RuleType,
  DomainName, TargetIps, ResolverEndpointId, Tags)
}
\arguments{
\item{CreatorRequestId}{[required] A unique string that identifies the request and that allows failed
requests to be retried without the risk of executing the operation
twice. \code{CreatorRequestId} can be any unique string, for example, a
date/time stamp.}

\item{Name}{A friendly name that lets you easily find a rule in the Resolver
dashboard in the Route 53 console.}

\item{RuleType}{[required] Specify \code{FORWARD}. Other resolver rule types aren\'t supported.}

\item{DomainName}{[required] DNS queries for this domain name are forwarded to the IP addresses that
you specify in \code{TargetIps}. If a query matches multiple resolver rules
(example.com and www.example.com), outbound DNS queries are routed using
the resolver rule that contains the most specific domain name
(www.example.com).}

\item{TargetIps}{The IPs that you want Resolver to forward DNS queries to. You can
specify only IPv4 addresses. Separate IP addresses with a comma.}

\item{ResolverEndpointId}{The ID of the outbound resolver endpoint that you want to use to route
DNS queries to the IP addresses that you specify in \code{TargetIps}.}

\item{Tags}{A list of the tag keys and values that you want to associate with the
endpoint.}
}
\description{
For DNS queries that originate in your VPCs, specifies which resolver
endpoint the queries pass through, one domain name that you want to
forward to your network, and the IP addresses of the DNS resolvers in
your network.
}
\section{Request syntax}{
\preformatted{svc$create_resolver_rule(
  CreatorRequestId = "string",
  Name = "string",
  RuleType = "FORWARD"|"SYSTEM"|"RECURSIVE",
  DomainName = "string",
  TargetIps = list(
    list(
      Ip = "string",
      Port = 123
    )
  ),
  ResolverEndpointId = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
