% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_create_virtual_node}
\alias{appmesh_create_virtual_node}
\title{Creates a virtual node within a service mesh}
\usage{
appmesh_create_virtual_node(clientToken, meshName, meshOwner, spec,
  tags, virtualNodeName)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh to create the virtual node in.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then the account that you specify must share the mesh with
your account before you can create the resource in the service mesh. For
more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{spec}{[required] The virtual node specification to apply.}

\item{tags}{Optional metadata that you can apply to the virtual node to assist with
categorization and organization. Each tag consists of a key and an
optional value, both of which you define. Tag keys can have a maximum
character length of 128 characters, and tag values can have a maximum
length of 256 characters.}

\item{virtualNodeName}{[required] The name to use for the virtual node.}
}
\description{
Creates a virtual node within a service mesh.
}
\details{
A virtual node acts as a logical pointer to a particular task group,
such as an Amazon ECS service or a Kubernetes deployment. When you
create a virtual node, you can specify the service discovery information
for your task group, and whether the proxy running in a task group will
communicate with other proxies using Transport Layer Security (TLS).

You define a \code{listener} for any inbound traffic that your virtual node
expects. Any virtual service that your virtual node expects to
communicate to is specified as a \code{backend}.

The response metadata for your new virtual node contains the \code{arn} that
is associated with the virtual node. Set this value (either the full ARN
or the truncated resource name: for example,
\code{mesh/default/virtualNode/simpleapp}) as the \code{APPMESH_VIRTUAL_NODE_NAME}
environment variable for your task group\'s Envoy proxy container in
your task definition or pod spec. This is then mapped to the \code{node.id}
and \code{node.cluster} Envoy parameters.

If you require your Envoy stats or tracing to use a different name, you
can override the \code{node.cluster} value that is set by
\code{APPMESH_VIRTUAL_NODE_NAME} with the \code{APPMESH_VIRTUAL_NODE_CLUSTER}
environment variable.

For more information about virtual nodes, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html}{Virtual nodes}.
}
\section{Request syntax}{
\preformatted{svc$create_virtual_node(
  clientToken = "string",
  meshName = "string",
  meshOwner = "string",
  spec = list(
    backendDefaults = list(
      clientPolicy = list(
        tls = list(
          enforce = TRUE|FALSE,
          ports = list(
            123
          ),
          validation = list(
            trust = list(
              acm = list(
                certificateAuthorityArns = list(
                  "string"
                )
              ),
              file = list(
                certificateChain = "string"
              )
            )
          )
        )
      )
    ),
    backends = list(
      list(
        virtualService = list(
          clientPolicy = list(
            tls = list(
              enforce = TRUE|FALSE,
              ports = list(
                123
              ),
              validation = list(
                trust = list(
                  acm = list(
                    certificateAuthorityArns = list(
                      "string"
                    )
                  ),
                  file = list(
                    certificateChain = "string"
                  )
                )
              )
            )
          ),
          virtualServiceName = "string"
        )
      )
    ),
    listeners = list(
      list(
        healthCheck = list(
          healthyThreshold = 123,
          intervalMillis = 123,
          path = "string",
          port = 123,
          protocol = "grpc"|"http"|"http2"|"tcp",
          timeoutMillis = 123,
          unhealthyThreshold = 123
        ),
        portMapping = list(
          port = 123,
          protocol = "grpc"|"http"|"http2"|"tcp"
        ),
        timeout = list(
          grpc = list(
            idle = list(
              unit = "ms"|"s",
              value = 123
            ),
            perRequest = list(
              unit = "ms"|"s",
              value = 123
            )
          ),
          http = list(
            idle = list(
              unit = "ms"|"s",
              value = 123
            ),
            perRequest = list(
              unit = "ms"|"s",
              value = 123
            )
          ),
          http2 = list(
            idle = list(
              unit = "ms"|"s",
              value = 123
            ),
            perRequest = list(
              unit = "ms"|"s",
              value = 123
            )
          ),
          tcp = list(
            idle = list(
              unit = "ms"|"s",
              value = 123
            )
          )
        ),
        tls = list(
          certificate = list(
            acm = list(
              certificateArn = "string"
            ),
            file = list(
              certificateChain = "string",
              privateKey = "string"
            )
          ),
          mode = "DISABLED"|"PERMISSIVE"|"STRICT"
        )
      )
    ),
    logging = list(
      accessLog = list(
        file = list(
          path = "string"
        )
      )
    ),
    serviceDiscovery = list(
      awsCloudMap = list(
        attributes = list(
          list(
            key = "string",
            value = "string"
          )
        ),
        namespaceName = "string",
        serviceName = "string"
      ),
      dns = list(
        hostname = "string"
      )
    )
  ),
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  virtualNodeName = "string"
)
}
}

\keyword{internal}
