% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_list_tags_for_resource}
\alias{route53resolver_list_tags_for_resource}
\title{Lists the tags that you associated with the specified resource}
\usage{
route53resolver_list_tags_for_resource(ResourceArn, MaxResults,
  NextToken)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) for the resource that you want to list
tags for.}

\item{MaxResults}{The maximum number of tags that you want to return in the response to a
\code{\link[=route53resolver_list_tags_for_resource]{list_tags_for_resource}}
request. If you don't specify a value for \code{MaxResults}, Resolver returns
up to 100 tags.}

\item{NextToken}{For the first
\code{\link[=route53resolver_list_tags_for_resource]{list_tags_for_resource}}
request, omit this value.

If you have more than \code{MaxResults} tags, you can submit another
\code{\link[=route53resolver_list_tags_for_resource]{list_tags_for_resource}}
request to get the next group of tags for the resource. In the next
request, specify the value of \code{NextToken} from the previous response.}
}
\value{
A list with the following syntax:\preformatted{list(
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the tags that you associated with the specified resource.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceArn = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
