% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_describe_rules}
\alias{elbv2_describe_rules}
\title{Describes the specified rules or the rules for the specified listener}
\usage{
elbv2_describe_rules(ListenerArn, RuleArns, Marker, PageSize)
}
\arguments{
\item{ListenerArn}{The Amazon Resource Name (ARN) of the listener.}

\item{RuleArns}{The Amazon Resource Names (ARN) of the rules.}

\item{Marker}{The marker for the next set of results. (You received this marker from a
previous call.)}

\item{PageSize}{The maximum number of results to return with this call.}
}
\value{
A list with the following syntax:\preformatted{list(
  Rules = list(
    list(
      RuleArn = "string",
      Priority = "string",
      Conditions = list(
        list(
          Field = "string",
          Values = list(
            "string"
          ),
          HostHeaderConfig = list(
            Values = list(
              "string"
            )
          ),
          PathPatternConfig = list(
            Values = list(
              "string"
            )
          ),
          HttpHeaderConfig = list(
            HttpHeaderName = "string",
            Values = list(
              "string"
            )
          ),
          QueryStringConfig = list(
            Values = list(
              list(
                Key = "string",
                Value = "string"
              )
            )
          ),
          HttpRequestMethodConfig = list(
            Values = list(
              "string"
            )
          ),
          SourceIpConfig = list(
            Values = list(
              "string"
            )
          )
        )
      ),
      Actions = list(
        list(
          Type = "forward"|"authenticate-oidc"|"authenticate-cognito"|"redirect"|"fixed-response",
          TargetGroupArn = "string",
          AuthenticateOidcConfig = list(
            Issuer = "string",
            AuthorizationEndpoint = "string",
            TokenEndpoint = "string",
            UserInfoEndpoint = "string",
            ClientId = "string",
            ClientSecret = "string",
            SessionCookieName = "string",
            Scope = "string",
            SessionTimeout = 123,
            AuthenticationRequestExtraParams = list(
              "string"
            ),
            OnUnauthenticatedRequest = "deny"|"allow"|"authenticate",
            UseExistingClientSecret = TRUE|FALSE
          ),
          AuthenticateCognitoConfig = list(
            UserPoolArn = "string",
            UserPoolClientId = "string",
            UserPoolDomain = "string",
            SessionCookieName = "string",
            Scope = "string",
            SessionTimeout = 123,
            AuthenticationRequestExtraParams = list(
              "string"
            ),
            OnUnauthenticatedRequest = "deny"|"allow"|"authenticate"
          ),
          Order = 123,
          RedirectConfig = list(
            Protocol = "string",
            Port = "string",
            Host = "string",
            Path = "string",
            Query = "string",
            StatusCode = "HTTP_301"|"HTTP_302"
          ),
          FixedResponseConfig = list(
            MessageBody = "string",
            StatusCode = "string",
            ContentType = "string"
          ),
          ForwardConfig = list(
            TargetGroups = list(
              list(
                TargetGroupArn = "string",
                Weight = 123
              )
            ),
            TargetGroupStickinessConfig = list(
              Enabled = TRUE|FALSE,
              DurationSeconds = 123
            )
          )
        )
      ),
      IsDefault = TRUE|FALSE
    )
  ),
  NextMarker = "string"
)
}
}
\description{
Describes the specified rules or the rules for the specified listener.
You must specify either a listener or one or more rules.
}
\section{Request syntax}{
\preformatted{svc$describe_rules(
  ListenerArn = "string",
  RuleArns = list(
    "string"
  ),
  Marker = "string",
  PageSize = 123
)
}
}

\examples{
\dontrun{
# This example describes the specified rule.
svc$describe_rules(
  RuleArns = list(
    "arn:aws:elasticloadbalancing:us-west-2:123456789012:listener-rule/app/..."
  )
)
}

}
\keyword{internal}
