% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_describe_load_balancers}
\alias{elbv2_describe_load_balancers}
\title{Describes the specified load balancers or all of your load balancers}
\usage{
elbv2_describe_load_balancers(LoadBalancerArns, Names, Marker, PageSize)
}
\arguments{
\item{LoadBalancerArns}{The Amazon Resource Names (ARN) of the load balancers. You can specify
up to 20 load balancers in a single call.}

\item{Names}{The names of the load balancers.}

\item{Marker}{The marker for the next set of results. (You received this marker from a
previous call.)}

\item{PageSize}{The maximum number of results to return with this call.}
}
\value{
A list with the following syntax:\preformatted{list(
  LoadBalancers = list(
    list(
      LoadBalancerArn = "string",
      DNSName = "string",
      CanonicalHostedZoneId = "string",
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      LoadBalancerName = "string",
      Scheme = "internet-facing"|"internal",
      VpcId = "string",
      State = list(
        Code = "active"|"provisioning"|"active_impaired"|"failed",
        Reason = "string"
      ),
      Type = "application"|"network"|"gateway",
      AvailabilityZones = list(
        list(
          ZoneName = "string",
          SubnetId = "string",
          OutpostId = "string",
          LoadBalancerAddresses = list(
            list(
              IpAddress = "string",
              AllocationId = "string",
              PrivateIPv4Address = "string",
              IPv6Address = "string"
            )
          )
        )
      ),
      SecurityGroups = list(
        "string"
      ),
      IpAddressType = "ipv4"|"dualstack",
      CustomerOwnedIpv4Pool = "string"
    )
  ),
  NextMarker = "string"
)
}
}
\description{
Describes the specified load balancers or all of your load balancers.
}
\section{Request syntax}{
\preformatted{svc$describe_load_balancers(
  LoadBalancerArns = list(
    "string"
  ),
  Names = list(
    "string"
  ),
  Marker = "string",
  PageSize = 123
)
}
}

\examples{
\dontrun{
# This example describes the specified load balancer.
svc$describe_load_balancers(
  LoadBalancerArns = list(
    "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/m..."
  )
)
}

}
\keyword{internal}
