% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_untag_resource}
\alias{globalaccelerator_untag_resource}
\title{Remove tags from a Global Accelerator resource}
\usage{
globalaccelerator_untag_resource(ResourceArn, TagKeys)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the Global Accelerator resource to
remove tags from. An ARN uniquely identifies a resource.}

\item{TagKeys}{[required] The tag key pairs that you want to remove from the specified resources.}
}
\description{
Remove tags from a Global Accelerator resource. When you specify a tag
key, the action removes both that key and its associated value. The
operation succeeds even if you attempt to remove tags from an
accelerator that was already removed.

For more information, see \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html}{Tagging in AWS Global Accelerator}
in the \emph{AWS Global Accelerator Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  ResourceArn = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
