% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_confirm_private_virtual_interface}
\alias{directconnect_confirm_private_virtual_interface}
\title{Accepts ownership of a private virtual interface created by another AWS
account}
\usage{
directconnect_confirm_private_virtual_interface(virtualInterfaceId,
  virtualGatewayId, directConnectGatewayId)
}
\arguments{
\item{virtualInterfaceId}{[required] The ID of the virtual interface.}

\item{virtualGatewayId}{The ID of the virtual private gateway.}

\item{directConnectGatewayId}{The ID of the Direct Connect gateway.}
}
\description{
Accepts ownership of a private virtual interface created by another AWS
account.

After the virtual interface owner makes this call, the virtual interface
is created and attached to the specified virtual private gateway or
Direct Connect gateway, and is made available to handle traffic.
}
\section{Request syntax}{
\preformatted{svc$confirm_private_virtual_interface(
  virtualInterfaceId = "string",
  virtualGatewayId = "string",
  directConnectGatewayId = "string"
)
}
}

\keyword{internal}
