% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appregistry_operations.R
\name{appregistry_create_attribute_group}
\alias{appregistry_create_attribute_group}
\title{Creates a new attribute group as a container for user-defined attributes}
\usage{
appregistry_create_attribute_group(
  name,
  description = NULL,
  attributes,
  tags = NULL,
  clientToken
)
}
\arguments{
\item{name}{[required] The name of the attribute group.}

\item{description}{The description of the attribute group that the user provides.}

\item{attributes}{[required] A JSON string in the form of nested key-value pairs that represent the
attributes in the group and describes an application and its components.}

\item{tags}{Key-value pairs you can use to associate with the attribute group.}

\item{clientToken}{[required] A unique identifier that you provide to ensure idempotency. If you retry
a request that completed successfully using the same client token and
the same parameters, the retry succeeds without performing any further
actions. If you retry a successful request using the same client token,
but one or more of the parameters are different, the retry fails.}
}
\description{
Creates a new attribute group as a container for user-defined attributes. This feature enables users to have full control over their cloud application's metadata in a rich machine-readable format to facilitate integration with automated workflows and third-party tools.

See \url{https://www.paws-r-sdk.com/docs/appregistry_create_attribute_group/} for full documentation.
}
\keyword{internal}
