# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Support App
#'
#' @description
#' Amazon Web Services Support App in Slack
#' 
#' You can use the Amazon Web Services Support App in Slack API to manage
#' your support cases in Slack for your Amazon Web Services account. After
#' you configure your Slack workspace and channel with the Amazon Web
#' Services Support App, you can perform the following tasks directly in
#' your Slack channel:
#' 
#' -   Create, search, update, and resolve your support cases
#' 
#' -   Request service quota increases for your account
#' 
#' -   Invite Amazon Web Services Support agents to your channel so that
#'     you can chat directly about your support cases
#' 
#' For more information about how to perform these actions in Slack, see
#' the following documentation in the *Amazon Web Services Support User
#' Guide*:
#' 
#' -   [Amazon Web Services Support App in
#'     Slack](https://docs.aws.amazon.com/awssupport/latest/user/aws-support-app-for-slack.html)
#' 
#' -   [Joining a live chat session with Amazon Web Services
#'     Support](https://docs.aws.amazon.com/awssupport/latest/user/joining-a-live-chat-session.html)
#' 
#' -   [Requesting service quota
#'     increases](https://docs.aws.amazon.com/awssupport/latest/user/service-quota-increase.html)
#' 
#' -   [Amazon Web Services Support App commands in
#'     Slack](https://docs.aws.amazon.com/awssupport/latest/user/support-app-commands.html)
#' 
#' You can also use the Amazon Web Services Management Console instead of
#' the Amazon Web Services Support App API to manage your Slack
#' configurations. For more information, see [Authorize a Slack workspace
#' to enable the Amazon Web Services Support
#' App](https://docs.aws.amazon.com/awssupport/latest/user/authorize-slack-workspace.html).
#' 
#' -   You must have a Business or Enterprise Support plan to use the
#'     Amazon Web Services Support App API.
#' 
#' -   For more information about the Amazon Web Services Support App
#'     endpoints, see the [Amazon Web Services Support App in Slack
#'     endpoints](https://docs.aws.amazon.com/general/latest/gr/awssupport.html#awssupport_app_region)
#'     in the *Amazon Web Services General Reference*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- supportapp(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- supportapp()
#' svc$create_slack_channel_configuration(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=supportapp_create_slack_channel_configuration]{create_slack_channel_configuration} \tab Creates a Slack channel configuration for your Amazon Web Services account\cr
#'  \link[=supportapp_delete_account_alias]{delete_account_alias} \tab Deletes an alias for an Amazon Web Services account ID\cr
#'  \link[=supportapp_delete_slack_channel_configuration]{delete_slack_channel_configuration} \tab Deletes a Slack channel configuration from your Amazon Web Services account\cr
#'  \link[=supportapp_delete_slack_workspace_configuration]{delete_slack_workspace_configuration} \tab Deletes a Slack workspace configuration from your Amazon Web Services account\cr
#'  \link[=supportapp_get_account_alias]{get_account_alias} \tab Retrieves the alias from an Amazon Web Services account ID\cr
#'  \link[=supportapp_list_slack_channel_configurations]{list_slack_channel_configurations} \tab Lists the Slack channel configurations for an Amazon Web Services account\cr
#'  \link[=supportapp_list_slack_workspace_configurations]{list_slack_workspace_configurations} \tab Lists the Slack workspace configurations for an Amazon Web Services account\cr
#'  \link[=supportapp_put_account_alias]{put_account_alias} \tab Creates or updates an individual alias for each Amazon Web Services account ID\cr
#'  \link[=supportapp_register_slack_workspace_for_organization]{register_slack_workspace_for_organization} \tab Registers a Slack workspace for your Amazon Web Services account\cr
#'  \link[=supportapp_update_slack_channel_configuration]{update_slack_channel_configuration} \tab Updates the configuration for a Slack channel, such as case update notifications
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname supportapp
#' @export
supportapp <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .supportapp$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.supportapp <- list()

.supportapp$operations <- list()

.supportapp$metadata <- list(
  service_name = "supportapp",
  endpoints = list("*" = list(endpoint = "supportapp.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "supportapp.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "supportapp.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "supportapp.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "supportapp.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "supportapp.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Support App",
  api_version = "2021-08-20",
  signing_name = "supportapp",
  json_version = "1.1",
  target_prefix = ""
)

.supportapp$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.supportapp$metadata, handlers, config, op)
}
