% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetics_operations.R
\name{synthetics_describe_canaries_last_run}
\alias{synthetics_describe_canaries_last_run}
\title{Use this operation to see information from the most recent run of each
canary that you have created}
\usage{
synthetics_describe_canaries_last_run(
  NextToken = NULL,
  MaxResults = NULL,
  Names = NULL
)
}
\arguments{
\item{NextToken}{A token that indicates that there is more data available. You can use
this token in a subsequent
\code{\link[=synthetics_describe_canaries_last_run]{describe_canaries_last_run}}
operation to retrieve the next set of results.}

\item{MaxResults}{Specify this parameter to limit how many runs are returned each time you
use the \code{DescribeLastRun} operation. If you omit this parameter, the
default of 100 is used.}

\item{Names}{Use this parameter to return only canaries that match the names that you
specify here. You can specify as many as five canary names.

If you specify this parameter, the operation is successful only if you
have authorization to view all the canaries that you specify in your
request. If you do not have permission to view any of the canaries, the
request fails with a 403 response.

You are required to use the \code{Names} parameter if you are logged on to a
user or role that has an IAM policy that restricts which canaries that
you are allowed to view. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html}{Limiting a user to viewing specific canaries}.}
}
\description{
Use this operation to see information from the most recent run of each canary that you have created.

See \url{https://www.paws-r-sdk.com/docs/synthetics_describe_canaries_last_run/} for full documentation.
}
\keyword{internal}
