% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_update_app}
\alias{resiliencehub_update_app}
\title{Updates an application}
\usage{
resiliencehub_update_app(
  appArn,
  assessmentSchedule = NULL,
  clearResiliencyPolicyArn = NULL,
  description = NULL,
  eventSubscriptions = NULL,
  permissionModel = NULL,
  policyArn = NULL
)
}
\arguments{
\item{appArn}{[required] Amazon Resource Name (ARN) of the Resilience Hub application. The format
for this ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app/\code{app-id}. For more
information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference} guide.}

\item{assessmentSchedule}{Assessment execution schedule with 'Daily' or 'Disabled' values.}

\item{clearResiliencyPolicyArn}{Specifies if the resiliency policy ARN should be cleared.}

\item{description}{The optional description for an app.}

\item{eventSubscriptions}{The list of events you would like to subscribe and get notification for.
Currently, Resilience Hub supports notifications only for \strong{Drift
detected} and \strong{Scheduled assessment failure} events.}

\item{permissionModel}{Defines the roles and credentials that Resilience Hub would use while
creating an application, importing its resources, and running an
assessment.}

\item{policyArn}{Amazon Resource Name (ARN) of the resiliency policy. The format for this
ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:resiliency-policy/\code{policy-id}.
For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference} guide.}
}
\description{
Updates an application.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_update_app/} for full documentation.
}
\keyword{internal}
