# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include opsworks_service.R
NULL

#' Assign a registered instance to a layer
#'
#' @description
#' Assign a registered instance to a layer.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_assign_instance/](https://www.paws-r-sdk.com/docs/opsworks_assign_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The instance ID.
#' @param LayerIds &#91;required&#93; The layer ID, which must correspond to a custom layer. You cannot assign
#' a registered instance to a built-in layer.
#'
#' @keywords internal
#'
#' @rdname opsworks_assign_instance
opsworks_assign_instance <- function(InstanceId, LayerIds) {
  op <- new_operation(
    name = "AssignInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$assign_instance_input(InstanceId = InstanceId, LayerIds = LayerIds)
  output <- .opsworks$assign_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$assign_instance <- opsworks_assign_instance

#' Assigns one of the stack's registered Amazon EBS volumes to a specified
#' instance
#'
#' @description
#' Assigns one of the stack's registered Amazon EBS volumes to a specified instance. The volume must first be registered with the stack by calling [`register_volume`][opsworks_register_volume]. After you register the volume, you must call [`update_volume`][opsworks_update_volume] to specify a mount point before calling [`assign_volume`][opsworks_assign_volume]. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_assign_volume/](https://www.paws-r-sdk.com/docs/opsworks_assign_volume/) for full documentation.
#'
#' @param VolumeId &#91;required&#93; The volume ID.
#' @param InstanceId The instance ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_assign_volume
opsworks_assign_volume <- function(VolumeId, InstanceId = NULL) {
  op <- new_operation(
    name = "AssignVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$assign_volume_input(VolumeId = VolumeId, InstanceId = InstanceId)
  output <- .opsworks$assign_volume_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$assign_volume <- opsworks_assign_volume

#' Associates one of the stack's registered Elastic IP addresses with a
#' specified instance
#'
#' @description
#' Associates one of the stack's registered Elastic IP addresses with a specified instance. The address must first be registered with the stack by calling [`register_elastic_ip`][opsworks_register_elastic_ip]. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_associate_elastic_ip/](https://www.paws-r-sdk.com/docs/opsworks_associate_elastic_ip/) for full documentation.
#'
#' @param ElasticIp &#91;required&#93; The Elastic IP address.
#' @param InstanceId The instance ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_associate_elastic_ip
opsworks_associate_elastic_ip <- function(ElasticIp, InstanceId = NULL) {
  op <- new_operation(
    name = "AssociateElasticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$associate_elastic_ip_input(ElasticIp = ElasticIp, InstanceId = InstanceId)
  output <- .opsworks$associate_elastic_ip_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$associate_elastic_ip <- opsworks_associate_elastic_ip

#' Attaches an Elastic Load Balancing load balancer to a specified layer
#'
#' @description
#' Attaches an Elastic Load Balancing load balancer to a specified layer. AWS OpsWorks Stacks does not support Application Load Balancer. You can only use Classic Load Balancer with AWS OpsWorks Stacks. For more information, see [Elastic Load Balancing](https://docs.aws.amazon.com/opsworks/latest/userguide/layers-elb.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_attach_elastic_load_balancer/](https://www.paws-r-sdk.com/docs/opsworks_attach_elastic_load_balancer/) for full documentation.
#'
#' @param ElasticLoadBalancerName &#91;required&#93; The Elastic Load Balancing instance's name.
#' @param LayerId &#91;required&#93; The ID of the layer to which the Elastic Load Balancing instance is to
#' be attached.
#'
#' @keywords internal
#'
#' @rdname opsworks_attach_elastic_load_balancer
opsworks_attach_elastic_load_balancer <- function(ElasticLoadBalancerName, LayerId) {
  op <- new_operation(
    name = "AttachElasticLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$attach_elastic_load_balancer_input(ElasticLoadBalancerName = ElasticLoadBalancerName, LayerId = LayerId)
  output <- .opsworks$attach_elastic_load_balancer_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$attach_elastic_load_balancer <- opsworks_attach_elastic_load_balancer

#' Creates a clone of a specified stack
#'
#' @description
#' Creates a clone of a specified stack. For more information, see [Clone a Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-cloning.html). By default, all parameters are set to the values used by the parent stack.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_clone_stack/](https://www.paws-r-sdk.com/docs/opsworks_clone_stack/) for full documentation.
#'
#' @param SourceStackId &#91;required&#93; The source stack ID.
#' @param Name The cloned stack name.
#' @param Region The cloned stack AWS region, such as "ap-northeast-2". For more
#' information about AWS regions, see [Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
#' @param VpcId The ID of the VPC that the cloned stack is to be launched into. It must
#' be in the specified region. All instances are launched into this VPC,
#' and you cannot change the ID later.
#' 
#' -   If your account supports EC2 Classic, the default value is no VPC.
#' 
#' -   If your account does not support EC2 Classic, the default value is
#'     the default VPC for the specified region.
#' 
#' If the VPC ID corresponds to a default VPC and you have specified either
#' the `DefaultAvailabilityZone` or the `DefaultSubnetId` parameter only,
#' AWS OpsWorks Stacks infers the value of the other parameter. If you
#' specify neither parameter, AWS OpsWorks Stacks sets these parameters to
#' the first valid Availability Zone for the specified region and the
#' corresponding default VPC subnet ID, respectively.
#' 
#' If you specify a nondefault VPC ID, note the following:
#' 
#' -   It must belong to a VPC in your account that is in the specified
#'     region.
#' 
#' -   You must specify a value for `DefaultSubnetId`.
#' 
#' For more information about how to use AWS OpsWorks Stacks with a VPC,
#' see [Running a Stack in a
#' VPC](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html).
#' For more information about default VPC and EC2 Classic, see [Supported
#' Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-classic-platform.html).
#' @param Attributes A list of stack attributes and values as key/value pairs to be added to
#' the cloned stack.
#' @param ServiceRoleArn &#91;required&#93; The stack AWS Identity and Access Management (IAM) role, which allows
#' AWS OpsWorks Stacks to work with AWS resources on your behalf. You must
#' set this parameter to the Amazon Resource Name (ARN) for an existing IAM
#' role. If you create a stack by using the AWS OpsWorks Stacks console, it
#' creates the role for you. You can obtain an existing stack's IAM ARN
#' programmatically by calling
#' [`describe_permissions`][opsworks_describe_permissions]. For more
#' information about IAM ARNs, see [Using
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html).
#' 
#' You must set this parameter to a valid service role ARN or the action
#' will fail; there is no default value. You can specify the source stack's
#' service role ARN, if you prefer, but you must do so explicitly.
#' @param DefaultInstanceProfileArn The Amazon Resource Name (ARN) of an IAM profile that is the default
#' profile for all of the stack's EC2 instances. For more information about
#' IAM ARNs, see [Using
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html).
#' @param DefaultOs The stack's operating system, which must be set to one of the following.
#' 
#' -   A supported Linux operating system: An Amazon Linux version, such as
#'     `Amazon Linux 2018.03`, `Amazon Linux 2017.09`,
#'     `Amazon Linux 2017.03`, `Amazon Linux 2016.09`,
#'     `Amazon Linux 2016.03`, `Amazon Linux 2015.09`, or
#'     `Amazon Linux 2015.03`.
#' 
#' -   A supported Ubuntu operating system, such as `Ubuntu 16.04 LTS`,
#'     `Ubuntu 14.04 LTS`, or `Ubuntu 12.04 LTS`.
#' 
#' -   `CentOS Linux 7`
#' 
#' -   `Red Hat Enterprise Linux 7`
#' 
#' -   `Microsoft Windows Server 2012 R2 Base`,
#'     `Microsoft Windows Server 2012 R2 with SQL Server Express`,
#'     `Microsoft Windows Server 2012 R2 with SQL Server Standard`, or
#'     `Microsoft Windows Server 2012 R2 with SQL Server Web`.
#' 
#' -   A custom AMI: `Custom`. You specify the custom AMI you want to use
#'     when you create instances. For more information about how to use
#'     custom AMIs with OpsWorks, see [Using Custom
#'     AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
#' 
#' The default option is the parent stack's operating system. For more
#' information about supported operating systems, see [AWS OpsWorks Stacks
#' Operating
#' Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
#' 
#' You can specify a different Linux operating system for the cloned stack,
#' but you cannot change from Linux to Windows or Windows to Linux.
#' @param HostnameTheme The stack's host name theme, with spaces are replaced by underscores.
#' The theme is used to generate host names for the stack's instances. By
#' default, `HostnameTheme` is set to `Layer_Dependent`, which creates host
#' names by appending integers to the layer's short name. The other themes
#' are:
#' 
#' -   `Baked_Goods`
#' 
#' -   `Clouds`
#' 
#' -   `Europe_Cities`
#' 
#' -   `Fruits`
#' 
#' -   `Greek_Deities_and_Titans`
#' 
#' -   `Legendary_creatures_from_Japan`
#' 
#' -   `Planets_and_Moons`
#' 
#' -   `Roman_Deities`
#' 
#' -   `Scottish_Islands`
#' 
#' -   `US_Cities`
#' 
#' -   `Wild_Cats`
#' 
#' To obtain a generated host name, call `GetHostNameSuggestion`, which
#' returns a host name based on the current theme.
#' @param DefaultAvailabilityZone The cloned stack's default Availability Zone, which must be in the
#' specified region. For more information, see [Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html). If
#' you also specify a value for `DefaultSubnetId`, the subnet must be in
#' the same zone. For more information, see the `VpcId` parameter
#' description.
#' @param DefaultSubnetId The stack's default VPC subnet ID. This parameter is required if you
#' specify a value for the `VpcId` parameter. All instances are launched
#' into this subnet unless you specify otherwise when you create the
#' instance. If you also specify a value for `DefaultAvailabilityZone`, the
#' subnet must be in that zone. For information on default values and when
#' this parameter is required, see the `VpcId` parameter description.
#' @param CustomJson A string that contains user-defined, custom JSON. It is used to override
#' the corresponding default stack configuration JSON values. The string
#' should be in the following format:
#' 
#' `"{\"key1\": \"value1\", \"key2\": \"value2\",...}"`
#' 
#' For more information about custom JSON, see [Use Custom JSON to Modify
#' the Stack Configuration
#' Attributes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html)
#' @param ConfigurationManager The configuration manager. When you clone a stack we recommend that you
#' use the configuration manager to specify the Chef version: 12, 11.10, or
#' 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for
#' Linux stacks is currently 12.
#' @param ChefConfiguration A `ChefConfiguration` object that specifies whether to enable Berkshelf
#' and the Berkshelf version on Chef 11.10 stacks. For more information,
#' see [Create a New
#' Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
#' @param UseCustomCookbooks Whether to use custom cookbooks.
#' @param UseOpsworksSecurityGroups Whether to associate the AWS OpsWorks Stacks built-in security groups
#' with the stack's layers.
#' 
#' AWS OpsWorks Stacks provides a standard set of built-in security groups,
#' one for each layer, which are associated with layers by default. With
#' `UseOpsworksSecurityGroups` you can instead provide your own custom
#' security groups. `UseOpsworksSecurityGroups` has the following settings:
#' 
#' -   True - AWS OpsWorks Stacks automatically associates the appropriate
#'     built-in security group with each layer (default setting). You can
#'     associate additional security groups with a layer after you create
#'     it but you cannot delete the built-in security group.
#' 
#' -   False - AWS OpsWorks Stacks does not associate built-in security
#'     groups with layers. You must create appropriate Amazon Elastic
#'     Compute Cloud (Amazon EC2) security groups and associate a security
#'     group with each layer that you create. However, you can still
#'     manually associate a built-in security group with a layer on
#'     creation; custom security groups are required only for those layers
#'     that need custom settings.
#' 
#' For more information, see [Create a New
#' Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
#' @param CustomCookbooksSource Contains the information required to retrieve an app or cookbook from a
#' repository. For more information, see [Adding
#' Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
#' or [Cookbooks and
#' Recipes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
#' @param DefaultSshKeyName A default Amazon EC2 key pair name. The default value is none. If you
#' specify a key pair name, AWS OpsWorks installs the public key on the
#' instance and you can use the private key with an SSH client to log in to
#' the instance. For more information, see [Using SSH to Communicate with
#' an
#' Instance](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html)
#' and [Managing SSH
#' Access](https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html).
#' You can override this setting by specifying a different key pair, or no
#' key pair, when you [create an
#' instance](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
#' @param ClonePermissions Whether to clone the source stack's permissions.
#' @param CloneAppIds A list of source stack app IDs to be included in the cloned stack.
#' @param DefaultRootDeviceType The default root device type. This value is used by default for all
#' instances in the cloned stack, but you can override it when you create
#' an instance. For more information, see [Storage for the Root
#' Device](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
#' @param AgentVersion The default AWS OpsWorks Stacks agent version. You have the following
#' options:
#' 
#' -   Auto-update - Set this parameter to `LATEST`. AWS OpsWorks Stacks
#'     automatically installs new agent versions on the stack's instances
#'     as soon as they are available.
#' 
#' -   Fixed version - Set this parameter to your preferred agent version.
#'     To update the agent version, you must edit the stack configuration
#'     and specify a new version. AWS OpsWorks Stacks then automatically
#'     installs that version on the stack's instances.
#' 
#' The default setting is `LATEST`. To specify an agent version, you must
#' use the complete version number, not the abbreviated number shown on the
#' console. For a list of available agent version numbers, call
#' [`describe_agent_versions`][opsworks_describe_agent_versions].
#' AgentVersion cannot be set to Chef 12.2.
#' 
#' You can also specify an agent version when you create or update an
#' instance, which overrides the stack's default setting.
#'
#' @keywords internal
#'
#' @rdname opsworks_clone_stack
opsworks_clone_stack <- function(SourceStackId, Name = NULL, Region = NULL, VpcId = NULL, Attributes = NULL, ServiceRoleArn, DefaultInstanceProfileArn = NULL, DefaultOs = NULL, HostnameTheme = NULL, DefaultAvailabilityZone = NULL, DefaultSubnetId = NULL, CustomJson = NULL, ConfigurationManager = NULL, ChefConfiguration = NULL, UseCustomCookbooks = NULL, UseOpsworksSecurityGroups = NULL, CustomCookbooksSource = NULL, DefaultSshKeyName = NULL, ClonePermissions = NULL, CloneAppIds = NULL, DefaultRootDeviceType = NULL, AgentVersion = NULL) {
  op <- new_operation(
    name = "CloneStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$clone_stack_input(SourceStackId = SourceStackId, Name = Name, Region = Region, VpcId = VpcId, Attributes = Attributes, ServiceRoleArn = ServiceRoleArn, DefaultInstanceProfileArn = DefaultInstanceProfileArn, DefaultOs = DefaultOs, HostnameTheme = HostnameTheme, DefaultAvailabilityZone = DefaultAvailabilityZone, DefaultSubnetId = DefaultSubnetId, CustomJson = CustomJson, ConfigurationManager = ConfigurationManager, ChefConfiguration = ChefConfiguration, UseCustomCookbooks = UseCustomCookbooks, UseOpsworksSecurityGroups = UseOpsworksSecurityGroups, CustomCookbooksSource = CustomCookbooksSource, DefaultSshKeyName = DefaultSshKeyName, ClonePermissions = ClonePermissions, CloneAppIds = CloneAppIds, DefaultRootDeviceType = DefaultRootDeviceType, AgentVersion = AgentVersion)
  output <- .opsworks$clone_stack_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$clone_stack <- opsworks_clone_stack

#' Creates an app for a specified stack
#'
#' @description
#' Creates an app for a specified stack. For more information, see [Creating Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_create_app/](https://www.paws-r-sdk.com/docs/opsworks_create_app/) for full documentation.
#'
#' @param StackId &#91;required&#93; The stack ID.
#' @param Shortname The app's short name.
#' @param Name &#91;required&#93; The app name.
#' @param Description A description of the app.
#' @param DataSources The app's data source.
#' @param Type &#91;required&#93; The app type. Each supported type is associated with a particular layer.
#' For example, PHP applications are associated with a PHP layer. AWS
#' OpsWorks Stacks deploys an application to those instances that are
#' members of the corresponding layer. If your app isn't one of the
#' standard types, or you prefer to implement your own Deploy recipes,
#' specify `other`.
#' @param AppSource A `Source` object that specifies the app repository.
#' @param Domains The app virtual host settings, with multiple domains separated by
#' commas. For example: `'www.example.com, example.com'`
#' @param EnableSsl Whether to enable SSL for the app.
#' @param SslConfiguration An `SslConfiguration` object with the SSL configuration.
#' @param Attributes One or more user-defined key/value pairs to be added to the stack
#' attributes.
#' @param Environment An array of `EnvironmentVariable` objects that specify environment
#' variables to be associated with the app. After you deploy the app, these
#' variables are defined on the associated app server instance. For more
#' information, see [Environment
#' Variables](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment).
#' 
#' There is no specific limit on the number of environment variables.
#' However, the size of the associated data structure - which includes the
#' variables' names, values, and protected flag values - cannot exceed 20
#' KB. This limit should accommodate most if not all use cases. Exceeding
#' it will cause an exception with the message, "Environment: is too large
#' (maximum is 20KB)."
#' 
#' If you have specified one or more environment variables, you cannot
#' modify the stack's Chef version.
#'
#' @keywords internal
#'
#' @rdname opsworks_create_app
opsworks_create_app <- function(StackId, Shortname = NULL, Name, Description = NULL, DataSources = NULL, Type, AppSource = NULL, Domains = NULL, EnableSsl = NULL, SslConfiguration = NULL, Attributes = NULL, Environment = NULL) {
  op <- new_operation(
    name = "CreateApp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$create_app_input(StackId = StackId, Shortname = Shortname, Name = Name, Description = Description, DataSources = DataSources, Type = Type, AppSource = AppSource, Domains = Domains, EnableSsl = EnableSsl, SslConfiguration = SslConfiguration, Attributes = Attributes, Environment = Environment)
  output <- .opsworks$create_app_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$create_app <- opsworks_create_app

#' Runs deployment or stack commands
#'
#' @description
#' Runs deployment or stack commands. For more information, see [Deploying Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-deploying.html) and [Run Stack Commands](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-commands.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_create_deployment/](https://www.paws-r-sdk.com/docs/opsworks_create_deployment/) for full documentation.
#'
#' @param StackId &#91;required&#93; The stack ID.
#' @param AppId The app ID. This parameter is required for app deployments, but not for
#' other deployment commands.
#' @param InstanceIds The instance IDs for the deployment targets.
#' @param LayerIds The layer IDs for the deployment targets.
#' @param Command &#91;required&#93; A `DeploymentCommand` object that specifies the deployment command and
#' any associated arguments.
#' @param Comment A user-defined comment.
#' @param CustomJson A string that contains user-defined, custom JSON. You can use this
#' parameter to override some corresponding default stack configuration
#' JSON values. The string should be in the following format:
#' 
#' `"{\"key1\": \"value1\", \"key2\": \"value2\",...}"`
#' 
#' For more information about custom JSON, see [Use Custom JSON to Modify
#' the Stack Configuration
#' Attributes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html)
#' and [Overriding Attributes With Custom
#' JSON](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html).
#'
#' @keywords internal
#'
#' @rdname opsworks_create_deployment
opsworks_create_deployment <- function(StackId, AppId = NULL, InstanceIds = NULL, LayerIds = NULL, Command, Comment = NULL, CustomJson = NULL) {
  op <- new_operation(
    name = "CreateDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$create_deployment_input(StackId = StackId, AppId = AppId, InstanceIds = InstanceIds, LayerIds = LayerIds, Command = Command, Comment = Comment, CustomJson = CustomJson)
  output <- .opsworks$create_deployment_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$create_deployment <- opsworks_create_deployment

#' Creates an instance in a specified stack
#'
#' @description
#' Creates an instance in a specified stack. For more information, see [Adding an Instance to a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_create_instance/](https://www.paws-r-sdk.com/docs/opsworks_create_instance/) for full documentation.
#'
#' @param StackId &#91;required&#93; The stack ID.
#' @param LayerIds &#91;required&#93; An array that contains the instance's layer IDs.
#' @param InstanceType &#91;required&#93; The instance type, such as `t2.micro`. For a list of supported instance
#' types, open the stack in the console, choose **Instances**, and choose
#' **+ Instance**. The **Size** list contains the currently supported
#' types. For more information, see [Instance Families and
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
#' The parameter values that you use to specify the various types are in
#' the **API Name** column of the **Available Instance Types** table.
#' @param AutoScalingType For load-based or time-based instances, the type. Windows stacks can use
#' only time-based instances.
#' @param Hostname The instance host name.
#' @param Os The instance's operating system, which must be set to one of the
#' following.
#' 
#' -   A supported Linux operating system: An Amazon Linux version, such as
#'     `Amazon Linux 2018.03`, `Amazon Linux 2017.09`,
#'     `Amazon Linux 2017.03`, `Amazon Linux 2016.09`,
#'     `Amazon Linux 2016.03`, `Amazon Linux 2015.09`, or
#'     `Amazon Linux 2015.03`.
#' 
#' -   A supported Ubuntu operating system, such as `Ubuntu 16.04 LTS`,
#'     `Ubuntu 14.04 LTS`, or `Ubuntu 12.04 LTS`.
#' 
#' -   `CentOS Linux 7`
#' 
#' -   `Red Hat Enterprise Linux 7`
#' 
#' -   A supported Windows operating system, such as
#'     `Microsoft Windows Server 2012 R2 Base`,
#'     `Microsoft Windows Server 2012 R2 with SQL Server Express`,
#'     `Microsoft Windows Server 2012 R2 with SQL Server Standard`, or
#'     `Microsoft Windows Server 2012 R2 with SQL Server Web`.
#' 
#' -   A custom AMI: `Custom`.
#' 
#' For more information about the supported operating systems, see [AWS
#' OpsWorks Stacks Operating
#' Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
#' 
#' The default option is the current Amazon Linux version. If you set this
#' parameter to `Custom`, you must use the
#' [`create_instance`][opsworks_create_instance] action's AmiId parameter
#' to specify the custom AMI that you want to use. Block device mappings
#' are not supported if the value is `Custom`. For more information about
#' supported operating systems, see [Operating
#' Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html)For
#' more information about how to use custom AMIs with AWS OpsWorks Stacks,
#' see [Using Custom
#' AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
#' @param AmiId A custom AMI ID to be used to create the instance. The AMI should be
#' based on one of the supported operating systems. For more information,
#' see [Using Custom
#' AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
#' 
#' If you specify a custom AMI, you must set `Os` to `Custom`.
#' @param SshKeyName The instance's Amazon EC2 key-pair name.
#' @param AvailabilityZone The instance Availability Zone. For more information, see [Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
#' @param VirtualizationType The instance's virtualization type, `paravirtual` or `hvm`.
#' @param SubnetId The ID of the instance's subnet. If the stack is running in a VPC, you
#' can use this parameter to override the stack's default subnet ID value
#' and direct AWS OpsWorks Stacks to launch the instance in a different
#' subnet.
#' @param Architecture The instance architecture. The default option is `x86_64`. Instance
#' types do not necessarily support both architectures. For a list of the
#' architectures that are supported by the different instance types, see
#' [Instance Families and
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
#' @param RootDeviceType The instance root device type. For more information, see [Storage for
#' the Root
#' Device](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
#' @param BlockDeviceMappings An array of `BlockDeviceMapping` objects that specify the instance's
#' block devices. For more information, see [Block Device
#' Mapping](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html).
#' Note that block device mappings are not supported for custom AMIs.
#' @param InstallUpdatesOnBoot Whether to install operating system and package updates when the
#' instance boots. The default value is `true`. To control when updates are
#' installed, set this value to `false`. You must then update your
#' instances manually by using
#' [`create_deployment`][opsworks_create_deployment] to run the
#' `update_dependencies` stack command or by manually running `yum` (Amazon
#' Linux) or `apt-get` (Ubuntu) on the instances.
#' 
#' We strongly recommend using the default value of `true` to ensure that
#' your instances have the latest security updates.
#' @param EbsOptimized Whether to create an Amazon EBS-optimized instance.
#' @param AgentVersion The default AWS OpsWorks Stacks agent version. You have the following
#' options:
#' 
#' -   `INHERIT` - Use the stack's default agent version setting.
#' 
#' -   *version_number* - Use the specified agent version. This value
#'     overrides the stack's default setting. To update the agent version,
#'     edit the instance configuration and specify a new version. AWS
#'     OpsWorks Stacks then automatically installs that version on the
#'     instance.
#' 
#' The default setting is `INHERIT`. To specify an agent version, you must
#' use the complete version number, not the abbreviated number shown on the
#' console. For a list of available agent version numbers, call
#' [`describe_agent_versions`][opsworks_describe_agent_versions].
#' AgentVersion cannot be set to Chef 12.2.
#' @param Tenancy The instance's tenancy option. The default option is no tenancy, or if
#' the instance is running in a VPC, inherit tenancy settings from the VPC.
#' The following are valid values for this parameter: `dedicated`,
#' `default`, or `host`. Because there are costs associated with changes in
#' tenancy options, we recommend that you research tenancy options before
#' choosing them for your instances. For more information about dedicated
#' hosts, see [Dedicated Hosts
#' Overview](https://aws.amazon.com/ec2/dedicated-hosts/) and [Amazon EC2
#' Dedicated Hosts](https://aws.amazon.com/ec2/dedicated-hosts/). For more
#' information about dedicated instances, see [Dedicated
#' Instances](https://docs.aws.amazon.com/vpc/latest/userguide/) and
#' [Amazon EC2 Dedicated
#' Instances](https://aws.amazon.com/ec2/pricing/dedicated-instances/).
#'
#' @keywords internal
#'
#' @rdname opsworks_create_instance
opsworks_create_instance <- function(StackId, LayerIds, InstanceType, AutoScalingType = NULL, Hostname = NULL, Os = NULL, AmiId = NULL, SshKeyName = NULL, AvailabilityZone = NULL, VirtualizationType = NULL, SubnetId = NULL, Architecture = NULL, RootDeviceType = NULL, BlockDeviceMappings = NULL, InstallUpdatesOnBoot = NULL, EbsOptimized = NULL, AgentVersion = NULL, Tenancy = NULL) {
  op <- new_operation(
    name = "CreateInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$create_instance_input(StackId = StackId, LayerIds = LayerIds, InstanceType = InstanceType, AutoScalingType = AutoScalingType, Hostname = Hostname, Os = Os, AmiId = AmiId, SshKeyName = SshKeyName, AvailabilityZone = AvailabilityZone, VirtualizationType = VirtualizationType, SubnetId = SubnetId, Architecture = Architecture, RootDeviceType = RootDeviceType, BlockDeviceMappings = BlockDeviceMappings, InstallUpdatesOnBoot = InstallUpdatesOnBoot, EbsOptimized = EbsOptimized, AgentVersion = AgentVersion, Tenancy = Tenancy)
  output <- .opsworks$create_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$create_instance <- opsworks_create_instance

#' Creates a layer
#'
#' @description
#' Creates a layer. For more information, see [How to Create a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-create.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_create_layer/](https://www.paws-r-sdk.com/docs/opsworks_create_layer/) for full documentation.
#'
#' @param StackId &#91;required&#93; The layer stack ID.
#' @param Type &#91;required&#93; The layer type. A stack cannot have more than one built-in layer of the
#' same type. It can have any number of custom layers. Built-in layers are
#' not available in Chef 12 stacks.
#' @param Name &#91;required&#93; The layer name, which is used by the console.
#' @param Shortname &#91;required&#93; For custom layers only, use this parameter to specify the layer's short
#' name, which is used internally by AWS OpsWorks Stacks and by Chef
#' recipes. The short name is also used as the name for the directory where
#' your app files are installed. It can have a maximum of 200 characters,
#' which are limited to the alphanumeric characters, '-', '_', and '.'.
#' 
#' The built-in layers' short names are defined by AWS OpsWorks Stacks. For
#' more information, see the [Layer
#' Reference](https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html).
#' @param Attributes One or more user-defined key-value pairs to be added to the stack
#' attributes.
#' 
#' To create a cluster layer, set the `EcsClusterArn` attribute to the
#' cluster's ARN.
#' @param CloudWatchLogsConfiguration Specifies CloudWatch Logs configuration options for the layer. For more
#' information, see CloudWatchLogsLogStream.
#' @param CustomInstanceProfileArn The ARN of an IAM profile to be used for the layer's EC2 instances. For
#' more information about IAM ARNs, see [Using
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html).
#' @param CustomJson A JSON-formatted string containing custom stack configuration and
#' deployment attributes to be installed on the layer's instances. For more
#' information, see [Using Custom
#' JSON](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html).
#' This feature is supported as of version 1.7.42 of the AWS CLI.
#' @param CustomSecurityGroupIds An array containing the layer custom security group IDs.
#' @param Packages An array of `Package` objects that describes the layer packages.
#' @param VolumeConfigurations A `VolumeConfigurations` object that describes the layer's Amazon EBS
#' volumes.
#' @param EnableAutoHealing Whether to disable auto healing for the layer.
#' @param AutoAssignElasticIps Whether to automatically assign an [Elastic IP
#' address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#' to the layer's instances. For more information, see [How to Edit a
#' Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
#' @param AutoAssignPublicIps For stacks that are running in a VPC, whether to automatically assign a
#' public IP address to the layer's instances. For more information, see
#' [How to Edit a
#' Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
#' @param CustomRecipes A `LayerCustomRecipes` object that specifies the layer custom recipes.
#' @param InstallUpdatesOnBoot Whether to install operating system and package updates when the
#' instance boots. The default value is `true`. To control when updates are
#' installed, set this value to `false`. You must then update your
#' instances manually by using
#' [`create_deployment`][opsworks_create_deployment] to run the
#' `update_dependencies` stack command or by manually running `yum` (Amazon
#' Linux) or `apt-get` (Ubuntu) on the instances.
#' 
#' To ensure that your instances have the latest security updates, we
#' strongly recommend using the default value of `true`.
#' @param UseEbsOptimizedInstances Whether to use Amazon EBS-optimized instances.
#' @param LifecycleEventConfiguration A `LifeCycleEventConfiguration` object that you can use to configure the
#' Shutdown event to specify an execution timeout and enable or disable
#' Elastic Load Balancer connection draining.
#'
#' @keywords internal
#'
#' @rdname opsworks_create_layer
opsworks_create_layer <- function(StackId, Type, Name, Shortname, Attributes = NULL, CloudWatchLogsConfiguration = NULL, CustomInstanceProfileArn = NULL, CustomJson = NULL, CustomSecurityGroupIds = NULL, Packages = NULL, VolumeConfigurations = NULL, EnableAutoHealing = NULL, AutoAssignElasticIps = NULL, AutoAssignPublicIps = NULL, CustomRecipes = NULL, InstallUpdatesOnBoot = NULL, UseEbsOptimizedInstances = NULL, LifecycleEventConfiguration = NULL) {
  op <- new_operation(
    name = "CreateLayer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$create_layer_input(StackId = StackId, Type = Type, Name = Name, Shortname = Shortname, Attributes = Attributes, CloudWatchLogsConfiguration = CloudWatchLogsConfiguration, CustomInstanceProfileArn = CustomInstanceProfileArn, CustomJson = CustomJson, CustomSecurityGroupIds = CustomSecurityGroupIds, Packages = Packages, VolumeConfigurations = VolumeConfigurations, EnableAutoHealing = EnableAutoHealing, AutoAssignElasticIps = AutoAssignElasticIps, AutoAssignPublicIps = AutoAssignPublicIps, CustomRecipes = CustomRecipes, InstallUpdatesOnBoot = InstallUpdatesOnBoot, UseEbsOptimizedInstances = UseEbsOptimizedInstances, LifecycleEventConfiguration = LifecycleEventConfiguration)
  output <- .opsworks$create_layer_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$create_layer <- opsworks_create_layer

#' Creates a new stack
#'
#' @description
#' Creates a new stack. For more information, see [Create a New Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-edit.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_create_stack/](https://www.paws-r-sdk.com/docs/opsworks_create_stack/) for full documentation.
#'
#' @param Name &#91;required&#93; The stack name.
#' @param Region &#91;required&#93; The stack's AWS region, such as `ap-south-1`. For more information about
#' Amazon regions, see [Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
#' 
#' In the AWS CLI, this API maps to the `--stack-region` parameter. If the
#' `--stack-region` parameter and the AWS CLI common parameter `--region`
#' are set to the same value, the stack uses a *regional* endpoint. If the
#' `--stack-region` parameter is not set, but the AWS CLI `--region`
#' parameter is, this also results in a stack with a *regional* endpoint.
#' However, if the `--region` parameter is set to `us-east-1`, and the
#' `--stack-region` parameter is set to one of the following, then the
#' stack uses a legacy or *classic* region:
#' `us-west-1, us-west-2, sa-east-1, eu-central-1, eu-west-1, ap-northeast-1, ap-southeast-1, ap-southeast-2`.
#' In this case, the actual API endpoint of the stack is in `us-east-1`.
#' Only the preceding regions are supported as classic regions in the
#' `us-east-1` API endpoint. Because it is a best practice to choose the
#' regional endpoint that is closest to where you manage AWS, we recommend
#' that you use regional endpoints for new stacks. The AWS CLI common
#' `--region` parameter always specifies a regional API endpoint; it cannot
#' be used to specify a classic AWS OpsWorks Stacks region.
#' @param VpcId The ID of the VPC that the stack is to be launched into. The VPC must be
#' in the stack's region. All instances are launched into this VPC. You
#' cannot change the ID later.
#' 
#' -   If your account supports EC2-Classic, the default value is `no VPC`.
#' 
#' -   If your account does not support EC2-Classic, the default value is
#'     the default VPC for the specified region.
#' 
#' If the VPC ID corresponds to a default VPC and you have specified either
#' the `DefaultAvailabilityZone` or the `DefaultSubnetId` parameter only,
#' AWS OpsWorks Stacks infers the value of the other parameter. If you
#' specify neither parameter, AWS OpsWorks Stacks sets these parameters to
#' the first valid Availability Zone for the specified region and the
#' corresponding default VPC subnet ID, respectively.
#' 
#' If you specify a nondefault VPC ID, note the following:
#' 
#' -   It must belong to a VPC in your account that is in the specified
#'     region.
#' 
#' -   You must specify a value for `DefaultSubnetId`.
#' 
#' For more information about how to use AWS OpsWorks Stacks with a VPC,
#' see [Running a Stack in a
#' VPC](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html).
#' For more information about default VPC and EC2-Classic, see [Supported
#' Platforms](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-classic-platform.html).
#' @param Attributes One or more user-defined key-value pairs to be added to the stack
#' attributes.
#' @param ServiceRoleArn &#91;required&#93; The stack's AWS Identity and Access Management (IAM) role, which allows
#' AWS OpsWorks Stacks to work with AWS resources on your behalf. You must
#' set this parameter to the Amazon Resource Name (ARN) for an existing IAM
#' role. For more information about IAM ARNs, see [Using
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html).
#' @param DefaultInstanceProfileArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM profile that is the default
#' profile for all of the stack's EC2 instances. For more information about
#' IAM ARNs, see [Using
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html).
#' @param DefaultOs The stack's default operating system, which is installed on every
#' instance unless you specify a different operating system when you create
#' the instance. You can specify one of the following.
#' 
#' -   A supported Linux operating system: An Amazon Linux version, such as
#'     `Amazon Linux 2018.03`, `Amazon Linux 2017.09`,
#'     `Amazon Linux 2017.03`, `Amazon Linux 2016.09`,
#'     `Amazon Linux 2016.03`, `Amazon Linux 2015.09`, or
#'     `Amazon Linux 2015.03`.
#' 
#' -   A supported Ubuntu operating system, such as `Ubuntu 16.04 LTS`,
#'     `Ubuntu 14.04 LTS`, or `Ubuntu 12.04 LTS`.
#' 
#' -   `CentOS Linux 7`
#' 
#' -   `Red Hat Enterprise Linux 7`
#' 
#' -   A supported Windows operating system, such as
#'     `Microsoft Windows Server 2012 R2 Base`,
#'     `Microsoft Windows Server 2012 R2 with SQL Server Express`,
#'     `Microsoft Windows Server 2012 R2 with SQL Server Standard`, or
#'     `Microsoft Windows Server 2012 R2 with SQL Server Web`.
#' 
#' -   A custom AMI: `Custom`. You specify the custom AMI you want to use
#'     when you create instances. For more information, see [Using Custom
#'     AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
#' 
#' The default option is the current Amazon Linux version. For more
#' information about supported operating systems, see [AWS OpsWorks Stacks
#' Operating
#' Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
#' @param HostnameTheme The stack's host name theme, with spaces replaced by underscores. The
#' theme is used to generate host names for the stack's instances. By
#' default, `HostnameTheme` is set to `Layer_Dependent`, which creates host
#' names by appending integers to the layer's short name. The other themes
#' are:
#' 
#' -   `Baked_Goods`
#' 
#' -   `Clouds`
#' 
#' -   `Europe_Cities`
#' 
#' -   `Fruits`
#' 
#' -   `Greek_Deities_and_Titans`
#' 
#' -   `Legendary_creatures_from_Japan`
#' 
#' -   `Planets_and_Moons`
#' 
#' -   `Roman_Deities`
#' 
#' -   `Scottish_Islands`
#' 
#' -   `US_Cities`
#' 
#' -   `Wild_Cats`
#' 
#' To obtain a generated host name, call `GetHostNameSuggestion`, which
#' returns a host name based on the current theme.
#' @param DefaultAvailabilityZone The stack's default Availability Zone, which must be in the specified
#' region. For more information, see [Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html). If
#' you also specify a value for `DefaultSubnetId`, the subnet must be in
#' the same zone. For more information, see the `VpcId` parameter
#' description.
#' @param DefaultSubnetId The stack's default VPC subnet ID. This parameter is required if you
#' specify a value for the `VpcId` parameter. All instances are launched
#' into this subnet unless you specify otherwise when you create the
#' instance. If you also specify a value for `DefaultAvailabilityZone`, the
#' subnet must be in that zone. For information on default values and when
#' this parameter is required, see the `VpcId` parameter description.
#' @param CustomJson A string that contains user-defined, custom JSON. It can be used to
#' override the corresponding default stack configuration attribute values
#' or to pass data to recipes. The string should be in the following
#' format:
#' 
#' `"{\"key1\": \"value1\", \"key2\": \"value2\",...}"`
#' 
#' For more information about custom JSON, see [Use Custom JSON to Modify
#' the Stack Configuration
#' Attributes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
#' @param ConfigurationManager The configuration manager. When you create a stack we recommend that you
#' use the configuration manager to specify the Chef version: 12, 11.10, or
#' 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for
#' Linux stacks is currently 12.
#' @param ChefConfiguration A `ChefConfiguration` object that specifies whether to enable Berkshelf
#' and the Berkshelf version on Chef 11.10 stacks. For more information,
#' see [Create a New
#' Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
#' @param UseCustomCookbooks Whether the stack uses custom cookbooks.
#' @param UseOpsworksSecurityGroups Whether to associate the AWS OpsWorks Stacks built-in security groups
#' with the stack's layers.
#' 
#' AWS OpsWorks Stacks provides a standard set of built-in security groups,
#' one for each layer, which are associated with layers by default. With
#' `UseOpsworksSecurityGroups` you can instead provide your own custom
#' security groups. `UseOpsworksSecurityGroups` has the following settings:
#' 
#' -   True - AWS OpsWorks Stacks automatically associates the appropriate
#'     built-in security group with each layer (default setting). You can
#'     associate additional security groups with a layer after you create
#'     it, but you cannot delete the built-in security group.
#' 
#' -   False - AWS OpsWorks Stacks does not associate built-in security
#'     groups with layers. You must create appropriate EC2 security groups
#'     and associate a security group with each layer that you create.
#'     However, you can still manually associate a built-in security group
#'     with a layer on creation; custom security groups are required only
#'     for those layers that need custom settings.
#' 
#' For more information, see [Create a New
#' Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
#' @param CustomCookbooksSource Contains the information required to retrieve an app or cookbook from a
#' repository. For more information, see [Adding
#' Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
#' or [Cookbooks and
#' Recipes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
#' @param DefaultSshKeyName A default Amazon EC2 key pair name. The default value is none. If you
#' specify a key pair name, AWS OpsWorks installs the public key on the
#' instance and you can use the private key with an SSH client to log in to
#' the instance. For more information, see [Using SSH to Communicate with
#' an
#' Instance](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html)
#' and [Managing SSH
#' Access](https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html).
#' You can override this setting by specifying a different key pair, or no
#' key pair, when you [create an
#' instance](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
#' @param DefaultRootDeviceType The default root device type. This value is the default for all
#' instances in the stack, but you can override it when you create an
#' instance. The default option is `instance-store`. For more information,
#' see [Storage for the Root
#' Device](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
#' @param AgentVersion The default AWS OpsWorks Stacks agent version. You have the following
#' options:
#' 
#' -   Auto-update - Set this parameter to `LATEST`. AWS OpsWorks Stacks
#'     automatically installs new agent versions on the stack's instances
#'     as soon as they are available.
#' 
#' -   Fixed version - Set this parameter to your preferred agent version.
#'     To update the agent version, you must edit the stack configuration
#'     and specify a new version. AWS OpsWorks Stacks then automatically
#'     installs that version on the stack's instances.
#' 
#' The default setting is the most recent release of the agent. To specify
#' an agent version, you must use the complete version number, not the
#' abbreviated number shown on the console. For a list of available agent
#' version numbers, call
#' [`describe_agent_versions`][opsworks_describe_agent_versions].
#' AgentVersion cannot be set to Chef 12.2.
#' 
#' You can also specify an agent version when you create or update an
#' instance, which overrides the stack's default setting.
#'
#' @keywords internal
#'
#' @rdname opsworks_create_stack
opsworks_create_stack <- function(Name, Region, VpcId = NULL, Attributes = NULL, ServiceRoleArn, DefaultInstanceProfileArn, DefaultOs = NULL, HostnameTheme = NULL, DefaultAvailabilityZone = NULL, DefaultSubnetId = NULL, CustomJson = NULL, ConfigurationManager = NULL, ChefConfiguration = NULL, UseCustomCookbooks = NULL, UseOpsworksSecurityGroups = NULL, CustomCookbooksSource = NULL, DefaultSshKeyName = NULL, DefaultRootDeviceType = NULL, AgentVersion = NULL) {
  op <- new_operation(
    name = "CreateStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$create_stack_input(Name = Name, Region = Region, VpcId = VpcId, Attributes = Attributes, ServiceRoleArn = ServiceRoleArn, DefaultInstanceProfileArn = DefaultInstanceProfileArn, DefaultOs = DefaultOs, HostnameTheme = HostnameTheme, DefaultAvailabilityZone = DefaultAvailabilityZone, DefaultSubnetId = DefaultSubnetId, CustomJson = CustomJson, ConfigurationManager = ConfigurationManager, ChefConfiguration = ChefConfiguration, UseCustomCookbooks = UseCustomCookbooks, UseOpsworksSecurityGroups = UseOpsworksSecurityGroups, CustomCookbooksSource = CustomCookbooksSource, DefaultSshKeyName = DefaultSshKeyName, DefaultRootDeviceType = DefaultRootDeviceType, AgentVersion = AgentVersion)
  output <- .opsworks$create_stack_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$create_stack <- opsworks_create_stack

#' Creates a new user profile
#'
#' @description
#' Creates a new user profile.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_create_user_profile/](https://www.paws-r-sdk.com/docs/opsworks_create_user_profile/) for full documentation.
#'
#' @param IamUserArn &#91;required&#93; The user's IAM ARN; this can also be a federated user's ARN.
#' @param SshUsername The user's SSH user name. The allowable characters are \[a-z\], \[A-Z\],
#' \[0-9\], '-', and '_'. If the specified name includes other punctuation
#' marks, AWS OpsWorks Stacks removes them. For example, `my.name` will be
#' changed to `myname`. If you do not specify an SSH user name, AWS
#' OpsWorks Stacks generates one from the IAM user name.
#' @param SshPublicKey The user's public SSH key.
#' @param AllowSelfManagement Whether users can specify their own SSH public key through the My
#' Settings page. For more information, see [Setting an IAM User's Public
#' SSH
#' Key](https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html).
#'
#' @keywords internal
#'
#' @rdname opsworks_create_user_profile
opsworks_create_user_profile <- function(IamUserArn, SshUsername = NULL, SshPublicKey = NULL, AllowSelfManagement = NULL) {
  op <- new_operation(
    name = "CreateUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$create_user_profile_input(IamUserArn = IamUserArn, SshUsername = SshUsername, SshPublicKey = SshPublicKey, AllowSelfManagement = AllowSelfManagement)
  output <- .opsworks$create_user_profile_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$create_user_profile <- opsworks_create_user_profile

#' Deletes a specified app
#'
#' @description
#' Deletes a specified app.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_delete_app/](https://www.paws-r-sdk.com/docs/opsworks_delete_app/) for full documentation.
#'
#' @param AppId &#91;required&#93; The app ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_delete_app
opsworks_delete_app <- function(AppId) {
  op <- new_operation(
    name = "DeleteApp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$delete_app_input(AppId = AppId)
  output <- .opsworks$delete_app_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$delete_app <- opsworks_delete_app

#' Deletes a specified instance, which terminates the associated Amazon EC2
#' instance
#'
#' @description
#' Deletes a specified instance, which terminates the associated Amazon EC2 instance. You must stop an instance before you can delete it.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_delete_instance/](https://www.paws-r-sdk.com/docs/opsworks_delete_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The instance ID.
#' @param DeleteElasticIp Whether to delete the instance Elastic IP address.
#' @param DeleteVolumes Whether to delete the instance's Amazon EBS volumes.
#'
#' @keywords internal
#'
#' @rdname opsworks_delete_instance
opsworks_delete_instance <- function(InstanceId, DeleteElasticIp = NULL, DeleteVolumes = NULL) {
  op <- new_operation(
    name = "DeleteInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$delete_instance_input(InstanceId = InstanceId, DeleteElasticIp = DeleteElasticIp, DeleteVolumes = DeleteVolumes)
  output <- .opsworks$delete_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$delete_instance <- opsworks_delete_instance

#' Deletes a specified layer
#'
#' @description
#' Deletes a specified layer. You must first stop and then delete all associated instances or unassign registered instances. For more information, see [How to Delete a Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-delete.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_delete_layer/](https://www.paws-r-sdk.com/docs/opsworks_delete_layer/) for full documentation.
#'
#' @param LayerId &#91;required&#93; The layer ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_delete_layer
opsworks_delete_layer <- function(LayerId) {
  op <- new_operation(
    name = "DeleteLayer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$delete_layer_input(LayerId = LayerId)
  output <- .opsworks$delete_layer_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$delete_layer <- opsworks_delete_layer

#' Deletes a specified stack
#'
#' @description
#' Deletes a specified stack. You must first delete all instances, layers, and apps or deregister registered instances. For more information, see [Shut Down a Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-shutting.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_delete_stack/](https://www.paws-r-sdk.com/docs/opsworks_delete_stack/) for full documentation.
#'
#' @param StackId &#91;required&#93; The stack ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_delete_stack
opsworks_delete_stack <- function(StackId) {
  op <- new_operation(
    name = "DeleteStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$delete_stack_input(StackId = StackId)
  output <- .opsworks$delete_stack_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$delete_stack <- opsworks_delete_stack

#' Deletes a user profile
#'
#' @description
#' Deletes a user profile.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_delete_user_profile/](https://www.paws-r-sdk.com/docs/opsworks_delete_user_profile/) for full documentation.
#'
#' @param IamUserArn &#91;required&#93; The user's IAM ARN. This can also be a federated user's ARN.
#'
#' @keywords internal
#'
#' @rdname opsworks_delete_user_profile
opsworks_delete_user_profile <- function(IamUserArn) {
  op <- new_operation(
    name = "DeleteUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$delete_user_profile_input(IamUserArn = IamUserArn)
  output <- .opsworks$delete_user_profile_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$delete_user_profile <- opsworks_delete_user_profile

#' Deregisters a specified Amazon ECS cluster from a stack
#'
#' @description
#' Deregisters a specified Amazon ECS cluster from a stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html#workinglayers-ecscluster-delete).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_deregister_ecs_cluster/](https://www.paws-r-sdk.com/docs/opsworks_deregister_ecs_cluster/) for full documentation.
#'
#' @param EcsClusterArn &#91;required&#93; The cluster's Amazon Resource Number (ARN).
#'
#' @keywords internal
#'
#' @rdname opsworks_deregister_ecs_cluster
opsworks_deregister_ecs_cluster <- function(EcsClusterArn) {
  op <- new_operation(
    name = "DeregisterEcsCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$deregister_ecs_cluster_input(EcsClusterArn = EcsClusterArn)
  output <- .opsworks$deregister_ecs_cluster_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$deregister_ecs_cluster <- opsworks_deregister_ecs_cluster

#' Deregisters a specified Elastic IP address
#'
#' @description
#' Deregisters a specified Elastic IP address. The address can then be registered by another stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_deregister_elastic_ip/](https://www.paws-r-sdk.com/docs/opsworks_deregister_elastic_ip/) for full documentation.
#'
#' @param ElasticIp &#91;required&#93; The Elastic IP address.
#'
#' @keywords internal
#'
#' @rdname opsworks_deregister_elastic_ip
opsworks_deregister_elastic_ip <- function(ElasticIp) {
  op <- new_operation(
    name = "DeregisterElasticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$deregister_elastic_ip_input(ElasticIp = ElasticIp)
  output <- .opsworks$deregister_elastic_ip_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$deregister_elastic_ip <- opsworks_deregister_elastic_ip

#' Deregister a registered Amazon EC2 or on-premises instance
#'
#' @description
#' Deregister a registered Amazon EC2 or on-premises instance. This action removes the instance from the stack and returns it to your control. This action cannot be used with instances that were created with AWS OpsWorks Stacks.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_deregister_instance/](https://www.paws-r-sdk.com/docs/opsworks_deregister_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The instance ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_deregister_instance
opsworks_deregister_instance <- function(InstanceId) {
  op <- new_operation(
    name = "DeregisterInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$deregister_instance_input(InstanceId = InstanceId)
  output <- .opsworks$deregister_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$deregister_instance <- opsworks_deregister_instance

#' Deregisters an Amazon RDS instance
#'
#' @description
#' Deregisters an Amazon RDS instance.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_deregister_rds_db_instance/](https://www.paws-r-sdk.com/docs/opsworks_deregister_rds_db_instance/) for full documentation.
#'
#' @param RdsDbInstanceArn &#91;required&#93; The Amazon RDS instance's ARN.
#'
#' @keywords internal
#'
#' @rdname opsworks_deregister_rds_db_instance
opsworks_deregister_rds_db_instance <- function(RdsDbInstanceArn) {
  op <- new_operation(
    name = "DeregisterRdsDbInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$deregister_rds_db_instance_input(RdsDbInstanceArn = RdsDbInstanceArn)
  output <- .opsworks$deregister_rds_db_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$deregister_rds_db_instance <- opsworks_deregister_rds_db_instance

#' Deregisters an Amazon EBS volume
#'
#' @description
#' Deregisters an Amazon EBS volume. The volume can then be registered by another stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_deregister_volume/](https://www.paws-r-sdk.com/docs/opsworks_deregister_volume/) for full documentation.
#'
#' @param VolumeId &#91;required&#93; The AWS OpsWorks Stacks volume ID, which is the GUID that AWS OpsWorks
#' Stacks assigned to the instance when you registered the volume with the
#' stack, not the Amazon EC2 volume ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_deregister_volume
opsworks_deregister_volume <- function(VolumeId) {
  op <- new_operation(
    name = "DeregisterVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$deregister_volume_input(VolumeId = VolumeId)
  output <- .opsworks$deregister_volume_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$deregister_volume <- opsworks_deregister_volume

#' Describes the available AWS OpsWorks Stacks agent versions
#'
#' @description
#' Describes the available AWS OpsWorks Stacks agent versions. You must specify a stack ID or a configuration manager. [`describe_agent_versions`][opsworks_describe_agent_versions] returns a list of available agent versions for the specified stack or configuration manager.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_agent_versions/](https://www.paws-r-sdk.com/docs/opsworks_describe_agent_versions/) for full documentation.
#'
#' @param StackId The stack ID.
#' @param ConfigurationManager The configuration manager.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_agent_versions
opsworks_describe_agent_versions <- function(StackId = NULL, ConfigurationManager = NULL) {
  op <- new_operation(
    name = "DescribeAgentVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_agent_versions_input(StackId = StackId, ConfigurationManager = ConfigurationManager)
  output <- .opsworks$describe_agent_versions_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_agent_versions <- opsworks_describe_agent_versions

#' Requests a description of a specified set of apps
#'
#' @description
#' Requests a description of a specified set of apps.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_apps/](https://www.paws-r-sdk.com/docs/opsworks_describe_apps/) for full documentation.
#'
#' @param StackId The app stack ID. If you use this parameter,
#' [`describe_apps`][opsworks_describe_apps] returns a description of the
#' apps in the specified stack.
#' @param AppIds An array of app IDs for the apps to be described. If you use this
#' parameter, [`describe_apps`][opsworks_describe_apps] returns a
#' description of the specified apps. Otherwise, it returns a description
#' of every app.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_apps
opsworks_describe_apps <- function(StackId = NULL, AppIds = NULL) {
  op <- new_operation(
    name = "DescribeApps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_apps_input(StackId = StackId, AppIds = AppIds)
  output <- .opsworks$describe_apps_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_apps <- opsworks_describe_apps

#' Describes the results of specified commands
#'
#' @description
#' Describes the results of specified commands.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_commands/](https://www.paws-r-sdk.com/docs/opsworks_describe_commands/) for full documentation.
#'
#' @param DeploymentId The deployment ID. If you include this parameter,
#' [`describe_commands`][opsworks_describe_commands] returns a description
#' of the commands associated with the specified deployment.
#' @param InstanceId The instance ID. If you include this parameter,
#' [`describe_commands`][opsworks_describe_commands] returns a description
#' of the commands associated with the specified instance.
#' @param CommandIds An array of command IDs. If you include this parameter,
#' [`describe_commands`][opsworks_describe_commands] returns a description
#' of the specified commands. Otherwise, it returns a description of every
#' command.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_commands
opsworks_describe_commands <- function(DeploymentId = NULL, InstanceId = NULL, CommandIds = NULL) {
  op <- new_operation(
    name = "DescribeCommands",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_commands_input(DeploymentId = DeploymentId, InstanceId = InstanceId, CommandIds = CommandIds)
  output <- .opsworks$describe_commands_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_commands <- opsworks_describe_commands

#' Requests a description of a specified set of deployments
#'
#' @description
#' Requests a description of a specified set of deployments.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_deployments/](https://www.paws-r-sdk.com/docs/opsworks_describe_deployments/) for full documentation.
#'
#' @param StackId The stack ID. If you include this parameter, the command returns a
#' description of the commands associated with the specified stack.
#' @param AppId The app ID. If you include this parameter, the command returns a
#' description of the commands associated with the specified app.
#' @param DeploymentIds An array of deployment IDs to be described. If you include this
#' parameter, the command returns a description of the specified
#' deployments. Otherwise, it returns a description of every deployment.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_deployments
opsworks_describe_deployments <- function(StackId = NULL, AppId = NULL, DeploymentIds = NULL) {
  op <- new_operation(
    name = "DescribeDeployments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_deployments_input(StackId = StackId, AppId = AppId, DeploymentIds = DeploymentIds)
  output <- .opsworks$describe_deployments_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_deployments <- opsworks_describe_deployments

#' Describes Amazon ECS clusters that are registered with a stack
#'
#' @description
#' Describes Amazon ECS clusters that are registered with a stack. If you specify only a stack ID, you can use the `MaxResults` and `NextToken` parameters to paginate the response. However, AWS OpsWorks Stacks currently supports only one cluster per layer, so the result set has a maximum of one element.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_ecs_clusters/](https://www.paws-r-sdk.com/docs/opsworks_describe_ecs_clusters/) for full documentation.
#'
#' @param EcsClusterArns A list of ARNs, one for each cluster to be described.
#' @param StackId A stack ID. [`describe_ecs_clusters`][opsworks_describe_ecs_clusters]
#' returns a description of the cluster that is registered with the stack.
#' @param NextToken If the previous paginated request did not return all of the remaining
#' results, the response object's`NextToken` parameter value is set to a
#' token. To retrieve the next set of results, call
#' [`describe_ecs_clusters`][opsworks_describe_ecs_clusters] again and
#' assign that token to the request object's `NextToken` parameter. If
#' there are no remaining results, the previous response object's
#' `NextToken` parameter is set to `null`.
#' @param MaxResults To receive a paginated response, use this parameter to specify the
#' maximum number of results to be returned with a single call. If the
#' number of available results exceeds this maximum, the response includes
#' a `NextToken` value that you can assign to the `NextToken` request
#' parameter to get the next set of results.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_ecs_clusters
opsworks_describe_ecs_clusters <- function(EcsClusterArns = NULL, StackId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeEcsClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_ecs_clusters_input(EcsClusterArns = EcsClusterArns, StackId = StackId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .opsworks$describe_ecs_clusters_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_ecs_clusters <- opsworks_describe_ecs_clusters

#' Describes Elastic IP addresses
#'
#' @description
#' Describes [Elastic IP addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_elastic_ips/](https://www.paws-r-sdk.com/docs/opsworks_describe_elastic_ips/) for full documentation.
#'
#' @param InstanceId The instance ID. If you include this parameter,
#' [`describe_elastic_ips`][opsworks_describe_elastic_ips] returns a
#' description of the Elastic IP addresses associated with the specified
#' instance.
#' @param StackId A stack ID. If you include this parameter,
#' [`describe_elastic_ips`][opsworks_describe_elastic_ips] returns a
#' description of the Elastic IP addresses that are registered with the
#' specified stack.
#' @param Ips An array of Elastic IP addresses to be described. If you include this
#' parameter, [`describe_elastic_ips`][opsworks_describe_elastic_ips]
#' returns a description of the specified Elastic IP addresses. Otherwise,
#' it returns a description of every Elastic IP address.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_elastic_ips
opsworks_describe_elastic_ips <- function(InstanceId = NULL, StackId = NULL, Ips = NULL) {
  op <- new_operation(
    name = "DescribeElasticIps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_elastic_ips_input(InstanceId = InstanceId, StackId = StackId, Ips = Ips)
  output <- .opsworks$describe_elastic_ips_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_elastic_ips <- opsworks_describe_elastic_ips

#' Describes a stack's Elastic Load Balancing instances
#'
#' @description
#' Describes a stack's Elastic Load Balancing instances.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_elastic_load_balancers/](https://www.paws-r-sdk.com/docs/opsworks_describe_elastic_load_balancers/) for full documentation.
#'
#' @param StackId A stack ID. The action describes the stack's Elastic Load Balancing
#' instances.
#' @param LayerIds A list of layer IDs. The action describes the Elastic Load Balancing
#' instances for the specified layers.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_elastic_load_balancers
opsworks_describe_elastic_load_balancers <- function(StackId = NULL, LayerIds = NULL) {
  op <- new_operation(
    name = "DescribeElasticLoadBalancers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_elastic_load_balancers_input(StackId = StackId, LayerIds = LayerIds)
  output <- .opsworks$describe_elastic_load_balancers_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_elastic_load_balancers <- opsworks_describe_elastic_load_balancers

#' Requests a description of a set of instances
#'
#' @description
#' Requests a description of a set of instances.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_instances/](https://www.paws-r-sdk.com/docs/opsworks_describe_instances/) for full documentation.
#'
#' @param StackId A stack ID. If you use this parameter,
#' [`describe_instances`][opsworks_describe_instances] returns descriptions
#' of the instances associated with the specified stack.
#' @param LayerId A layer ID. If you use this parameter,
#' [`describe_instances`][opsworks_describe_instances] returns descriptions
#' of the instances associated with the specified layer.
#' @param InstanceIds An array of instance IDs to be described. If you use this parameter,
#' [`describe_instances`][opsworks_describe_instances] returns a
#' description of the specified instances. Otherwise, it returns a
#' description of every instance.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_instances
opsworks_describe_instances <- function(StackId = NULL, LayerId = NULL, InstanceIds = NULL) {
  op <- new_operation(
    name = "DescribeInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_instances_input(StackId = StackId, LayerId = LayerId, InstanceIds = InstanceIds)
  output <- .opsworks$describe_instances_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_instances <- opsworks_describe_instances

#' Requests a description of one or more layers in a specified stack
#'
#' @description
#' Requests a description of one or more layers in a specified stack.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_layers/](https://www.paws-r-sdk.com/docs/opsworks_describe_layers/) for full documentation.
#'
#' @param StackId The stack ID.
#' @param LayerIds An array of layer IDs that specify the layers to be described. If you
#' omit this parameter, [`describe_layers`][opsworks_describe_layers]
#' returns a description of every layer in the specified stack.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_layers
opsworks_describe_layers <- function(StackId = NULL, LayerIds = NULL) {
  op <- new_operation(
    name = "DescribeLayers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_layers_input(StackId = StackId, LayerIds = LayerIds)
  output <- .opsworks$describe_layers_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_layers <- opsworks_describe_layers

#' Describes load-based auto scaling configurations for specified layers
#'
#' @description
#' Describes load-based auto scaling configurations for specified layers.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_load_based_auto_scaling/](https://www.paws-r-sdk.com/docs/opsworks_describe_load_based_auto_scaling/) for full documentation.
#'
#' @param LayerIds &#91;required&#93; An array of layer IDs.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_load_based_auto_scaling
opsworks_describe_load_based_auto_scaling <- function(LayerIds) {
  op <- new_operation(
    name = "DescribeLoadBasedAutoScaling",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_load_based_auto_scaling_input(LayerIds = LayerIds)
  output <- .opsworks$describe_load_based_auto_scaling_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_load_based_auto_scaling <- opsworks_describe_load_based_auto_scaling

#' Describes a user's SSH information
#'
#' @description
#' Describes a user's SSH information.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_my_user_profile/](https://www.paws-r-sdk.com/docs/opsworks_describe_my_user_profile/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname opsworks_describe_my_user_profile
opsworks_describe_my_user_profile <- function() {
  op <- new_operation(
    name = "DescribeMyUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_my_user_profile_input()
  output <- .opsworks$describe_my_user_profile_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_my_user_profile <- opsworks_describe_my_user_profile

#' Describes the operating systems that are supported by AWS OpsWorks
#' Stacks
#'
#' @description
#' Describes the operating systems that are supported by AWS OpsWorks Stacks.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_operating_systems/](https://www.paws-r-sdk.com/docs/opsworks_describe_operating_systems/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname opsworks_describe_operating_systems
opsworks_describe_operating_systems <- function() {
  op <- new_operation(
    name = "DescribeOperatingSystems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_operating_systems_input()
  output <- .opsworks$describe_operating_systems_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_operating_systems <- opsworks_describe_operating_systems

#' Describes the permissions for a specified stack
#'
#' @description
#' Describes the permissions for a specified stack.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_permissions/](https://www.paws-r-sdk.com/docs/opsworks_describe_permissions/) for full documentation.
#'
#' @param IamUserArn The user's IAM ARN. This can also be a federated user's ARN. For more
#' information about IAM ARNs, see [Using
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html).
#' @param StackId The stack ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_permissions
opsworks_describe_permissions <- function(IamUserArn = NULL, StackId = NULL) {
  op <- new_operation(
    name = "DescribePermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_permissions_input(IamUserArn = IamUserArn, StackId = StackId)
  output <- .opsworks$describe_permissions_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_permissions <- opsworks_describe_permissions

#' Describe an instance's RAID arrays
#'
#' @description
#' Describe an instance's RAID arrays.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_raid_arrays/](https://www.paws-r-sdk.com/docs/opsworks_describe_raid_arrays/) for full documentation.
#'
#' @param InstanceId The instance ID. If you use this parameter,
#' [`describe_raid_arrays`][opsworks_describe_raid_arrays] returns
#' descriptions of the RAID arrays associated with the specified instance.
#' @param StackId The stack ID.
#' @param RaidArrayIds An array of RAID array IDs. If you use this parameter,
#' [`describe_raid_arrays`][opsworks_describe_raid_arrays] returns
#' descriptions of the specified arrays. Otherwise, it returns a
#' description of every array.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_raid_arrays
opsworks_describe_raid_arrays <- function(InstanceId = NULL, StackId = NULL, RaidArrayIds = NULL) {
  op <- new_operation(
    name = "DescribeRaidArrays",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_raid_arrays_input(InstanceId = InstanceId, StackId = StackId, RaidArrayIds = RaidArrayIds)
  output <- .opsworks$describe_raid_arrays_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_raid_arrays <- opsworks_describe_raid_arrays

#' Describes Amazon RDS instances
#'
#' @description
#' Describes Amazon RDS instances.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_rds_db_instances/](https://www.paws-r-sdk.com/docs/opsworks_describe_rds_db_instances/) for full documentation.
#'
#' @param StackId &#91;required&#93; The ID of the stack with which the instances are registered. The
#' operation returns descriptions of all registered Amazon RDS instances.
#' @param RdsDbInstanceArns An array containing the ARNs of the instances to be described.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_rds_db_instances
opsworks_describe_rds_db_instances <- function(StackId, RdsDbInstanceArns = NULL) {
  op <- new_operation(
    name = "DescribeRdsDbInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_rds_db_instances_input(StackId = StackId, RdsDbInstanceArns = RdsDbInstanceArns)
  output <- .opsworks$describe_rds_db_instances_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_rds_db_instances <- opsworks_describe_rds_db_instances

#' Describes AWS OpsWorks Stacks service errors
#'
#' @description
#' Describes AWS OpsWorks Stacks service errors.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_service_errors/](https://www.paws-r-sdk.com/docs/opsworks_describe_service_errors/) for full documentation.
#'
#' @param StackId The stack ID. If you use this parameter,
#' [`describe_service_errors`][opsworks_describe_service_errors] returns
#' descriptions of the errors associated with the specified stack.
#' @param InstanceId The instance ID. If you use this parameter,
#' [`describe_service_errors`][opsworks_describe_service_errors] returns
#' descriptions of the errors associated with the specified instance.
#' @param ServiceErrorIds An array of service error IDs. If you use this parameter,
#' [`describe_service_errors`][opsworks_describe_service_errors] returns
#' descriptions of the specified errors. Otherwise, it returns a
#' description of every error.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_service_errors
opsworks_describe_service_errors <- function(StackId = NULL, InstanceId = NULL, ServiceErrorIds = NULL) {
  op <- new_operation(
    name = "DescribeServiceErrors",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_service_errors_input(StackId = StackId, InstanceId = InstanceId, ServiceErrorIds = ServiceErrorIds)
  output <- .opsworks$describe_service_errors_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_service_errors <- opsworks_describe_service_errors

#' Requests a description of a stack's provisioning parameters
#'
#' @description
#' Requests a description of a stack's provisioning parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_stack_provisioning_parameters/](https://www.paws-r-sdk.com/docs/opsworks_describe_stack_provisioning_parameters/) for full documentation.
#'
#' @param StackId &#91;required&#93; The stack ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_stack_provisioning_parameters
opsworks_describe_stack_provisioning_parameters <- function(StackId) {
  op <- new_operation(
    name = "DescribeStackProvisioningParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_stack_provisioning_parameters_input(StackId = StackId)
  output <- .opsworks$describe_stack_provisioning_parameters_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_stack_provisioning_parameters <- opsworks_describe_stack_provisioning_parameters

#' Describes the number of layers and apps in a specified stack, and the
#' number of instances in each state, such as running_setup or online
#'
#' @description
#' Describes the number of layers and apps in a specified stack, and the number of instances in each state, such as `running_setup` or `online`.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_stack_summary/](https://www.paws-r-sdk.com/docs/opsworks_describe_stack_summary/) for full documentation.
#'
#' @param StackId &#91;required&#93; The stack ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_stack_summary
opsworks_describe_stack_summary <- function(StackId) {
  op <- new_operation(
    name = "DescribeStackSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_stack_summary_input(StackId = StackId)
  output <- .opsworks$describe_stack_summary_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_stack_summary <- opsworks_describe_stack_summary

#' Requests a description of one or more stacks
#'
#' @description
#' Requests a description of one or more stacks.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_stacks/](https://www.paws-r-sdk.com/docs/opsworks_describe_stacks/) for full documentation.
#'
#' @param StackIds An array of stack IDs that specify the stacks to be described. If you
#' omit this parameter, [`describe_stacks`][opsworks_describe_stacks]
#' returns a description of every stack.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_stacks
opsworks_describe_stacks <- function(StackIds = NULL) {
  op <- new_operation(
    name = "DescribeStacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_stacks_input(StackIds = StackIds)
  output <- .opsworks$describe_stacks_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_stacks <- opsworks_describe_stacks

#' Describes time-based auto scaling configurations for specified instances
#'
#' @description
#' Describes time-based auto scaling configurations for specified instances.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_time_based_auto_scaling/](https://www.paws-r-sdk.com/docs/opsworks_describe_time_based_auto_scaling/) for full documentation.
#'
#' @param InstanceIds &#91;required&#93; An array of instance IDs.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_time_based_auto_scaling
opsworks_describe_time_based_auto_scaling <- function(InstanceIds) {
  op <- new_operation(
    name = "DescribeTimeBasedAutoScaling",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_time_based_auto_scaling_input(InstanceIds = InstanceIds)
  output <- .opsworks$describe_time_based_auto_scaling_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_time_based_auto_scaling <- opsworks_describe_time_based_auto_scaling

#' Describe specified users
#'
#' @description
#' Describe specified users.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_user_profiles/](https://www.paws-r-sdk.com/docs/opsworks_describe_user_profiles/) for full documentation.
#'
#' @param IamUserArns An array of IAM or federated user ARNs that identify the users to be
#' described.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_user_profiles
opsworks_describe_user_profiles <- function(IamUserArns = NULL) {
  op <- new_operation(
    name = "DescribeUserProfiles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_user_profiles_input(IamUserArns = IamUserArns)
  output <- .opsworks$describe_user_profiles_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_user_profiles <- opsworks_describe_user_profiles

#' Describes an instance's Amazon EBS volumes
#'
#' @description
#' Describes an instance's Amazon EBS volumes.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_describe_volumes/](https://www.paws-r-sdk.com/docs/opsworks_describe_volumes/) for full documentation.
#'
#' @param InstanceId The instance ID. If you use this parameter,
#' [`describe_volumes`][opsworks_describe_volumes] returns descriptions of
#' the volumes associated with the specified instance.
#' @param StackId A stack ID. The action describes the stack's registered Amazon EBS
#' volumes.
#' @param RaidArrayId The RAID array ID. If you use this parameter,
#' [`describe_volumes`][opsworks_describe_volumes] returns descriptions of
#' the volumes associated with the specified RAID array.
#' @param VolumeIds Am array of volume IDs. If you use this parameter,
#' [`describe_volumes`][opsworks_describe_volumes] returns descriptions of
#' the specified volumes. Otherwise, it returns a description of every
#' volume.
#'
#' @keywords internal
#'
#' @rdname opsworks_describe_volumes
opsworks_describe_volumes <- function(InstanceId = NULL, StackId = NULL, RaidArrayId = NULL, VolumeIds = NULL) {
  op <- new_operation(
    name = "DescribeVolumes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$describe_volumes_input(InstanceId = InstanceId, StackId = StackId, RaidArrayId = RaidArrayId, VolumeIds = VolumeIds)
  output <- .opsworks$describe_volumes_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$describe_volumes <- opsworks_describe_volumes

#' Detaches a specified Elastic Load Balancing instance from its layer
#'
#' @description
#' Detaches a specified Elastic Load Balancing instance from its layer.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_detach_elastic_load_balancer/](https://www.paws-r-sdk.com/docs/opsworks_detach_elastic_load_balancer/) for full documentation.
#'
#' @param ElasticLoadBalancerName &#91;required&#93; The Elastic Load Balancing instance's name.
#' @param LayerId &#91;required&#93; The ID of the layer that the Elastic Load Balancing instance is attached
#' to.
#'
#' @keywords internal
#'
#' @rdname opsworks_detach_elastic_load_balancer
opsworks_detach_elastic_load_balancer <- function(ElasticLoadBalancerName, LayerId) {
  op <- new_operation(
    name = "DetachElasticLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$detach_elastic_load_balancer_input(ElasticLoadBalancerName = ElasticLoadBalancerName, LayerId = LayerId)
  output <- .opsworks$detach_elastic_load_balancer_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$detach_elastic_load_balancer <- opsworks_detach_elastic_load_balancer

#' Disassociates an Elastic IP address from its instance
#'
#' @description
#' Disassociates an Elastic IP address from its instance. The address remains registered with the stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_disassociate_elastic_ip/](https://www.paws-r-sdk.com/docs/opsworks_disassociate_elastic_ip/) for full documentation.
#'
#' @param ElasticIp &#91;required&#93; The Elastic IP address.
#'
#' @keywords internal
#'
#' @rdname opsworks_disassociate_elastic_ip
opsworks_disassociate_elastic_ip <- function(ElasticIp) {
  op <- new_operation(
    name = "DisassociateElasticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$disassociate_elastic_ip_input(ElasticIp = ElasticIp)
  output <- .opsworks$disassociate_elastic_ip_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$disassociate_elastic_ip <- opsworks_disassociate_elastic_ip

#' Gets a generated host name for the specified layer, based on the current
#' host name theme
#'
#' @description
#' Gets a generated host name for the specified layer, based on the current host name theme.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_get_hostname_suggestion/](https://www.paws-r-sdk.com/docs/opsworks_get_hostname_suggestion/) for full documentation.
#'
#' @param LayerId &#91;required&#93; The layer ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_get_hostname_suggestion
opsworks_get_hostname_suggestion <- function(LayerId) {
  op <- new_operation(
    name = "GetHostnameSuggestion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$get_hostname_suggestion_input(LayerId = LayerId)
  output <- .opsworks$get_hostname_suggestion_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$get_hostname_suggestion <- opsworks_get_hostname_suggestion

#' This action can be used only with Windows stacks
#'
#' @description
#' This action can be used only with Windows stacks.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_grant_access/](https://www.paws-r-sdk.com/docs/opsworks_grant_access/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The instance's AWS OpsWorks Stacks ID.
#' @param ValidForInMinutes The length of time (in minutes) that the grant is valid. When the grant
#' expires at the end of this period, the user will no longer be able to
#' use the credentials to log in. If the user is logged in at the time, he
#' or she automatically will be logged out.
#'
#' @keywords internal
#'
#' @rdname opsworks_grant_access
opsworks_grant_access <- function(InstanceId, ValidForInMinutes = NULL) {
  op <- new_operation(
    name = "GrantAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$grant_access_input(InstanceId = InstanceId, ValidForInMinutes = ValidForInMinutes)
  output <- .opsworks$grant_access_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$grant_access <- opsworks_grant_access

#' Returns a list of tags that are applied to the specified stack or layer
#'
#' @description
#' Returns a list of tags that are applied to the specified stack or layer.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_list_tags/](https://www.paws-r-sdk.com/docs/opsworks_list_tags/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The stack or layer's Amazon Resource Number (ARN).
#' @param MaxResults Do not use. A validation exception occurs if you add a `MaxResults`
#' parameter to a `ListTagsRequest` call.
#' @param NextToken Do not use. A validation exception occurs if you add a `NextToken`
#' parameter to a `ListTagsRequest` call.
#'
#' @keywords internal
#'
#' @rdname opsworks_list_tags
opsworks_list_tags <- function(ResourceArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$list_tags_input(ResourceArn = ResourceArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opsworks$list_tags_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$list_tags <- opsworks_list_tags

#' Reboots a specified instance
#'
#' @description
#' Reboots a specified instance. For more information, see [Starting, Stopping, and Rebooting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_reboot_instance/](https://www.paws-r-sdk.com/docs/opsworks_reboot_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The instance ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_reboot_instance
opsworks_reboot_instance <- function(InstanceId) {
  op <- new_operation(
    name = "RebootInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$reboot_instance_input(InstanceId = InstanceId)
  output <- .opsworks$reboot_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$reboot_instance <- opsworks_reboot_instance

#' Registers a specified Amazon ECS cluster with a stack
#'
#' @description
#' Registers a specified Amazon ECS cluster with a stack. You can register only one cluster with a stack. A cluster can be registered with only one stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_register_ecs_cluster/](https://www.paws-r-sdk.com/docs/opsworks_register_ecs_cluster/) for full documentation.
#'
#' @param EcsClusterArn &#91;required&#93; The cluster's ARN.
#' @param StackId &#91;required&#93; The stack ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_register_ecs_cluster
opsworks_register_ecs_cluster <- function(EcsClusterArn, StackId) {
  op <- new_operation(
    name = "RegisterEcsCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$register_ecs_cluster_input(EcsClusterArn = EcsClusterArn, StackId = StackId)
  output <- .opsworks$register_ecs_cluster_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$register_ecs_cluster <- opsworks_register_ecs_cluster

#' Registers an Elastic IP address with a specified stack
#'
#' @description
#' Registers an Elastic IP address with a specified stack. An address can be registered with only one stack at a time. If the address is already registered, you must first deregister it by calling [`deregister_elastic_ip`][opsworks_deregister_elastic_ip]. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_register_elastic_ip/](https://www.paws-r-sdk.com/docs/opsworks_register_elastic_ip/) for full documentation.
#'
#' @param ElasticIp &#91;required&#93; The Elastic IP address.
#' @param StackId &#91;required&#93; The stack ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_register_elastic_ip
opsworks_register_elastic_ip <- function(ElasticIp, StackId) {
  op <- new_operation(
    name = "RegisterElasticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$register_elastic_ip_input(ElasticIp = ElasticIp, StackId = StackId)
  output <- .opsworks$register_elastic_ip_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$register_elastic_ip <- opsworks_register_elastic_ip

#' Registers instances that were created outside of AWS OpsWorks Stacks
#' with a specified stack
#'
#' @description
#' Registers instances that were created outside of AWS OpsWorks Stacks with a specified stack.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_register_instance/](https://www.paws-r-sdk.com/docs/opsworks_register_instance/) for full documentation.
#'
#' @param StackId &#91;required&#93; The ID of the stack that the instance is to be registered with.
#' @param Hostname The instance's hostname.
#' @param PublicIp The instance's public IP address.
#' @param PrivateIp The instance's private IP address.
#' @param RsaPublicKey The instances public RSA key. This key is used to encrypt communication
#' between the instance and the service.
#' @param RsaPublicKeyFingerprint The instances public RSA key fingerprint.
#' @param InstanceIdentity An InstanceIdentity object that contains the instance's identity.
#'
#' @keywords internal
#'
#' @rdname opsworks_register_instance
opsworks_register_instance <- function(StackId, Hostname = NULL, PublicIp = NULL, PrivateIp = NULL, RsaPublicKey = NULL, RsaPublicKeyFingerprint = NULL, InstanceIdentity = NULL) {
  op <- new_operation(
    name = "RegisterInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$register_instance_input(StackId = StackId, Hostname = Hostname, PublicIp = PublicIp, PrivateIp = PrivateIp, RsaPublicKey = RsaPublicKey, RsaPublicKeyFingerprint = RsaPublicKeyFingerprint, InstanceIdentity = InstanceIdentity)
  output <- .opsworks$register_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$register_instance <- opsworks_register_instance

#' Registers an Amazon RDS instance with a stack
#'
#' @description
#' Registers an Amazon RDS instance with a stack.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_register_rds_db_instance/](https://www.paws-r-sdk.com/docs/opsworks_register_rds_db_instance/) for full documentation.
#'
#' @param StackId &#91;required&#93; The stack ID.
#' @param RdsDbInstanceArn &#91;required&#93; The Amazon RDS instance's ARN.
#' @param DbUser &#91;required&#93; The database's master user name.
#' @param DbPassword &#91;required&#93; The database password.
#'
#' @keywords internal
#'
#' @rdname opsworks_register_rds_db_instance
opsworks_register_rds_db_instance <- function(StackId, RdsDbInstanceArn, DbUser, DbPassword) {
  op <- new_operation(
    name = "RegisterRdsDbInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$register_rds_db_instance_input(StackId = StackId, RdsDbInstanceArn = RdsDbInstanceArn, DbUser = DbUser, DbPassword = DbPassword)
  output <- .opsworks$register_rds_db_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$register_rds_db_instance <- opsworks_register_rds_db_instance

#' Registers an Amazon EBS volume with a specified stack
#'
#' @description
#' Registers an Amazon EBS volume with a specified stack. A volume can be registered with only one stack at a time. If the volume is already registered, you must first deregister it by calling [`deregister_volume`][opsworks_deregister_volume]. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_register_volume/](https://www.paws-r-sdk.com/docs/opsworks_register_volume/) for full documentation.
#'
#' @param Ec2VolumeId The Amazon EBS volume ID.
#' @param StackId &#91;required&#93; The stack ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_register_volume
opsworks_register_volume <- function(Ec2VolumeId = NULL, StackId) {
  op <- new_operation(
    name = "RegisterVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$register_volume_input(Ec2VolumeId = Ec2VolumeId, StackId = StackId)
  output <- .opsworks$register_volume_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$register_volume <- opsworks_register_volume

#' Specify the load-based auto scaling configuration for a specified layer
#'
#' @description
#' Specify the load-based auto scaling configuration for a specified layer. For more information, see [Managing Load with Time-based and Load-based Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_set_load_based_auto_scaling/](https://www.paws-r-sdk.com/docs/opsworks_set_load_based_auto_scaling/) for full documentation.
#'
#' @param LayerId &#91;required&#93; The layer ID.
#' @param Enable Enables load-based auto scaling for the layer.
#' @param UpScaling An `AutoScalingThresholds` object with the upscaling threshold
#' configuration. If the load exceeds these thresholds for a specified
#' amount of time, AWS OpsWorks Stacks starts a specified number of
#' instances.
#' @param DownScaling An `AutoScalingThresholds` object with the downscaling threshold
#' configuration. If the load falls below these thresholds for a specified
#' amount of time, AWS OpsWorks Stacks stops a specified number of
#' instances.
#'
#' @keywords internal
#'
#' @rdname opsworks_set_load_based_auto_scaling
opsworks_set_load_based_auto_scaling <- function(LayerId, Enable = NULL, UpScaling = NULL, DownScaling = NULL) {
  op <- new_operation(
    name = "SetLoadBasedAutoScaling",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$set_load_based_auto_scaling_input(LayerId = LayerId, Enable = Enable, UpScaling = UpScaling, DownScaling = DownScaling)
  output <- .opsworks$set_load_based_auto_scaling_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$set_load_based_auto_scaling <- opsworks_set_load_based_auto_scaling

#' Specifies a user's permissions
#'
#' @description
#' Specifies a user's permissions. For more information, see [Security and Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/workingsecurity.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_set_permission/](https://www.paws-r-sdk.com/docs/opsworks_set_permission/) for full documentation.
#'
#' @param StackId &#91;required&#93; The stack ID.
#' @param IamUserArn &#91;required&#93; The user's IAM ARN. This can also be a federated user's ARN.
#' @param AllowSsh The user is allowed to use SSH to communicate with the instance.
#' @param AllowSudo The user is allowed to use **sudo** to elevate privileges.
#' @param Level The user's permission level, which must be set to one of the following
#' strings. You cannot set your own permissions level.
#' 
#' -   `deny`
#' 
#' -   `show`
#' 
#' -   `deploy`
#' 
#' -   `manage`
#' 
#' -   `iam_only`
#' 
#' For more information about the permissions associated with these levels,
#' see [Managing User
#' Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
#'
#' @keywords internal
#'
#' @rdname opsworks_set_permission
opsworks_set_permission <- function(StackId, IamUserArn, AllowSsh = NULL, AllowSudo = NULL, Level = NULL) {
  op <- new_operation(
    name = "SetPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$set_permission_input(StackId = StackId, IamUserArn = IamUserArn, AllowSsh = AllowSsh, AllowSudo = AllowSudo, Level = Level)
  output <- .opsworks$set_permission_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$set_permission <- opsworks_set_permission

#' Specify the time-based auto scaling configuration for a specified
#' instance
#'
#' @description
#' Specify the time-based auto scaling configuration for a specified instance. For more information, see [Managing Load with Time-based and Load-based Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_set_time_based_auto_scaling/](https://www.paws-r-sdk.com/docs/opsworks_set_time_based_auto_scaling/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The instance ID.
#' @param AutoScalingSchedule An `AutoScalingSchedule` with the instance schedule.
#'
#' @keywords internal
#'
#' @rdname opsworks_set_time_based_auto_scaling
opsworks_set_time_based_auto_scaling <- function(InstanceId, AutoScalingSchedule = NULL) {
  op <- new_operation(
    name = "SetTimeBasedAutoScaling",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$set_time_based_auto_scaling_input(InstanceId = InstanceId, AutoScalingSchedule = AutoScalingSchedule)
  output <- .opsworks$set_time_based_auto_scaling_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$set_time_based_auto_scaling <- opsworks_set_time_based_auto_scaling

#' Starts a specified instance
#'
#' @description
#' Starts a specified instance. For more information, see [Starting, Stopping, and Rebooting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_start_instance/](https://www.paws-r-sdk.com/docs/opsworks_start_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The instance ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_start_instance
opsworks_start_instance <- function(InstanceId) {
  op <- new_operation(
    name = "StartInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$start_instance_input(InstanceId = InstanceId)
  output <- .opsworks$start_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$start_instance <- opsworks_start_instance

#' Starts a stack's instances
#'
#' @description
#' Starts a stack's instances.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_start_stack/](https://www.paws-r-sdk.com/docs/opsworks_start_stack/) for full documentation.
#'
#' @param StackId &#91;required&#93; The stack ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_start_stack
opsworks_start_stack <- function(StackId) {
  op <- new_operation(
    name = "StartStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$start_stack_input(StackId = StackId)
  output <- .opsworks$start_stack_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$start_stack <- opsworks_start_stack

#' Stops a specified instance
#'
#' @description
#' Stops a specified instance. When you stop a standard instance, the data disappears and must be reinstalled when you restart the instance. You can stop an Amazon EBS-backed instance without losing data. For more information, see [Starting, Stopping, and Rebooting Instances](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_stop_instance/](https://www.paws-r-sdk.com/docs/opsworks_stop_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The instance ID.
#' @param Force Specifies whether to force an instance to stop. If the instance's root
#' device type is `ebs`, or EBS-backed, adding the `Force` parameter to the
#' `StopInstances` API call disassociates the AWS OpsWorks Stacks instance
#' from EC2, and forces deletion of *only* the OpsWorks Stacks instance.
#' You must also delete the formerly-associated instance in EC2 after
#' troubleshooting and replacing the AWS OpsWorks Stacks instance with a
#' new one.
#'
#' @keywords internal
#'
#' @rdname opsworks_stop_instance
opsworks_stop_instance <- function(InstanceId, Force = NULL) {
  op <- new_operation(
    name = "StopInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$stop_instance_input(InstanceId = InstanceId, Force = Force)
  output <- .opsworks$stop_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$stop_instance <- opsworks_stop_instance

#' Stops a specified stack
#'
#' @description
#' Stops a specified stack.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_stop_stack/](https://www.paws-r-sdk.com/docs/opsworks_stop_stack/) for full documentation.
#'
#' @param StackId &#91;required&#93; The stack ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_stop_stack
opsworks_stop_stack <- function(StackId) {
  op <- new_operation(
    name = "StopStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$stop_stack_input(StackId = StackId)
  output <- .opsworks$stop_stack_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$stop_stack <- opsworks_stop_stack

#' Apply cost-allocation tags to a specified stack or layer in AWS OpsWorks
#' Stacks
#'
#' @description
#' Apply cost-allocation tags to a specified stack or layer in AWS OpsWorks Stacks. For more information about how tagging works, see [Tags](https://docs.aws.amazon.com/opsworks/latest/userguide/tagging.html) in the AWS OpsWorks User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_tag_resource/](https://www.paws-r-sdk.com/docs/opsworks_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The stack or layer's Amazon Resource Number (ARN).
#' @param Tags &#91;required&#93; A map that contains tag keys and tag values that are attached to a stack
#' or layer.
#' 
#' -   The key cannot be empty.
#' 
#' -   The key can be a maximum of 127 characters, and can contain only
#'     Unicode letters, numbers, or separators, or the following special
#'     characters: `+ - = . _ : /`
#' 
#' -   The value can be a maximum 255 characters, and contain only Unicode
#'     letters, numbers, or separators, or the following special
#'     characters: `+ - = . _ : /`
#' 
#' -   Leading and trailing white spaces are trimmed from both the key and
#'     value.
#' 
#' -   A maximum of 40 tags is allowed for any resource.
#'
#' @keywords internal
#'
#' @rdname opsworks_tag_resource
opsworks_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .opsworks$tag_resource_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$tag_resource <- opsworks_tag_resource

#' Unassigns a registered instance from all layers that are using the
#' instance
#'
#' @description
#' Unassigns a registered instance from all layers that are using the instance. The instance remains in the stack as an unassigned instance, and can be assigned to another layer as needed. You cannot use this action with instances that were created with AWS OpsWorks Stacks.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_unassign_instance/](https://www.paws-r-sdk.com/docs/opsworks_unassign_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The instance ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_unassign_instance
opsworks_unassign_instance <- function(InstanceId) {
  op <- new_operation(
    name = "UnassignInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$unassign_instance_input(InstanceId = InstanceId)
  output <- .opsworks$unassign_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$unassign_instance <- opsworks_unassign_instance

#' Unassigns an assigned Amazon EBS volume
#'
#' @description
#' Unassigns an assigned Amazon EBS volume. The volume remains registered with the stack. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_unassign_volume/](https://www.paws-r-sdk.com/docs/opsworks_unassign_volume/) for full documentation.
#'
#' @param VolumeId &#91;required&#93; The volume ID.
#'
#' @keywords internal
#'
#' @rdname opsworks_unassign_volume
opsworks_unassign_volume <- function(VolumeId) {
  op <- new_operation(
    name = "UnassignVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$unassign_volume_input(VolumeId = VolumeId)
  output <- .opsworks$unassign_volume_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$unassign_volume <- opsworks_unassign_volume

#' Removes tags from a specified stack or layer
#'
#' @description
#' Removes tags from a specified stack or layer.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_untag_resource/](https://www.paws-r-sdk.com/docs/opsworks_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The stack or layer's Amazon Resource Number (ARN).
#' @param TagKeys &#91;required&#93; A list of the keys of tags to be removed from a stack or layer.
#'
#' @keywords internal
#'
#' @rdname opsworks_untag_resource
opsworks_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .opsworks$untag_resource_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$untag_resource <- opsworks_untag_resource

#' Updates a specified app
#'
#' @description
#' Updates a specified app.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_update_app/](https://www.paws-r-sdk.com/docs/opsworks_update_app/) for full documentation.
#'
#' @param AppId &#91;required&#93; The app ID.
#' @param Name The app name.
#' @param Description A description of the app.
#' @param DataSources The app's data sources.
#' @param Type The app type.
#' @param AppSource A `Source` object that specifies the app repository.
#' @param Domains The app's virtual host settings, with multiple domains separated by
#' commas. For example: `'www.example.com, example.com'`
#' @param EnableSsl Whether SSL is enabled for the app.
#' @param SslConfiguration An `SslConfiguration` object with the SSL configuration.
#' @param Attributes One or more user-defined key/value pairs to be added to the stack
#' attributes.
#' @param Environment An array of `EnvironmentVariable` objects that specify environment
#' variables to be associated with the app. After you deploy the app, these
#' variables are defined on the associated app server instances.For more
#' information, see [Environment
#' Variables](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment).
#' 
#' There is no specific limit on the number of environment variables.
#' However, the size of the associated data structure - which includes the
#' variables' names, values, and protected flag values - cannot exceed 20
#' KB. This limit should accommodate most if not all use cases. Exceeding
#' it will cause an exception with the message, "Environment: is too large
#' (maximum is 20 KB)."
#' 
#' If you have specified one or more environment variables, you cannot
#' modify the stack's Chef version.
#'
#' @keywords internal
#'
#' @rdname opsworks_update_app
opsworks_update_app <- function(AppId, Name = NULL, Description = NULL, DataSources = NULL, Type = NULL, AppSource = NULL, Domains = NULL, EnableSsl = NULL, SslConfiguration = NULL, Attributes = NULL, Environment = NULL) {
  op <- new_operation(
    name = "UpdateApp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$update_app_input(AppId = AppId, Name = Name, Description = Description, DataSources = DataSources, Type = Type, AppSource = AppSource, Domains = Domains, EnableSsl = EnableSsl, SslConfiguration = SslConfiguration, Attributes = Attributes, Environment = Environment)
  output <- .opsworks$update_app_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$update_app <- opsworks_update_app

#' Updates a registered Elastic IP address's name
#'
#' @description
#' Updates a registered Elastic IP address's name. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_update_elastic_ip/](https://www.paws-r-sdk.com/docs/opsworks_update_elastic_ip/) for full documentation.
#'
#' @param ElasticIp &#91;required&#93; The IP address for which you want to update the name.
#' @param Name The new name.
#'
#' @keywords internal
#'
#' @rdname opsworks_update_elastic_ip
opsworks_update_elastic_ip <- function(ElasticIp, Name = NULL) {
  op <- new_operation(
    name = "UpdateElasticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$update_elastic_ip_input(ElasticIp = ElasticIp, Name = Name)
  output <- .opsworks$update_elastic_ip_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$update_elastic_ip <- opsworks_update_elastic_ip

#' Updates a specified instance
#'
#' @description
#' Updates a specified instance.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_update_instance/](https://www.paws-r-sdk.com/docs/opsworks_update_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The instance ID.
#' @param LayerIds The instance's layer IDs.
#' @param InstanceType The instance type, such as `t2.micro`. For a list of supported instance
#' types, open the stack in the console, choose **Instances**, and choose
#' **+ Instance**. The **Size** list contains the currently supported
#' types. For more information, see [Instance Families and
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
#' The parameter values that you use to specify the various types are in
#' the **API Name** column of the **Available Instance Types** table.
#' @param AutoScalingType For load-based or time-based instances, the type. Windows stacks can use
#' only time-based instances.
#' @param Hostname The instance host name.
#' @param Os The instance's operating system, which must be set to one of the
#' following. You cannot update an instance that is using a custom AMI.
#' 
#' -   A supported Linux operating system: An Amazon Linux version, such as
#'     `Amazon Linux 2018.03`, `Amazon Linux 2017.09`,
#'     `Amazon Linux 2017.03`, `Amazon Linux 2016.09`,
#'     `Amazon Linux 2016.03`, `Amazon Linux 2015.09`, or
#'     `Amazon Linux 2015.03`.
#' 
#' -   A supported Ubuntu operating system, such as `Ubuntu 16.04 LTS`,
#'     `Ubuntu 14.04 LTS`, or `Ubuntu 12.04 LTS`.
#' 
#' -   `CentOS Linux 7`
#' 
#' -   `Red Hat Enterprise Linux 7`
#' 
#' -   A supported Windows operating system, such as
#'     `Microsoft Windows Server 2012 R2 Base`,
#'     `Microsoft Windows Server 2012 R2 with SQL Server Express`,
#'     `Microsoft Windows Server 2012 R2 with SQL Server Standard`, or
#'     `Microsoft Windows Server 2012 R2 with SQL Server Web`.
#' 
#' For more information about supported operating systems, see [AWS
#' OpsWorks Stacks Operating
#' Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
#' 
#' The default option is the current Amazon Linux version. If you set this
#' parameter to `Custom`, you must use the AmiId parameter to specify the
#' custom AMI that you want to use. For more information about supported
#' operating systems, see [Operating
#' Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
#' For more information about how to use custom AMIs with OpsWorks, see
#' [Using Custom
#' AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
#' 
#' You can specify a different Linux operating system for the updated
#' stack, but you cannot change from Linux to Windows or Windows to Linux.
#' @param AmiId The ID of the AMI that was used to create the instance. The value of
#' this parameter must be the same AMI ID that the instance is already
#' using. You cannot apply a new AMI to an instance by running
#' UpdateInstance. UpdateInstance does not work on instances that are using
#' custom AMIs.
#' @param SshKeyName The instance's Amazon EC2 key name.
#' @param Architecture The instance architecture. Instance types do not necessarily support
#' both architectures. For a list of the architectures that are supported
#' by the different instance types, see [Instance Families and
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
#' @param InstallUpdatesOnBoot Whether to install operating system and package updates when the
#' instance boots. The default value is `true`. To control when updates are
#' installed, set this value to `false`. You must then update your
#' instances manually by using
#' [`create_deployment`][opsworks_create_deployment] to run the
#' `update_dependencies` stack command or by manually running `yum` (Amazon
#' Linux) or `apt-get` (Ubuntu) on the instances.
#' 
#' We strongly recommend using the default value of `true`, to ensure that
#' your instances have the latest security updates.
#' @param EbsOptimized This property cannot be updated.
#' @param AgentVersion The default AWS OpsWorks Stacks agent version. You have the following
#' options:
#' 
#' -   `INHERIT` - Use the stack's default agent version setting.
#' 
#' -   *version_number* - Use the specified agent version. This value
#'     overrides the stack's default setting. To update the agent version,
#'     you must edit the instance configuration and specify a new version.
#'     AWS OpsWorks Stacks then automatically installs that version on the
#'     instance.
#' 
#' The default setting is `INHERIT`. To specify an agent version, you must
#' use the complete version number, not the abbreviated number shown on the
#' console. For a list of available agent version numbers, call
#' [`describe_agent_versions`][opsworks_describe_agent_versions].
#' 
#' AgentVersion cannot be set to Chef 12.2.
#'
#' @keywords internal
#'
#' @rdname opsworks_update_instance
opsworks_update_instance <- function(InstanceId, LayerIds = NULL, InstanceType = NULL, AutoScalingType = NULL, Hostname = NULL, Os = NULL, AmiId = NULL, SshKeyName = NULL, Architecture = NULL, InstallUpdatesOnBoot = NULL, EbsOptimized = NULL, AgentVersion = NULL) {
  op <- new_operation(
    name = "UpdateInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$update_instance_input(InstanceId = InstanceId, LayerIds = LayerIds, InstanceType = InstanceType, AutoScalingType = AutoScalingType, Hostname = Hostname, Os = Os, AmiId = AmiId, SshKeyName = SshKeyName, Architecture = Architecture, InstallUpdatesOnBoot = InstallUpdatesOnBoot, EbsOptimized = EbsOptimized, AgentVersion = AgentVersion)
  output <- .opsworks$update_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$update_instance <- opsworks_update_instance

#' Updates a specified layer
#'
#' @description
#' Updates a specified layer.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_update_layer/](https://www.paws-r-sdk.com/docs/opsworks_update_layer/) for full documentation.
#'
#' @param LayerId &#91;required&#93; The layer ID.
#' @param Name The layer name, which is used by the console.
#' @param Shortname For custom layers only, use this parameter to specify the layer's short
#' name, which is used internally by AWS OpsWorks Stacks and by Chef. The
#' short name is also used as the name for the directory where your app
#' files are installed. It can have a maximum of 200 characters and must be
#' in the following format: /\\A\[a-z0-9\\-_\\.\]+\\Z/.
#' 
#' The built-in layers' short names are defined by AWS OpsWorks Stacks. For
#' more information, see the [Layer
#' Reference](https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html)
#' @param Attributes One or more user-defined key/value pairs to be added to the stack
#' attributes.
#' @param CloudWatchLogsConfiguration Specifies CloudWatch Logs configuration options for the layer. For more
#' information, see CloudWatchLogsLogStream.
#' @param CustomInstanceProfileArn The ARN of an IAM profile to be used for all of the layer's EC2
#' instances. For more information about IAM ARNs, see [Using
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html).
#' @param CustomJson A JSON-formatted string containing custom stack configuration and
#' deployment attributes to be installed on the layer's instances. For more
#' information, see [Using Custom
#' JSON](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html).
#' @param CustomSecurityGroupIds An array containing the layer's custom security group IDs.
#' @param Packages An array of `Package` objects that describe the layer's packages.
#' @param VolumeConfigurations A `VolumeConfigurations` object that describes the layer's Amazon EBS
#' volumes.
#' @param EnableAutoHealing Whether to disable auto healing for the layer.
#' @param AutoAssignElasticIps Whether to automatically assign an [Elastic IP
#' address](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#' to the layer's instances. For more information, see [How to Edit a
#' Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
#' @param AutoAssignPublicIps For stacks that are running in a VPC, whether to automatically assign a
#' public IP address to the layer's instances. For more information, see
#' [How to Edit a
#' Layer](https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
#' @param CustomRecipes A `LayerCustomRecipes` object that specifies the layer's custom recipes.
#' @param InstallUpdatesOnBoot Whether to install operating system and package updates when the
#' instance boots. The default value is `true`. To control when updates are
#' installed, set this value to `false`. You must then update your
#' instances manually by using
#' [`create_deployment`][opsworks_create_deployment] to run the
#' `update_dependencies` stack command or manually running `yum` (Amazon
#' Linux) or `apt-get` (Ubuntu) on the instances.
#' 
#' We strongly recommend using the default value of `true`, to ensure that
#' your instances have the latest security updates.
#' @param UseEbsOptimizedInstances Whether to use Amazon EBS-optimized instances.
#' @param LifecycleEventConfiguration 
#'
#' @keywords internal
#'
#' @rdname opsworks_update_layer
opsworks_update_layer <- function(LayerId, Name = NULL, Shortname = NULL, Attributes = NULL, CloudWatchLogsConfiguration = NULL, CustomInstanceProfileArn = NULL, CustomJson = NULL, CustomSecurityGroupIds = NULL, Packages = NULL, VolumeConfigurations = NULL, EnableAutoHealing = NULL, AutoAssignElasticIps = NULL, AutoAssignPublicIps = NULL, CustomRecipes = NULL, InstallUpdatesOnBoot = NULL, UseEbsOptimizedInstances = NULL, LifecycleEventConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateLayer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$update_layer_input(LayerId = LayerId, Name = Name, Shortname = Shortname, Attributes = Attributes, CloudWatchLogsConfiguration = CloudWatchLogsConfiguration, CustomInstanceProfileArn = CustomInstanceProfileArn, CustomJson = CustomJson, CustomSecurityGroupIds = CustomSecurityGroupIds, Packages = Packages, VolumeConfigurations = VolumeConfigurations, EnableAutoHealing = EnableAutoHealing, AutoAssignElasticIps = AutoAssignElasticIps, AutoAssignPublicIps = AutoAssignPublicIps, CustomRecipes = CustomRecipes, InstallUpdatesOnBoot = InstallUpdatesOnBoot, UseEbsOptimizedInstances = UseEbsOptimizedInstances, LifecycleEventConfiguration = LifecycleEventConfiguration)
  output <- .opsworks$update_layer_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$update_layer <- opsworks_update_layer

#' Updates a user's SSH public key
#'
#' @description
#' Updates a user's SSH public key.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_update_my_user_profile/](https://www.paws-r-sdk.com/docs/opsworks_update_my_user_profile/) for full documentation.
#'
#' @param SshPublicKey The user's SSH public key.
#'
#' @keywords internal
#'
#' @rdname opsworks_update_my_user_profile
opsworks_update_my_user_profile <- function(SshPublicKey = NULL) {
  op <- new_operation(
    name = "UpdateMyUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$update_my_user_profile_input(SshPublicKey = SshPublicKey)
  output <- .opsworks$update_my_user_profile_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$update_my_user_profile <- opsworks_update_my_user_profile

#' Updates an Amazon RDS instance
#'
#' @description
#' Updates an Amazon RDS instance.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_update_rds_db_instance/](https://www.paws-r-sdk.com/docs/opsworks_update_rds_db_instance/) for full documentation.
#'
#' @param RdsDbInstanceArn &#91;required&#93; The Amazon RDS instance's ARN.
#' @param DbUser The master user name.
#' @param DbPassword The database password.
#'
#' @keywords internal
#'
#' @rdname opsworks_update_rds_db_instance
opsworks_update_rds_db_instance <- function(RdsDbInstanceArn, DbUser = NULL, DbPassword = NULL) {
  op <- new_operation(
    name = "UpdateRdsDbInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$update_rds_db_instance_input(RdsDbInstanceArn = RdsDbInstanceArn, DbUser = DbUser, DbPassword = DbPassword)
  output <- .opsworks$update_rds_db_instance_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$update_rds_db_instance <- opsworks_update_rds_db_instance

#' Updates a specified stack
#'
#' @description
#' Updates a specified stack.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_update_stack/](https://www.paws-r-sdk.com/docs/opsworks_update_stack/) for full documentation.
#'
#' @param StackId &#91;required&#93; The stack ID.
#' @param Name The stack's new name.
#' @param Attributes One or more user-defined key-value pairs to be added to the stack
#' attributes.
#' @param ServiceRoleArn Do not use this parameter. You cannot update a stack's service role.
#' @param DefaultInstanceProfileArn The ARN of an IAM profile that is the default profile for all of the
#' stack's EC2 instances. For more information about IAM ARNs, see [Using
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html).
#' @param DefaultOs The stack's operating system, which must be set to one of the following:
#' 
#' -   A supported Linux operating system: An Amazon Linux version, such as
#'     `Amazon Linux 2018.03`, `Amazon Linux 2017.09`,
#'     `Amazon Linux 2017.03`, `Amazon Linux 2016.09`,
#'     `Amazon Linux 2016.03`, `Amazon Linux 2015.09`, or
#'     `Amazon Linux 2015.03`.
#' 
#' -   A supported Ubuntu operating system, such as `Ubuntu 16.04 LTS`,
#'     `Ubuntu 14.04 LTS`, or `Ubuntu 12.04 LTS`.
#' 
#' -   `CentOS Linux 7`
#' 
#' -   `Red Hat Enterprise Linux 7`
#' 
#' -   A supported Windows operating system, such as
#'     `Microsoft Windows Server 2012 R2 Base`,
#'     `Microsoft Windows Server 2012 R2 with SQL Server Express`,
#'     `Microsoft Windows Server 2012 R2 with SQL Server Standard`, or
#'     `Microsoft Windows Server 2012 R2 with SQL Server Web`.
#' 
#' -   A custom AMI: `Custom`. You specify the custom AMI you want to use
#'     when you create instances. For more information about how to use
#'     custom AMIs with OpsWorks, see [Using Custom
#'     AMIs](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
#' 
#' The default option is the stack's current operating system. For more
#' information about supported operating systems, see [AWS OpsWorks Stacks
#' Operating
#' Systems](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
#' @param HostnameTheme The stack's new host name theme, with spaces replaced by underscores.
#' The theme is used to generate host names for the stack's instances. By
#' default, `HostnameTheme` is set to `Layer_Dependent`, which creates host
#' names by appending integers to the layer's short name. The other themes
#' are:
#' 
#' -   `Baked_Goods`
#' 
#' -   `Clouds`
#' 
#' -   `Europe_Cities`
#' 
#' -   `Fruits`
#' 
#' -   `Greek_Deities_and_Titans`
#' 
#' -   `Legendary_creatures_from_Japan`
#' 
#' -   `Planets_and_Moons`
#' 
#' -   `Roman_Deities`
#' 
#' -   `Scottish_Islands`
#' 
#' -   `US_Cities`
#' 
#' -   `Wild_Cats`
#' 
#' To obtain a generated host name, call `GetHostNameSuggestion`, which
#' returns a host name based on the current theme.
#' @param DefaultAvailabilityZone The stack's default Availability Zone, which must be in the stack's
#' region. For more information, see [Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html). If
#' you also specify a value for `DefaultSubnetId`, the subnet must be in
#' the same zone. For more information, see
#' [`create_stack`][opsworks_create_stack].
#' @param DefaultSubnetId The stack's default VPC subnet ID. This parameter is required if you
#' specify a value for the `VpcId` parameter. All instances are launched
#' into this subnet unless you specify otherwise when you create the
#' instance. If you also specify a value for `DefaultAvailabilityZone`, the
#' subnet must be in that zone. For information on default values and when
#' this parameter is required, see the `VpcId` parameter description.
#' @param CustomJson A string that contains user-defined, custom JSON. It can be used to
#' override the corresponding default stack configuration JSON values or to
#' pass data to recipes. The string should be in the following format:
#' 
#' `"{\"key1\": \"value1\", \"key2\": \"value2\",...}"`
#' 
#' For more information about custom JSON, see [Use Custom JSON to Modify
#' the Stack Configuration
#' Attributes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
#' @param ConfigurationManager The configuration manager. When you update a stack, we recommend that
#' you use the configuration manager to specify the Chef version: 12,
#' 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default
#' value for Linux stacks is currently 12.
#' @param ChefConfiguration A `ChefConfiguration` object that specifies whether to enable Berkshelf
#' and the Berkshelf version on Chef 11.10 stacks. For more information,
#' see [Create a New
#' Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
#' @param UseCustomCookbooks Whether the stack uses custom cookbooks.
#' @param CustomCookbooksSource Contains the information required to retrieve an app or cookbook from a
#' repository. For more information, see [Adding
#' Apps](https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
#' or [Cookbooks and
#' Recipes](https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
#' @param DefaultSshKeyName A default Amazon EC2 key-pair name. The default value is `none`. If you
#' specify a key-pair name, AWS OpsWorks Stacks installs the public key on
#' the instance and you can use the private key with an SSH client to log
#' in to the instance. For more information, see [Using SSH to Communicate
#' with an
#' Instance](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html)
#' and [Managing SSH
#' Access](https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html).
#' You can override this setting by specifying a different key pair, or no
#' key pair, when you [create an
#' instance](https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
#' @param DefaultRootDeviceType The default root device type. This value is used by default for all
#' instances in the stack, but you can override it when you create an
#' instance. For more information, see [Storage for the Root
#' Device](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
#' @param UseOpsworksSecurityGroups Whether to associate the AWS OpsWorks Stacks built-in security groups
#' with the stack's layers.
#' 
#' AWS OpsWorks Stacks provides a standard set of built-in security groups,
#' one for each layer, which are associated with layers by default.
#' `UseOpsworksSecurityGroups` allows you to provide your own custom
#' security groups instead of using the built-in groups.
#' `UseOpsworksSecurityGroups` has the following settings:
#' 
#' -   True - AWS OpsWorks Stacks automatically associates the appropriate
#'     built-in security group with each layer (default setting). You can
#'     associate additional security groups with a layer after you create
#'     it, but you cannot delete the built-in security group.
#' 
#' -   False - AWS OpsWorks Stacks does not associate built-in security
#'     groups with layers. You must create appropriate EC2 security groups
#'     and associate a security group with each layer that you create.
#'     However, you can still manually associate a built-in security group
#'     with a layer on. Custom security groups are required only for those
#'     layers that need custom settings.
#' 
#' For more information, see [Create a New
#' Stack](https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
#' @param AgentVersion The default AWS OpsWorks Stacks agent version. You have the following
#' options:
#' 
#' -   Auto-update - Set this parameter to `LATEST`. AWS OpsWorks Stacks
#'     automatically installs new agent versions on the stack's instances
#'     as soon as they are available.
#' 
#' -   Fixed version - Set this parameter to your preferred agent version.
#'     To update the agent version, you must edit the stack configuration
#'     and specify a new version. AWS OpsWorks Stacks then automatically
#'     installs that version on the stack's instances.
#' 
#' The default setting is `LATEST`. To specify an agent version, you must
#' use the complete version number, not the abbreviated number shown on the
#' console. For a list of available agent version numbers, call
#' [`describe_agent_versions`][opsworks_describe_agent_versions].
#' AgentVersion cannot be set to Chef 12.2.
#' 
#' You can also specify an agent version when you create or update an
#' instance, which overrides the stack's default setting.
#'
#' @keywords internal
#'
#' @rdname opsworks_update_stack
opsworks_update_stack <- function(StackId, Name = NULL, Attributes = NULL, ServiceRoleArn = NULL, DefaultInstanceProfileArn = NULL, DefaultOs = NULL, HostnameTheme = NULL, DefaultAvailabilityZone = NULL, DefaultSubnetId = NULL, CustomJson = NULL, ConfigurationManager = NULL, ChefConfiguration = NULL, UseCustomCookbooks = NULL, CustomCookbooksSource = NULL, DefaultSshKeyName = NULL, DefaultRootDeviceType = NULL, UseOpsworksSecurityGroups = NULL, AgentVersion = NULL) {
  op <- new_operation(
    name = "UpdateStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$update_stack_input(StackId = StackId, Name = Name, Attributes = Attributes, ServiceRoleArn = ServiceRoleArn, DefaultInstanceProfileArn = DefaultInstanceProfileArn, DefaultOs = DefaultOs, HostnameTheme = HostnameTheme, DefaultAvailabilityZone = DefaultAvailabilityZone, DefaultSubnetId = DefaultSubnetId, CustomJson = CustomJson, ConfigurationManager = ConfigurationManager, ChefConfiguration = ChefConfiguration, UseCustomCookbooks = UseCustomCookbooks, CustomCookbooksSource = CustomCookbooksSource, DefaultSshKeyName = DefaultSshKeyName, DefaultRootDeviceType = DefaultRootDeviceType, UseOpsworksSecurityGroups = UseOpsworksSecurityGroups, AgentVersion = AgentVersion)
  output <- .opsworks$update_stack_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$update_stack <- opsworks_update_stack

#' Updates a specified user profile
#'
#' @description
#' Updates a specified user profile.
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_update_user_profile/](https://www.paws-r-sdk.com/docs/opsworks_update_user_profile/) for full documentation.
#'
#' @param IamUserArn &#91;required&#93; The user IAM ARN. This can also be a federated user's ARN.
#' @param SshUsername The user's SSH user name. The allowable characters are \[a-z\], \[A-Z\],
#' \[0-9\], '-', and '_'. If the specified name includes other punctuation
#' marks, AWS OpsWorks Stacks removes them. For example, `my.name` will be
#' changed to `myname`. If you do not specify an SSH user name, AWS
#' OpsWorks Stacks generates one from the IAM user name.
#' @param SshPublicKey The user's new SSH public key.
#' @param AllowSelfManagement Whether users can specify their own SSH public key through the My
#' Settings page. For more information, see [Managing User
#' Permissions](https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html).
#'
#' @keywords internal
#'
#' @rdname opsworks_update_user_profile
opsworks_update_user_profile <- function(IamUserArn, SshUsername = NULL, SshPublicKey = NULL, AllowSelfManagement = NULL) {
  op <- new_operation(
    name = "UpdateUserProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$update_user_profile_input(IamUserArn = IamUserArn, SshUsername = SshUsername, SshPublicKey = SshPublicKey, AllowSelfManagement = AllowSelfManagement)
  output <- .opsworks$update_user_profile_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$update_user_profile <- opsworks_update_user_profile

#' Updates an Amazon EBS volume's name or mount point
#'
#' @description
#' Updates an Amazon EBS volume's name or mount point. For more information, see [Resource Management](https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
#'
#' See [https://www.paws-r-sdk.com/docs/opsworks_update_volume/](https://www.paws-r-sdk.com/docs/opsworks_update_volume/) for full documentation.
#'
#' @param VolumeId &#91;required&#93; The volume ID.
#' @param Name The new name.
#' @param MountPoint The new mount point.
#'
#' @keywords internal
#'
#' @rdname opsworks_update_volume
opsworks_update_volume <- function(VolumeId, Name = NULL, MountPoint = NULL) {
  op <- new_operation(
    name = "UpdateVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .opsworks$update_volume_input(VolumeId = VolumeId, Name = Name, MountPoint = MountPoint)
  output <- .opsworks$update_volume_output()
  config <- get_config()
  svc <- .opsworks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opsworks$operations$update_volume <- opsworks_update_volume
