% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_update_app}
\alias{resiliencehub_update_app}
\title{Updates an application}
\usage{
resiliencehub_update_app(
  appArn,
  assessmentSchedule = NULL,
  clearResiliencyPolicyArn = NULL,
  description = NULL,
  policyArn = NULL
)
}
\arguments{
\item{appArn}{[required] The Amazon Resource Name (ARN) of the application. The format for this
ARN is: arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app/\code{app-id}.
For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs)}
in the \emph{AWS General Reference}.}

\item{assessmentSchedule}{Assessment execution schedule with 'Daily' or 'Disabled' values.}

\item{clearResiliencyPolicyArn}{Specifies if the resiliency policy ARN should be cleared.}

\item{description}{The optional description for an app.}

\item{policyArn}{The Amazon Resource Name (ARN) of the resiliency policy. The format for
this ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:resiliency-policy/\code{policy-id}.
For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs)}
in the \emph{AWS General Reference}.}
}
\description{
Updates an application.

See \url{https://paws-r.github.io/docs/resiliencehub/update_app.html} for full documentation.
}
\keyword{internal}
