% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi_operations.R
\name{pi_list_available_resource_dimensions}
\alias{pi_list_available_resource_dimensions}
\title{Retrieve the dimensions that can be queried for each specified metric
type on a specified DB instance}
\usage{
pi_list_available_resource_dimensions(
  ServiceType,
  Identifier,
  Metrics,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ServiceType}{[required] The Amazon Web Services service for which Performance Insights returns
metrics.}

\item{Identifier}{[required] An immutable identifier for a data source that is unique within an
Amazon Web Services Region. Performance Insights gathers metrics from
this data source. To use an Amazon RDS DB instance as a data source,
specify its \code{DbiResourceId} value. For example, specify
\code{db-ABCDEFGHIJKLMNOPQRSTU1VWZ}.}

\item{Metrics}{[required] The types of metrics for which to retrieve dimensions. Valid values
include \code{db.load}.}

\item{MaxResults}{The maximum number of items to return in the response. If more items
exist than the specified \code{MaxRecords} value, a pagination token is
included in the response so that the remaining results can be retrieved.}

\item{NextToken}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
token, up to the value specified by \code{MaxRecords}.}
}
\description{
Retrieve the dimensions that can be queried for each specified metric type on a specified DB instance.

See \url{https://paws-r.github.io/docs/pi/list_available_resource_dimensions.html} for full documentation.
}
\keyword{internal}
