# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include configservice_service.R
NULL

#' Returns the current configuration items for resources that are present
#' in your Config aggregator
#'
#' @description
#' Returns the current configuration items for resources that are present in your Config aggregator. The operation also returns a list of resources that are not processed in the current request. If there are no unprocessed resources, the operation returns an empty `unprocessedResourceIdentifiers` list.
#'
#' See [https://paws-r.github.io/docs/configservice/batch_get_aggregate_resource_config.html](https://paws-r.github.io/docs/configservice/batch_get_aggregate_resource_config.html) for full documentation.
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param ResourceIdentifiers &#91;required&#93; A list of aggregate ResourceIdentifiers objects.
#'
#' @keywords internal
#'
#' @rdname configservice_batch_get_aggregate_resource_config
configservice_batch_get_aggregate_resource_config <- function(ConfigurationAggregatorName, ResourceIdentifiers) {
  op <- new_operation(
    name = "BatchGetAggregateResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$batch_get_aggregate_resource_config_input(ConfigurationAggregatorName = ConfigurationAggregatorName, ResourceIdentifiers = ResourceIdentifiers)
  output <- .configservice$batch_get_aggregate_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$batch_get_aggregate_resource_config <- configservice_batch_get_aggregate_resource_config

#' Returns the BaseConfigurationItem for one or more requested resources
#'
#' @description
#' Returns the `BaseConfigurationItem` for one or more requested resources. The operation also returns a list of resources that are not processed in the current request. If there are no unprocessed resources, the operation returns an empty unprocessedResourceKeys list.
#'
#' See [https://paws-r.github.io/docs/configservice/batch_get_resource_config.html](https://paws-r.github.io/docs/configservice/batch_get_resource_config.html) for full documentation.
#'
#' @param resourceKeys &#91;required&#93; A list of resource keys to be processed with the current request. Each
#' element in the list consists of the resource type and resource ID.
#'
#' @keywords internal
#'
#' @rdname configservice_batch_get_resource_config
configservice_batch_get_resource_config <- function(resourceKeys) {
  op <- new_operation(
    name = "BatchGetResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$batch_get_resource_config_input(resourceKeys = resourceKeys)
  output <- .configservice$batch_get_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$batch_get_resource_config <- configservice_batch_get_resource_config

#' Deletes the authorization granted to the specified configuration
#' aggregator account in a specified region
#'
#' @description
#' Deletes the authorization granted to the specified configuration aggregator account in a specified region.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_aggregation_authorization.html](https://paws-r.github.io/docs/configservice/delete_aggregation_authorization.html) for full documentation.
#'
#' @param AuthorizedAccountId &#91;required&#93; The 12-digit account ID of the account authorized to aggregate data.
#' @param AuthorizedAwsRegion &#91;required&#93; The region authorized to collect aggregated data.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_aggregation_authorization
configservice_delete_aggregation_authorization <- function(AuthorizedAccountId, AuthorizedAwsRegion) {
  op <- new_operation(
    name = "DeleteAggregationAuthorization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_aggregation_authorization_input(AuthorizedAccountId = AuthorizedAccountId, AuthorizedAwsRegion = AuthorizedAwsRegion)
  output <- .configservice$delete_aggregation_authorization_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_aggregation_authorization <- configservice_delete_aggregation_authorization

#' Deletes the specified Config rule and all of its evaluation results
#'
#' @description
#' Deletes the specified Config rule and all of its evaluation results.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_config_rule.html](https://paws-r.github.io/docs/configservice/delete_config_rule.html) for full documentation.
#'
#' @param ConfigRuleName &#91;required&#93; The name of the Config rule that you want to delete.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_config_rule
configservice_delete_config_rule <- function(ConfigRuleName) {
  op <- new_operation(
    name = "DeleteConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_config_rule_input(ConfigRuleName = ConfigRuleName)
  output <- .configservice$delete_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_config_rule <- configservice_delete_config_rule

#' Deletes the specified configuration aggregator and the aggregated data
#' associated with the aggregator
#'
#' @description
#' Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_configuration_aggregator.html](https://paws-r.github.io/docs/configservice/delete_configuration_aggregator.html) for full documentation.
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_configuration_aggregator
configservice_delete_configuration_aggregator <- function(ConfigurationAggregatorName) {
  op <- new_operation(
    name = "DeleteConfigurationAggregator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_configuration_aggregator_input(ConfigurationAggregatorName = ConfigurationAggregatorName)
  output <- .configservice$delete_configuration_aggregator_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_configuration_aggregator <- configservice_delete_configuration_aggregator

#' Deletes the configuration recorder
#'
#' @description
#' Deletes the configuration recorder.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_configuration_recorder.html](https://paws-r.github.io/docs/configservice/delete_configuration_recorder.html) for full documentation.
#'
#' @param ConfigurationRecorderName &#91;required&#93; The name of the configuration recorder to be deleted. You can retrieve
#' the name of your configuration recorder by using the
#' [`describe_configuration_recorders`][configservice_describe_configuration_recorders]
#' action.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_configuration_recorder
configservice_delete_configuration_recorder <- function(ConfigurationRecorderName) {
  op <- new_operation(
    name = "DeleteConfigurationRecorder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_configuration_recorder_input(ConfigurationRecorderName = ConfigurationRecorderName)
  output <- .configservice$delete_configuration_recorder_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_configuration_recorder <- configservice_delete_configuration_recorder

#' Deletes the specified conformance pack and all the Config rules,
#' remediation actions, and all evaluation results within that conformance
#' pack
#'
#' @description
#' Deletes the specified conformance pack and all the Config rules, remediation actions, and all evaluation results within that conformance pack.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_conformance_pack.html](https://paws-r.github.io/docs/configservice/delete_conformance_pack.html) for full documentation.
#'
#' @param ConformancePackName &#91;required&#93; Name of the conformance pack you want to delete.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_conformance_pack
configservice_delete_conformance_pack <- function(ConformancePackName) {
  op <- new_operation(
    name = "DeleteConformancePack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_conformance_pack_input(ConformancePackName = ConformancePackName)
  output <- .configservice$delete_conformance_pack_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_conformance_pack <- configservice_delete_conformance_pack

#' Deletes the delivery channel
#'
#' @description
#' Deletes the delivery channel.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_delivery_channel.html](https://paws-r.github.io/docs/configservice/delete_delivery_channel.html) for full documentation.
#'
#' @param DeliveryChannelName &#91;required&#93; The name of the delivery channel to delete.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_delivery_channel
configservice_delete_delivery_channel <- function(DeliveryChannelName) {
  op <- new_operation(
    name = "DeleteDeliveryChannel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_delivery_channel_input(DeliveryChannelName = DeliveryChannelName)
  output <- .configservice$delete_delivery_channel_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_delivery_channel <- configservice_delete_delivery_channel

#' Deletes the evaluation results for the specified Config rule
#'
#' @description
#' Deletes the evaluation results for the specified Config rule. You can specify one Config rule per request. After you delete the evaluation results, you can call the [`start_config_rules_evaluation`][configservice_start_config_rules_evaluation] API to start evaluating your Amazon Web Services resources against the rule.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_evaluation_results.html](https://paws-r.github.io/docs/configservice/delete_evaluation_results.html) for full documentation.
#'
#' @param ConfigRuleName &#91;required&#93; The name of the Config rule for which you want to delete the evaluation
#' results.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_evaluation_results
configservice_delete_evaluation_results <- function(ConfigRuleName) {
  op <- new_operation(
    name = "DeleteEvaluationResults",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_evaluation_results_input(ConfigRuleName = ConfigRuleName)
  output <- .configservice$delete_evaluation_results_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_evaluation_results <- configservice_delete_evaluation_results

#' Deletes the specified organization Config rule and all of its evaluation
#' results from all member accounts in that organization
#'
#' @description
#' Deletes the specified organization Config rule and all of its evaluation results from all member accounts in that organization.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_organization_config_rule.html](https://paws-r.github.io/docs/configservice/delete_organization_config_rule.html) for full documentation.
#'
#' @param OrganizationConfigRuleName &#91;required&#93; The name of organization Config rule that you want to delete.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_organization_config_rule
configservice_delete_organization_config_rule <- function(OrganizationConfigRuleName) {
  op <- new_operation(
    name = "DeleteOrganizationConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_organization_config_rule_input(OrganizationConfigRuleName = OrganizationConfigRuleName)
  output <- .configservice$delete_organization_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_organization_config_rule <- configservice_delete_organization_config_rule

#' Deletes the specified organization conformance pack and all of the
#' Config rules and remediation actions from all member accounts in that
#' organization
#'
#' @description
#' Deletes the specified organization conformance pack and all of the Config rules and remediation actions from all member accounts in that organization.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_organization_conformance_pack.html](https://paws-r.github.io/docs/configservice/delete_organization_conformance_pack.html) for full documentation.
#'
#' @param OrganizationConformancePackName &#91;required&#93; The name of organization conformance pack that you want to delete.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_organization_conformance_pack
configservice_delete_organization_conformance_pack <- function(OrganizationConformancePackName) {
  op <- new_operation(
    name = "DeleteOrganizationConformancePack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_organization_conformance_pack_input(OrganizationConformancePackName = OrganizationConformancePackName)
  output <- .configservice$delete_organization_conformance_pack_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_organization_conformance_pack <- configservice_delete_organization_conformance_pack

#' Deletes pending authorization requests for a specified aggregator
#' account in a specified region
#'
#' @description
#' Deletes pending authorization requests for a specified aggregator account in a specified region.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_pending_aggregation_request.html](https://paws-r.github.io/docs/configservice/delete_pending_aggregation_request.html) for full documentation.
#'
#' @param RequesterAccountId &#91;required&#93; The 12-digit account ID of the account requesting to aggregate data.
#' @param RequesterAwsRegion &#91;required&#93; The region requesting to aggregate data.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_pending_aggregation_request
configservice_delete_pending_aggregation_request <- function(RequesterAccountId, RequesterAwsRegion) {
  op <- new_operation(
    name = "DeletePendingAggregationRequest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_pending_aggregation_request_input(RequesterAccountId = RequesterAccountId, RequesterAwsRegion = RequesterAwsRegion)
  output <- .configservice$delete_pending_aggregation_request_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_pending_aggregation_request <- configservice_delete_pending_aggregation_request

#' Deletes the remediation configuration
#'
#' @description
#' Deletes the remediation configuration.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_remediation_configuration.html](https://paws-r.github.io/docs/configservice/delete_remediation_configuration.html) for full documentation.
#'
#' @param ConfigRuleName &#91;required&#93; The name of the Config rule for which you want to delete remediation
#' configuration.
#' @param ResourceType The type of a resource.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_remediation_configuration
configservice_delete_remediation_configuration <- function(ConfigRuleName, ResourceType = NULL) {
  op <- new_operation(
    name = "DeleteRemediationConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_remediation_configuration_input(ConfigRuleName = ConfigRuleName, ResourceType = ResourceType)
  output <- .configservice$delete_remediation_configuration_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_remediation_configuration <- configservice_delete_remediation_configuration

#' Deletes one or more remediation exceptions mentioned in the resource
#' keys
#'
#' @description
#' Deletes one or more remediation exceptions mentioned in the resource keys.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_remediation_exceptions.html](https://paws-r.github.io/docs/configservice/delete_remediation_exceptions.html) for full documentation.
#'
#' @param ConfigRuleName &#91;required&#93; The name of the Config rule for which you want to delete remediation
#' exception configuration.
#' @param ResourceKeys &#91;required&#93; An exception list of resource exception keys to be processed with the
#' current request. Config adds exception for each resource key. For
#' example, Config adds 3 exceptions for 3 resource keys.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_remediation_exceptions
configservice_delete_remediation_exceptions <- function(ConfigRuleName, ResourceKeys) {
  op <- new_operation(
    name = "DeleteRemediationExceptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_remediation_exceptions_input(ConfigRuleName = ConfigRuleName, ResourceKeys = ResourceKeys)
  output <- .configservice$delete_remediation_exceptions_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_remediation_exceptions <- configservice_delete_remediation_exceptions

#' Records the configuration state for a custom resource that has been
#' deleted
#'
#' @description
#' Records the configuration state for a custom resource that has been deleted. This API records a new ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this resource in your Config History.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_resource_config.html](https://paws-r.github.io/docs/configservice/delete_resource_config.html) for full documentation.
#'
#' @param ResourceType &#91;required&#93; The type of the resource.
#' @param ResourceId &#91;required&#93; Unique identifier of the resource.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_resource_config
configservice_delete_resource_config <- function(ResourceType, ResourceId) {
  op <- new_operation(
    name = "DeleteResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_resource_config_input(ResourceType = ResourceType, ResourceId = ResourceId)
  output <- .configservice$delete_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_resource_config <- configservice_delete_resource_config

#' Deletes the retention configuration
#'
#' @description
#' Deletes the retention configuration.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_retention_configuration.html](https://paws-r.github.io/docs/configservice/delete_retention_configuration.html) for full documentation.
#'
#' @param RetentionConfigurationName &#91;required&#93; The name of the retention configuration to delete.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_retention_configuration
configservice_delete_retention_configuration <- function(RetentionConfigurationName) {
  op <- new_operation(
    name = "DeleteRetentionConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_retention_configuration_input(RetentionConfigurationName = RetentionConfigurationName)
  output <- .configservice$delete_retention_configuration_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_retention_configuration <- configservice_delete_retention_configuration

#' Deletes the stored query for a single Amazon Web Services account and a
#' single Amazon Web Services Region
#'
#' @description
#' Deletes the stored query for a single Amazon Web Services account and a single Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/configservice/delete_stored_query.html](https://paws-r.github.io/docs/configservice/delete_stored_query.html) for full documentation.
#'
#' @param QueryName &#91;required&#93; The name of the query that you want to delete.
#'
#' @keywords internal
#'
#' @rdname configservice_delete_stored_query
configservice_delete_stored_query <- function(QueryName) {
  op <- new_operation(
    name = "DeleteStoredQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$delete_stored_query_input(QueryName = QueryName)
  output <- .configservice$delete_stored_query_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$delete_stored_query <- configservice_delete_stored_query

#' Schedules delivery of a configuration snapshot to the Amazon S3 bucket
#' in the specified delivery channel
#'
#' @description
#' Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After the delivery has started, Config sends the following notifications using an Amazon SNS topic that you have specified.
#'
#' See [https://paws-r.github.io/docs/configservice/deliver_config_snapshot.html](https://paws-r.github.io/docs/configservice/deliver_config_snapshot.html) for full documentation.
#'
#' @param deliveryChannelName &#91;required&#93; The name of the delivery channel through which the snapshot is
#' delivered.
#'
#' @keywords internal
#'
#' @rdname configservice_deliver_config_snapshot
configservice_deliver_config_snapshot <- function(deliveryChannelName) {
  op <- new_operation(
    name = "DeliverConfigSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$deliver_config_snapshot_input(deliveryChannelName = deliveryChannelName)
  output <- .configservice$deliver_config_snapshot_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$deliver_config_snapshot <- configservice_deliver_config_snapshot

#' Returns a list of compliant and noncompliant rules with the number of
#' resources for compliant and noncompliant rules
#'
#' @description
#' Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant rules. Does not display rules that do not have compliance results.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_aggregate_compliance_by_config_rules.html](https://paws-r.github.io/docs/configservice/describe_aggregate_compliance_by_config_rules.html) for full documentation.
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param Filters Filters the results by ConfigRuleComplianceFilters object.
#' @param Limit The maximum number of evaluation results returned on each page. The
#' default is maximum. If you specify 0, Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_aggregate_compliance_by_config_rules
configservice_describe_aggregate_compliance_by_config_rules <- function(ConfigurationAggregatorName, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAggregateComplianceByConfigRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_aggregate_compliance_by_config_rules_input(ConfigurationAggregatorName = ConfigurationAggregatorName, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_aggregate_compliance_by_config_rules_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_aggregate_compliance_by_config_rules <- configservice_describe_aggregate_compliance_by_config_rules

#' Returns a list of the conformance packs and their associated compliance
#' status with the count of compliant and noncompliant Config rules within
#' each conformance pack
#'
#' @description
#' Returns a list of the conformance packs and their associated compliance status with the count of compliant and noncompliant Config rules within each conformance pack. Also returns the total rule count which includes compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_aggregate_compliance_by_conformance_packs.html](https://paws-r.github.io/docs/configservice/describe_aggregate_compliance_by_conformance_packs.html) for full documentation.
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param Filters Filters the result by `AggregateConformancePackComplianceFilters`
#' object.
#' @param Limit The maximum number of conformance packs compliance details returned on
#' each page. The default is maximum. If you specify 0, Config uses the
#' default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_descri_aggreg_compli_by_confor_packs
configservice_describe_aggregate_compliance_by_conformance_packs <- function(ConfigurationAggregatorName, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAggregateComplianceByConformancePacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_aggregate_compliance_by_conformance_packs_input(ConfigurationAggregatorName = ConfigurationAggregatorName, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_aggregate_compliance_by_conformance_packs_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_aggregate_compliance_by_conformance_packs <- configservice_describe_aggregate_compliance_by_conformance_packs

#' Returns a list of authorizations granted to various aggregator accounts
#' and regions
#'
#' @description
#' Returns a list of authorizations granted to various aggregator accounts and regions.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_aggregation_authorizations.html](https://paws-r.github.io/docs/configservice/describe_aggregation_authorizations.html) for full documentation.
#'
#' @param Limit The maximum number of AggregationAuthorizations returned on each page.
#' The default is maximum. If you specify 0, Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_aggregation_authorizations
configservice_describe_aggregation_authorizations <- function(Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAggregationAuthorizations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_aggregation_authorizations_input(Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_aggregation_authorizations_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_aggregation_authorizations <- configservice_describe_aggregation_authorizations

#' Indicates whether the specified Config rules are compliant
#'
#' @description
#' Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this action returns the number of Amazon Web Services resources that do not comply with the rule.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_compliance_by_config_rule.html](https://paws-r.github.io/docs/configservice/describe_compliance_by_config_rule.html) for full documentation.
#'
#' @param ConfigRuleNames Specify one or more Config rule names to filter the results by rule.
#' @param ComplianceTypes Filters the results by compliance.
#' 
#' The allowed values are `COMPLIANT` and `NON_COMPLIANT`.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_compliance_by_config_rule
configservice_describe_compliance_by_config_rule <- function(ConfigRuleNames = NULL, ComplianceTypes = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeComplianceByConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_compliance_by_config_rule_input(ConfigRuleNames = ConfigRuleNames, ComplianceTypes = ComplianceTypes, NextToken = NextToken)
  output <- .configservice$describe_compliance_by_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_compliance_by_config_rule <- configservice_describe_compliance_by_config_rule

#' Indicates whether the specified Amazon Web Services resources are
#' compliant
#'
#' @description
#' Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this action returns the number of Config rules that the resource does not comply with.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_compliance_by_resource.html](https://paws-r.github.io/docs/configservice/describe_compliance_by_resource.html) for full documentation.
#'
#' @param ResourceType The types of Amazon Web Services resources for which you want compliance
#' information (for example, `AWS::EC2::Instance`). For this action, you
#' can specify that the resource type is an Amazon Web Services account by
#' specifying `AWS::::Account`.
#' @param ResourceId The ID of the Amazon Web Services resource for which you want compliance
#' information. You can specify only one resource ID. If you specify a
#' resource ID, you must also specify a type for `ResourceType`.
#' @param ComplianceTypes Filters the results by compliance.
#' 
#' The allowed values are `COMPLIANT`, `NON_COMPLIANT`, and
#' `INSUFFICIENT_DATA`.
#' @param Limit The maximum number of evaluation results returned on each page. The
#' default is 10. You cannot specify a number greater than 100. If you
#' specify 0, Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_compliance_by_resource
configservice_describe_compliance_by_resource <- function(ResourceType = NULL, ResourceId = NULL, ComplianceTypes = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeComplianceByResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_compliance_by_resource_input(ResourceType = ResourceType, ResourceId = ResourceId, ComplianceTypes = ComplianceTypes, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_compliance_by_resource_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_compliance_by_resource <- configservice_describe_compliance_by_resource

#' Returns status information for each of your Config managed rules
#'
#' @description
#' Returns status information for each of your Config managed rules. The status includes information such as the last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the last failure.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_config_rule_evaluation_status.html](https://paws-r.github.io/docs/configservice/describe_config_rule_evaluation_status.html) for full documentation.
#'
#' @param ConfigRuleNames The name of the Config managed rules for which you want status
#' information. If you do not specify any names, Config returns status
#' information for all Config managed rules that you use.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#' @param Limit The number of rule evaluation results that you want returned.
#' 
#' This parameter is required if the rule limit for your account is more
#' than the default of 150 rules.
#' 
#' For information about requesting a rule limit increase, see [Config
#' Limits](https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config)
#' in the *Amazon Web Services General Reference Guide*.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_config_rule_evaluation_status
configservice_describe_config_rule_evaluation_status <- function(ConfigRuleNames = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeConfigRuleEvaluationStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_config_rule_evaluation_status_input(ConfigRuleNames = ConfigRuleNames, NextToken = NextToken, Limit = Limit)
  output <- .configservice$describe_config_rule_evaluation_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_config_rule_evaluation_status <- configservice_describe_config_rule_evaluation_status

#' Returns details about your Config rules
#'
#' @description
#' Returns details about your Config rules.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_config_rules.html](https://paws-r.github.io/docs/configservice/describe_config_rules.html) for full documentation.
#'
#' @param ConfigRuleNames The names of the Config rules for which you want details. If you do not
#' specify any names, Config returns details for all your rules.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_config_rules
configservice_describe_config_rules <- function(ConfigRuleNames = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeConfigRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_config_rules_input(ConfigRuleNames = ConfigRuleNames, NextToken = NextToken)
  output <- .configservice$describe_config_rules_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_config_rules <- configservice_describe_config_rules

#' Returns status information for sources within an aggregator
#'
#' @description
#' Returns status information for sources within an aggregator. The status includes information about the last time Config verified authorization between the source account and an aggregator account. In case of a failure, the status contains the related error code or message.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_configuration_aggregator_sources_status.html](https://paws-r.github.io/docs/configservice/describe_configuration_aggregator_sources_status.html) for full documentation.
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param UpdateStatus Filters the status type.
#' 
#' -   Valid value FAILED indicates errors while moving data.
#' 
#' -   Valid value SUCCEEDED indicates the data was successfully moved.
#' 
#' -   Valid value OUTDATED indicates the data is not the most recent.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#' @param Limit The maximum number of AggregatorSourceStatus returned on each page. The
#' default is maximum. If you specify 0, Config uses the default.
#'
#' @keywords internal
#'
#' @rdname configservice_describ_configu_aggrega_sources_status
configservice_describe_configuration_aggregator_sources_status <- function(ConfigurationAggregatorName, UpdateStatus = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationAggregatorSourcesStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_configuration_aggregator_sources_status_input(ConfigurationAggregatorName = ConfigurationAggregatorName, UpdateStatus = UpdateStatus, NextToken = NextToken, Limit = Limit)
  output <- .configservice$describe_configuration_aggregator_sources_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_configuration_aggregator_sources_status <- configservice_describe_configuration_aggregator_sources_status

#' Returns the details of one or more configuration aggregators
#'
#' @description
#' Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified, this action returns the details for all the configuration aggregators associated with the account.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_configuration_aggregators.html](https://paws-r.github.io/docs/configservice/describe_configuration_aggregators.html) for full documentation.
#'
#' @param ConfigurationAggregatorNames The name of the configuration aggregators.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#' @param Limit The maximum number of configuration aggregators returned on each page.
#' The default is maximum. If you specify 0, Config uses the default.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_configuration_aggregators
configservice_describe_configuration_aggregators <- function(ConfigurationAggregatorNames = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationAggregators",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_configuration_aggregators_input(ConfigurationAggregatorNames = ConfigurationAggregatorNames, NextToken = NextToken, Limit = Limit)
  output <- .configservice$describe_configuration_aggregators_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_configuration_aggregators <- configservice_describe_configuration_aggregators

#' Returns the current status of the specified configuration recorder
#'
#' @description
#' Returns the current status of the specified configuration recorder. If a configuration recorder is not specified, this action returns the status of all configuration recorders associated with the account.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_configuration_recorder_status.html](https://paws-r.github.io/docs/configservice/describe_configuration_recorder_status.html) for full documentation.
#'
#' @param ConfigurationRecorderNames The name(s) of the configuration recorder. If the name is not specified,
#' the action returns the current status of all the configuration recorders
#' associated with the account.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_configuration_recorder_status
configservice_describe_configuration_recorder_status <- function(ConfigurationRecorderNames = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationRecorderStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_configuration_recorder_status_input(ConfigurationRecorderNames = ConfigurationRecorderNames)
  output <- .configservice$describe_configuration_recorder_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_configuration_recorder_status <- configservice_describe_configuration_recorder_status

#' Returns the details for the specified configuration recorders
#'
#' @description
#' Returns the details for the specified configuration recorders. If the configuration recorder is not specified, this action returns the details for all configuration recorders associated with the account.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_configuration_recorders.html](https://paws-r.github.io/docs/configservice/describe_configuration_recorders.html) for full documentation.
#'
#' @param ConfigurationRecorderNames A list of configuration recorder names.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_configuration_recorders
configservice_describe_configuration_recorders <- function(ConfigurationRecorderNames = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationRecorders",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_configuration_recorders_input(ConfigurationRecorderNames = ConfigurationRecorderNames)
  output <- .configservice$describe_configuration_recorders_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_configuration_recorders <- configservice_describe_configuration_recorders

#' Returns compliance details for each rule in that conformance pack
#'
#' @description
#' Returns compliance details for each rule in that conformance pack.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_conformance_pack_compliance.html](https://paws-r.github.io/docs/configservice/describe_conformance_pack_compliance.html) for full documentation.
#'
#' @param ConformancePackName &#91;required&#93; Name of the conformance pack.
#' @param Filters A `ConformancePackComplianceFilters` object.
#' @param Limit The maximum number of Config rules within a conformance pack are
#' returned on each page.
#' @param NextToken The `nextToken` string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_conformance_pack_compliance
configservice_describe_conformance_pack_compliance <- function(ConformancePackName, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeConformancePackCompliance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_conformance_pack_compliance_input(ConformancePackName = ConformancePackName, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_conformance_pack_compliance_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_conformance_pack_compliance <- configservice_describe_conformance_pack_compliance

#' Provides one or more conformance packs deployment status
#'
#' @description
#' Provides one or more conformance packs deployment status.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_conformance_pack_status.html](https://paws-r.github.io/docs/configservice/describe_conformance_pack_status.html) for full documentation.
#'
#' @param ConformancePackNames Comma-separated list of conformance pack names.
#' @param Limit The maximum number of conformance packs status returned on each page.
#' @param NextToken The `nextToken` string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_conformance_pack_status
configservice_describe_conformance_pack_status <- function(ConformancePackNames = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeConformancePackStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_conformance_pack_status_input(ConformancePackNames = ConformancePackNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_conformance_pack_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_conformance_pack_status <- configservice_describe_conformance_pack_status

#' Returns a list of one or more conformance packs
#'
#' @description
#' Returns a list of one or more conformance packs.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_conformance_packs.html](https://paws-r.github.io/docs/configservice/describe_conformance_packs.html) for full documentation.
#'
#' @param ConformancePackNames Comma-separated list of conformance pack names for which you want
#' details. If you do not specify any names, Config returns details for all
#' your conformance packs.
#' @param Limit The maximum number of conformance packs returned on each page.
#' @param NextToken The `nextToken` string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_conformance_packs
configservice_describe_conformance_packs <- function(ConformancePackNames = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeConformancePacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_conformance_packs_input(ConformancePackNames = ConformancePackNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_conformance_packs_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_conformance_packs <- configservice_describe_conformance_packs

#' Returns the current status of the specified delivery channel
#'
#' @description
#' Returns the current status of the specified delivery channel. If a delivery channel is not specified, this action returns the current status of all delivery channels associated with the account.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_delivery_channel_status.html](https://paws-r.github.io/docs/configservice/describe_delivery_channel_status.html) for full documentation.
#'
#' @param DeliveryChannelNames A list of delivery channel names.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_delivery_channel_status
configservice_describe_delivery_channel_status <- function(DeliveryChannelNames = NULL) {
  op <- new_operation(
    name = "DescribeDeliveryChannelStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_delivery_channel_status_input(DeliveryChannelNames = DeliveryChannelNames)
  output <- .configservice$describe_delivery_channel_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_delivery_channel_status <- configservice_describe_delivery_channel_status

#' Returns details about the specified delivery channel
#'
#' @description
#' Returns details about the specified delivery channel. If a delivery channel is not specified, this action returns the details of all delivery channels associated with the account.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_delivery_channels.html](https://paws-r.github.io/docs/configservice/describe_delivery_channels.html) for full documentation.
#'
#' @param DeliveryChannelNames A list of delivery channel names.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_delivery_channels
configservice_describe_delivery_channels <- function(DeliveryChannelNames = NULL) {
  op <- new_operation(
    name = "DescribeDeliveryChannels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_delivery_channels_input(DeliveryChannelNames = DeliveryChannelNames)
  output <- .configservice$describe_delivery_channels_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_delivery_channels <- configservice_describe_delivery_channels

#' Provides organization Config rule deployment status for an organization
#'
#' @description
#' Provides organization Config rule deployment status for an organization.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_organization_config_rule_statuses.html](https://paws-r.github.io/docs/configservice/describe_organization_config_rule_statuses.html) for full documentation.
#'
#' @param OrganizationConfigRuleNames The names of organization Config rules for which you want status
#' details. If you do not specify any names, Config returns details for all
#' your organization Config rules.
#' @param Limit The maximum number of `OrganizationConfigRuleStatuses` returned on each
#' page. If you do no specify a number, Config uses the default. The
#' default is 100.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_organization_config_rule_statuses
configservice_describe_organization_config_rule_statuses <- function(OrganizationConfigRuleNames = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationConfigRuleStatuses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_organization_config_rule_statuses_input(OrganizationConfigRuleNames = OrganizationConfigRuleNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_organization_config_rule_statuses_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_organization_config_rule_statuses <- configservice_describe_organization_config_rule_statuses

#' Returns a list of organization Config rules
#'
#' @description
#' Returns a list of organization Config rules.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_organization_config_rules.html](https://paws-r.github.io/docs/configservice/describe_organization_config_rules.html) for full documentation.
#'
#' @param OrganizationConfigRuleNames The names of organization Config rules for which you want details. If
#' you do not specify any names, Config returns details for all your
#' organization Config rules.
#' @param Limit The maximum number of organization Config rules returned on each page.
#' If you do no specify a number, Config uses the default. The default is
#' 100.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_organization_config_rules
configservice_describe_organization_config_rules <- function(OrganizationConfigRuleNames = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationConfigRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_organization_config_rules_input(OrganizationConfigRuleNames = OrganizationConfigRuleNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_organization_config_rules_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_organization_config_rules <- configservice_describe_organization_config_rules

#' Provides organization conformance pack deployment status for an
#' organization
#'
#' @description
#' Provides organization conformance pack deployment status for an organization.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_organization_conformance_pack_statuses.html](https://paws-r.github.io/docs/configservice/describe_organization_conformance_pack_statuses.html) for full documentation.
#'
#' @param OrganizationConformancePackNames The names of organization conformance packs for which you want status
#' details. If you do not specify any names, Config returns details for all
#' your organization conformance packs.
#' @param Limit The maximum number of OrganizationConformancePackStatuses returned on
#' each page. If you do no specify a number, Config uses the default. The
#' default is 100.
#' @param NextToken The nextToken string returned on a previous page that you use to get the
#' next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describ_organiz_conform_pack_statuse
configservice_describe_organization_conformance_pack_statuses <- function(OrganizationConformancePackNames = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationConformancePackStatuses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_organization_conformance_pack_statuses_input(OrganizationConformancePackNames = OrganizationConformancePackNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_organization_conformance_pack_statuses_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_organization_conformance_pack_statuses <- configservice_describe_organization_conformance_pack_statuses

#' Returns a list of organization conformance packs
#'
#' @description
#' Returns a list of organization conformance packs.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_organization_conformance_packs.html](https://paws-r.github.io/docs/configservice/describe_organization_conformance_packs.html) for full documentation.
#'
#' @param OrganizationConformancePackNames The name that you assign to an organization conformance pack.
#' @param Limit The maximum number of organization config packs returned on each page.
#' If you do no specify a number, Config uses the default. The default is
#' 100.
#' @param NextToken The nextToken string returned on a previous page that you use to get the
#' next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_organization_conformance_packs
configservice_describe_organization_conformance_packs <- function(OrganizationConformancePackNames = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOrganizationConformancePacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_organization_conformance_packs_input(OrganizationConformancePackNames = OrganizationConformancePackNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_organization_conformance_packs_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_organization_conformance_packs <- configservice_describe_organization_conformance_packs

#' Returns a list of all pending aggregation requests
#'
#' @description
#' Returns a list of all pending aggregation requests.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_pending_aggregation_requests.html](https://paws-r.github.io/docs/configservice/describe_pending_aggregation_requests.html) for full documentation.
#'
#' @param Limit The maximum number of evaluation results returned on each page. The
#' default is maximum. If you specify 0, Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_pending_aggregation_requests
configservice_describe_pending_aggregation_requests <- function(Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePendingAggregationRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_pending_aggregation_requests_input(Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_pending_aggregation_requests_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_pending_aggregation_requests <- configservice_describe_pending_aggregation_requests

#' Returns the details of one or more remediation configurations
#'
#' @description
#' Returns the details of one or more remediation configurations.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_remediation_configurations.html](https://paws-r.github.io/docs/configservice/describe_remediation_configurations.html) for full documentation.
#'
#' @param ConfigRuleNames &#91;required&#93; A list of Config rule names of remediation configurations for which you
#' want details.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_remediation_configurations
configservice_describe_remediation_configurations <- function(ConfigRuleNames) {
  op <- new_operation(
    name = "DescribeRemediationConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_remediation_configurations_input(ConfigRuleNames = ConfigRuleNames)
  output <- .configservice$describe_remediation_configurations_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_remediation_configurations <- configservice_describe_remediation_configurations

#' Returns the details of one or more remediation exceptions
#'
#' @description
#' Returns the details of one or more remediation exceptions. A detailed view of a remediation exception for a set of resources that includes an explanation of an exception and the time when the exception will be deleted. When you specify the limit and the next token, you receive a paginated response.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_remediation_exceptions.html](https://paws-r.github.io/docs/configservice/describe_remediation_exceptions.html) for full documentation.
#'
#' @param ConfigRuleName &#91;required&#93; The name of the Config rule.
#' @param ResourceKeys An exception list of resource exception keys to be processed with the
#' current request. Config adds exception for each resource key. For
#' example, Config adds 3 exceptions for 3 resource keys.
#' @param Limit The maximum number of RemediationExceptionResourceKey returned on each
#' page. The default is 25. If you specify 0, Config uses the default.
#' @param NextToken The `nextToken` string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_remediation_exceptions
configservice_describe_remediation_exceptions <- function(ConfigRuleName, ResourceKeys = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeRemediationExceptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_remediation_exceptions_input(ConfigRuleName = ConfigRuleName, ResourceKeys = ResourceKeys, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_remediation_exceptions_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_remediation_exceptions <- configservice_describe_remediation_exceptions

#' Provides a detailed view of a Remediation Execution for a set of
#' resources including state, timestamps for when steps for the remediation
#' execution occur, and any error messages for steps that have failed
#'
#' @description
#' Provides a detailed view of a Remediation Execution for a set of resources including state, timestamps for when steps for the remediation execution occur, and any error messages for steps that have failed. When you specify the limit and the next token, you receive a paginated response.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_remediation_execution_status.html](https://paws-r.github.io/docs/configservice/describe_remediation_execution_status.html) for full documentation.
#'
#' @param ConfigRuleName &#91;required&#93; A list of Config rule names.
#' @param ResourceKeys A list of resource keys to be processed with the current request. Each
#' element in the list consists of the resource type and resource ID.
#' @param Limit The maximum number of RemediationExecutionStatuses returned on each
#' page. The default is maximum. If you specify 0, Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_remediation_execution_status
configservice_describe_remediation_execution_status <- function(ConfigRuleName, ResourceKeys = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeRemediationExecutionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_remediation_execution_status_input(ConfigRuleName = ConfigRuleName, ResourceKeys = ResourceKeys, Limit = Limit, NextToken = NextToken)
  output <- .configservice$describe_remediation_execution_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_remediation_execution_status <- configservice_describe_remediation_execution_status

#' Returns the details of one or more retention configurations
#'
#' @description
#' Returns the details of one or more retention configurations. If the retention configuration name is not specified, this action returns the details for all the retention configurations for that account.
#'
#' See [https://paws-r.github.io/docs/configservice/describe_retention_configurations.html](https://paws-r.github.io/docs/configservice/describe_retention_configurations.html) for full documentation.
#'
#' @param RetentionConfigurationNames A list of names of retention configurations for which you want details.
#' If you do not specify a name, Config returns details for all the
#' retention configurations for that account.
#' 
#' Currently, Config supports only one retention configuration per region
#' in your account.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_describe_retention_configurations
configservice_describe_retention_configurations <- function(RetentionConfigurationNames = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeRetentionConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$describe_retention_configurations_input(RetentionConfigurationNames = RetentionConfigurationNames, NextToken = NextToken)
  output <- .configservice$describe_retention_configurations_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$describe_retention_configurations <- configservice_describe_retention_configurations

#' Returns the evaluation results for the specified Config rule for a
#' specific resource in a rule
#'
#' @description
#' Returns the evaluation results for the specified Config rule for a specific resource in a rule. The results indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies with the rule.
#'
#' See [https://paws-r.github.io/docs/configservice/get_aggregate_compliance_details_by_config_rule.html](https://paws-r.github.io/docs/configservice/get_aggregate_compliance_details_by_config_rule.html) for full documentation.
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param ConfigRuleName &#91;required&#93; The name of the Config rule for which you want compliance information.
#' @param AccountId &#91;required&#93; The 12-digit account ID of the source account.
#' @param AwsRegion &#91;required&#93; The source region from where the data is aggregated.
#' @param ComplianceType The resource compliance status.
#' 
#' For the `GetAggregateComplianceDetailsByConfigRuleRequest` data type,
#' Config supports only the `COMPLIANT` and `NON_COMPLIANT`. Config does
#' not support the `NOT_APPLICABLE` and `INSUFFICIENT_DATA` values.
#' @param Limit The maximum number of evaluation results returned on each page. The
#' default is 50. You cannot specify a number greater than 100. If you
#' specify 0, Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_get_aggre_compl_detai_by_confi_rule
configservice_get_aggregate_compliance_details_by_config_rule <- function(ConfigurationAggregatorName, ConfigRuleName, AccountId, AwsRegion, ComplianceType = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetAggregateComplianceDetailsByConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_aggregate_compliance_details_by_config_rule_input(ConfigurationAggregatorName = ConfigurationAggregatorName, ConfigRuleName = ConfigRuleName, AccountId = AccountId, AwsRegion = AwsRegion, ComplianceType = ComplianceType, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_aggregate_compliance_details_by_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_aggregate_compliance_details_by_config_rule <- configservice_get_aggregate_compliance_details_by_config_rule

#' Returns the number of compliant and noncompliant rules for one or more
#' accounts and regions in an aggregator
#'
#' @description
#' Returns the number of compliant and noncompliant rules for one or more accounts and regions in an aggregator.
#'
#' See [https://paws-r.github.io/docs/configservice/get_aggregate_config_rule_compliance_summary.html](https://paws-r.github.io/docs/configservice/get_aggregate_config_rule_compliance_summary.html) for full documentation.
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param Filters Filters the results based on the ConfigRuleComplianceSummaryFilters
#' object.
#' @param GroupByKey Groups the result based on ACCOUNT_ID or AWS_REGION.
#' @param Limit The maximum number of evaluation results returned on each page. The
#' default is 1000. You cannot specify a number greater than 1000. If you
#' specify 0, Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_get_aggregate_config_rule_compliance_summary
configservice_get_aggregate_config_rule_compliance_summary <- function(ConfigurationAggregatorName, Filters = NULL, GroupByKey = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetAggregateConfigRuleComplianceSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_aggregate_config_rule_compliance_summary_input(ConfigurationAggregatorName = ConfigurationAggregatorName, Filters = Filters, GroupByKey = GroupByKey, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_aggregate_config_rule_compliance_summary_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_aggregate_config_rule_compliance_summary <- configservice_get_aggregate_config_rule_compliance_summary

#' Returns the count of compliant and noncompliant conformance packs across
#' all Amazon Web Services accounts and Amazon Web Services Regions in an
#' aggregator
#'
#' @description
#' Returns the count of compliant and noncompliant conformance packs across all Amazon Web Services accounts and Amazon Web Services Regions in an aggregator. You can filter based on Amazon Web Services account ID or Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/configservice/get_aggregate_conformance_pack_compliance_summary.html](https://paws-r.github.io/docs/configservice/get_aggregate_conformance_pack_compliance_summary.html) for full documentation.
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param Filters Filters the results based on the
#' `AggregateConformancePackComplianceSummaryFilters` object.
#' @param GroupByKey Groups the result based on Amazon Web Services account ID or Amazon Web
#' Services Region.
#' @param Limit The maximum number of results returned on each page. The default is
#' maximum. If you specify 0, Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_get_aggreg_confor_pack_compli_summar
configservice_get_aggregate_conformance_pack_compliance_summary <- function(ConfigurationAggregatorName, Filters = NULL, GroupByKey = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetAggregateConformancePackComplianceSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_aggregate_conformance_pack_compliance_summary_input(ConfigurationAggregatorName = ConfigurationAggregatorName, Filters = Filters, GroupByKey = GroupByKey, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_aggregate_conformance_pack_compliance_summary_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_aggregate_conformance_pack_compliance_summary <- configservice_get_aggregate_conformance_pack_compliance_summary

#' Returns the resource counts across accounts and regions that are present
#' in your Config aggregator
#'
#' @description
#' Returns the resource counts across accounts and regions that are present in your Config aggregator. You can request the resource counts by providing filters and GroupByKey.
#'
#' See [https://paws-r.github.io/docs/configservice/get_aggregate_discovered_resource_counts.html](https://paws-r.github.io/docs/configservice/get_aggregate_discovered_resource_counts.html) for full documentation.
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param Filters Filters the results based on the `ResourceCountFilters` object.
#' @param GroupByKey The key to group the resource counts.
#' @param Limit The maximum number of GroupedResourceCount objects returned on each
#' page. The default is 1000. You cannot specify a number greater than
#' 1000. If you specify 0, Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_get_aggregate_discovered_resource_counts
configservice_get_aggregate_discovered_resource_counts <- function(ConfigurationAggregatorName, Filters = NULL, GroupByKey = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetAggregateDiscoveredResourceCounts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_aggregate_discovered_resource_counts_input(ConfigurationAggregatorName = ConfigurationAggregatorName, Filters = Filters, GroupByKey = GroupByKey, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_aggregate_discovered_resource_counts_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_aggregate_discovered_resource_counts <- configservice_get_aggregate_discovered_resource_counts

#' Returns configuration item that is aggregated for your specific resource
#' in a specific source account and region
#'
#' @description
#' Returns configuration item that is aggregated for your specific resource in a specific source account and region.
#'
#' See [https://paws-r.github.io/docs/configservice/get_aggregate_resource_config.html](https://paws-r.github.io/docs/configservice/get_aggregate_resource_config.html) for full documentation.
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param ResourceIdentifier &#91;required&#93; An object that identifies aggregate resource.
#'
#' @keywords internal
#'
#' @rdname configservice_get_aggregate_resource_config
configservice_get_aggregate_resource_config <- function(ConfigurationAggregatorName, ResourceIdentifier) {
  op <- new_operation(
    name = "GetAggregateResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_aggregate_resource_config_input(ConfigurationAggregatorName = ConfigurationAggregatorName, ResourceIdentifier = ResourceIdentifier)
  output <- .configservice$get_aggregate_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_aggregate_resource_config <- configservice_get_aggregate_resource_config

#' Returns the evaluation results for the specified Config rule
#'
#' @description
#' Returns the evaluation results for the specified Config rule. The results indicate which Amazon Web Services resources were evaluated by the rule, when each resource was last evaluated, and whether each resource complies with the rule.
#'
#' See [https://paws-r.github.io/docs/configservice/get_compliance_details_by_config_rule.html](https://paws-r.github.io/docs/configservice/get_compliance_details_by_config_rule.html) for full documentation.
#'
#' @param ConfigRuleName &#91;required&#93; The name of the Config rule for which you want compliance information.
#' @param ComplianceTypes Filters the results by compliance.
#' 
#' The allowed values are `COMPLIANT`, `NON_COMPLIANT`, and
#' `NOT_APPLICABLE`.
#' @param Limit The maximum number of evaluation results returned on each page. The
#' default is 10. You cannot specify a number greater than 100. If you
#' specify 0, Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_get_compliance_details_by_config_rule
configservice_get_compliance_details_by_config_rule <- function(ConfigRuleName, ComplianceTypes = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetComplianceDetailsByConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_compliance_details_by_config_rule_input(ConfigRuleName = ConfigRuleName, ComplianceTypes = ComplianceTypes, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_compliance_details_by_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_compliance_details_by_config_rule <- configservice_get_compliance_details_by_config_rule

#' Returns the evaluation results for the specified Amazon Web Services
#' resource
#'
#' @description
#' Returns the evaluation results for the specified Amazon Web Services resource. The results indicate which Config rules were used to evaluate the resource, when each rule was last used, and whether the resource complies with each rule.
#'
#' See [https://paws-r.github.io/docs/configservice/get_compliance_details_by_resource.html](https://paws-r.github.io/docs/configservice/get_compliance_details_by_resource.html) for full documentation.
#'
#' @param ResourceType &#91;required&#93; The type of the Amazon Web Services resource for which you want
#' compliance information.
#' @param ResourceId &#91;required&#93; The ID of the Amazon Web Services resource for which you want compliance
#' information.
#' @param ComplianceTypes Filters the results by compliance.
#' 
#' The allowed values are `COMPLIANT`, `NON_COMPLIANT`, and
#' `NOT_APPLICABLE`.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_get_compliance_details_by_resource
configservice_get_compliance_details_by_resource <- function(ResourceType, ResourceId, ComplianceTypes = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetComplianceDetailsByResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_compliance_details_by_resource_input(ResourceType = ResourceType, ResourceId = ResourceId, ComplianceTypes = ComplianceTypes, NextToken = NextToken)
  output <- .configservice$get_compliance_details_by_resource_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_compliance_details_by_resource <- configservice_get_compliance_details_by_resource

#' Returns the number of Config rules that are compliant and noncompliant,
#' up to a maximum of 25 for each
#'
#' @description
#' Returns the number of Config rules that are compliant and noncompliant, up to a maximum of 25 for each.
#'
#' See [https://paws-r.github.io/docs/configservice/get_compliance_summary_by_config_rule.html](https://paws-r.github.io/docs/configservice/get_compliance_summary_by_config_rule.html) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname configservice_get_compliance_summary_by_config_rule
configservice_get_compliance_summary_by_config_rule <- function() {
  op <- new_operation(
    name = "GetComplianceSummaryByConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_compliance_summary_by_config_rule_input()
  output <- .configservice$get_compliance_summary_by_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_compliance_summary_by_config_rule <- configservice_get_compliance_summary_by_config_rule

#' Returns the number of resources that are compliant and the number that
#' are noncompliant
#'
#' @description
#' Returns the number of resources that are compliant and the number that are noncompliant. You can specify one or more resource types to get these numbers for each resource type. The maximum number returned is 100.
#'
#' See [https://paws-r.github.io/docs/configservice/get_compliance_summary_by_resource_type.html](https://paws-r.github.io/docs/configservice/get_compliance_summary_by_resource_type.html) for full documentation.
#'
#' @param ResourceTypes Specify one or more resource types to get the number of resources that
#' are compliant and the number that are noncompliant for each resource
#' type.
#' 
#' For this request, you can specify an Amazon Web Services resource type
#' such as `AWS::EC2::Instance`. You can specify that the resource type is
#' an Amazon Web Services account by specifying `AWS::::Account`.
#'
#' @keywords internal
#'
#' @rdname configservice_get_compliance_summary_by_resource_type
configservice_get_compliance_summary_by_resource_type <- function(ResourceTypes = NULL) {
  op <- new_operation(
    name = "GetComplianceSummaryByResourceType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_compliance_summary_by_resource_type_input(ResourceTypes = ResourceTypes)
  output <- .configservice$get_compliance_summary_by_resource_type_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_compliance_summary_by_resource_type <- configservice_get_compliance_summary_by_resource_type

#' Returns compliance details of a conformance pack for all Amazon Web
#' Services resources that are monitered by conformance pack
#'
#' @description
#' Returns compliance details of a conformance pack for all Amazon Web Services resources that are monitered by conformance pack.
#'
#' See [https://paws-r.github.io/docs/configservice/get_conformance_pack_compliance_details.html](https://paws-r.github.io/docs/configservice/get_conformance_pack_compliance_details.html) for full documentation.
#'
#' @param ConformancePackName &#91;required&#93; Name of the conformance pack.
#' @param Filters A `ConformancePackEvaluationFilters` object.
#' @param Limit The maximum number of evaluation results returned on each page. If you
#' do no specify a number, Config uses the default. The default is 100.
#' @param NextToken The `nextToken` string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_get_conformance_pack_compliance_details
configservice_get_conformance_pack_compliance_details <- function(ConformancePackName, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetConformancePackComplianceDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_conformance_pack_compliance_details_input(ConformancePackName = ConformancePackName, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_conformance_pack_compliance_details_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_conformance_pack_compliance_details <- configservice_get_conformance_pack_compliance_details

#' Returns compliance details for the conformance pack based on the
#' cumulative compliance results of all the rules in that conformance pack
#'
#' @description
#' Returns compliance details for the conformance pack based on the cumulative compliance results of all the rules in that conformance pack.
#'
#' See [https://paws-r.github.io/docs/configservice/get_conformance_pack_compliance_summary.html](https://paws-r.github.io/docs/configservice/get_conformance_pack_compliance_summary.html) for full documentation.
#'
#' @param ConformancePackNames &#91;required&#93; Names of conformance packs.
#' @param Limit The maximum number of conformance packs returned on each page.
#' @param NextToken The nextToken string returned on a previous page that you use to get the
#' next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_get_conformance_pack_compliance_summary
configservice_get_conformance_pack_compliance_summary <- function(ConformancePackNames, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetConformancePackComplianceSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_conformance_pack_compliance_summary_input(ConformancePackNames = ConformancePackNames, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_conformance_pack_compliance_summary_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_conformance_pack_compliance_summary <- configservice_get_conformance_pack_compliance_summary

#' Returns the policy definition containing the logic for your Config
#' Custom Policy rule
#'
#' @description
#' Returns the policy definition containing the logic for your Config Custom Policy rule.
#'
#' See [https://paws-r.github.io/docs/configservice/get_custom_rule_policy.html](https://paws-r.github.io/docs/configservice/get_custom_rule_policy.html) for full documentation.
#'
#' @param ConfigRuleName The name of your Config Custom Policy rule.
#'
#' @keywords internal
#'
#' @rdname configservice_get_custom_rule_policy
configservice_get_custom_rule_policy <- function(ConfigRuleName = NULL) {
  op <- new_operation(
    name = "GetCustomRulePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_custom_rule_policy_input(ConfigRuleName = ConfigRuleName)
  output <- .configservice$get_custom_rule_policy_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_custom_rule_policy <- configservice_get_custom_rule_policy

#' Returns the resource types, the number of each resource type, and the
#' total number of resources that Config is recording in this region for
#' your Amazon Web Services account
#'
#' @description
#' Returns the resource types, the number of each resource type, and the total number of resources that Config is recording in this region for your Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/configservice/get_discovered_resource_counts.html](https://paws-r.github.io/docs/configservice/get_discovered_resource_counts.html) for full documentation.
#'
#' @param resourceTypes The comma-separated list that specifies the resource types that you want
#' Config to return (for example, `"AWS::EC2::Instance"`,
#' `"AWS::IAM::User"`).
#' 
#' If a value for `resourceTypes` is not specified, Config returns all
#' resource types that Config is recording in the region for your account.
#' 
#' If the configuration recorder is turned off, Config returns an empty
#' list of ResourceCount objects. If the configuration recorder is not
#' recording a specific resource type (for example, S3 buckets), that
#' resource type is not returned in the list of ResourceCount objects.
#' @param limit The maximum number of ResourceCount objects returned on each page. The
#' default is 100. You cannot specify a number greater than 100. If you
#' specify 0, Config uses the default.
#' @param nextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_get_discovered_resource_counts
configservice_get_discovered_resource_counts <- function(resourceTypes = NULL, limit = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "GetDiscoveredResourceCounts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_discovered_resource_counts_input(resourceTypes = resourceTypes, limit = limit, nextToken = nextToken)
  output <- .configservice$get_discovered_resource_counts_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_discovered_resource_counts <- configservice_get_discovered_resource_counts

#' Returns detailed status for each member account within an organization
#' for a given organization Config rule
#'
#' @description
#' Returns detailed status for each member account within an organization for a given organization Config rule.
#'
#' See [https://paws-r.github.io/docs/configservice/get_organization_config_rule_detailed_status.html](https://paws-r.github.io/docs/configservice/get_organization_config_rule_detailed_status.html) for full documentation.
#'
#' @param OrganizationConfigRuleName &#91;required&#93; The name of your organization Config rule for which you want status
#' details for member accounts.
#' @param Filters A `StatusDetailFilters` object.
#' @param Limit The maximum number of `OrganizationConfigRuleDetailedStatus` returned on
#' each page. If you do not specify a number, Config uses the default. The
#' default is 100.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_get_organization_config_rule_detailed_status
configservice_get_organization_config_rule_detailed_status <- function(OrganizationConfigRuleName, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetOrganizationConfigRuleDetailedStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_organization_config_rule_detailed_status_input(OrganizationConfigRuleName = OrganizationConfigRuleName, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_organization_config_rule_detailed_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_organization_config_rule_detailed_status <- configservice_get_organization_config_rule_detailed_status

#' Returns detailed status for each member account within an organization
#' for a given organization conformance pack
#'
#' @description
#' Returns detailed status for each member account within an organization for a given organization conformance pack.
#'
#' See [https://paws-r.github.io/docs/configservice/get_organization_conformance_pack_detailed_status.html](https://paws-r.github.io/docs/configservice/get_organization_conformance_pack_detailed_status.html) for full documentation.
#'
#' @param OrganizationConformancePackName &#91;required&#93; The name of organization conformance pack for which you want status
#' details for member accounts.
#' @param Filters An `OrganizationResourceDetailedStatusFilters` object.
#' @param Limit The maximum number of `OrganizationConformancePackDetailedStatuses`
#' returned on each page. If you do not specify a number, Config uses the
#' default. The default is 100.
#' @param NextToken The nextToken string returned on a previous page that you use to get the
#' next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_get_organi_confor_pack_detail_status
configservice_get_organization_conformance_pack_detailed_status <- function(OrganizationConformancePackName, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetOrganizationConformancePackDetailedStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_organization_conformance_pack_detailed_status_input(OrganizationConformancePackName = OrganizationConformancePackName, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$get_organization_conformance_pack_detailed_status_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_organization_conformance_pack_detailed_status <- configservice_get_organization_conformance_pack_detailed_status

#' Returns the policy definition containing the logic for your organization
#' Config Custom Policy rule
#'
#' @description
#' Returns the policy definition containing the logic for your organization Config Custom Policy rule.
#'
#' See [https://paws-r.github.io/docs/configservice/get_organization_custom_rule_policy.html](https://paws-r.github.io/docs/configservice/get_organization_custom_rule_policy.html) for full documentation.
#'
#' @param OrganizationConfigRuleName &#91;required&#93; The name of your organization Config Custom Policy rule.
#'
#' @keywords internal
#'
#' @rdname configservice_get_organization_custom_rule_policy
configservice_get_organization_custom_rule_policy <- function(OrganizationConfigRuleName) {
  op <- new_operation(
    name = "GetOrganizationCustomRulePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_organization_custom_rule_policy_input(OrganizationConfigRuleName = OrganizationConfigRuleName)
  output <- .configservice$get_organization_custom_rule_policy_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_organization_custom_rule_policy <- configservice_get_organization_custom_rule_policy

#' Returns a list of ConfigurationItems for the specified resource
#'
#' @description
#' Returns a list of `ConfigurationItems` for the specified resource. The list contains details about each state of the resource during the specified time interval. If you specified a retention period to retain your `ConfigurationItems` between a minimum of 30 days and a maximum of 7 years (2557 days), Config returns the `ConfigurationItems` for the specified retention period.
#'
#' See [https://paws-r.github.io/docs/configservice/get_resource_config_history.html](https://paws-r.github.io/docs/configservice/get_resource_config_history.html) for full documentation.
#'
#' @param resourceType &#91;required&#93; The resource type.
#' @param resourceId &#91;required&#93; The ID of the resource (for example., `sg-xxxxxx`).
#' @param laterTime The time stamp that indicates a later time. If not specified, current
#' time is taken.
#' @param earlierTime The time stamp that indicates an earlier time. If not specified, the
#' action returns paginated results that contain configuration items that
#' start when the first configuration item was recorded.
#' @param chronologicalOrder The chronological order for configuration items listed. By default, the
#' results are listed in reverse chronological order.
#' @param limit The maximum number of configuration items returned on each page. The
#' default is 10. You cannot specify a number greater than 100. If you
#' specify 0, Config uses the default.
#' @param nextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_get_resource_config_history
configservice_get_resource_config_history <- function(resourceType, resourceId, laterTime = NULL, earlierTime = NULL, chronologicalOrder = NULL, limit = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "GetResourceConfigHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_resource_config_history_input(resourceType = resourceType, resourceId = resourceId, laterTime = laterTime, earlierTime = earlierTime, chronologicalOrder = chronologicalOrder, limit = limit, nextToken = nextToken)
  output <- .configservice$get_resource_config_history_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_resource_config_history <- configservice_get_resource_config_history

#' Returns the details of a specific stored query
#'
#' @description
#' Returns the details of a specific stored query.
#'
#' See [https://paws-r.github.io/docs/configservice/get_stored_query.html](https://paws-r.github.io/docs/configservice/get_stored_query.html) for full documentation.
#'
#' @param QueryName &#91;required&#93; The name of the query.
#'
#' @keywords internal
#'
#' @rdname configservice_get_stored_query
configservice_get_stored_query <- function(QueryName) {
  op <- new_operation(
    name = "GetStoredQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$get_stored_query_input(QueryName = QueryName)
  output <- .configservice$get_stored_query_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$get_stored_query <- configservice_get_stored_query

#' Accepts a resource type and returns a list of resource identifiers that
#' are aggregated for a specific resource type across accounts and regions
#'
#' @description
#' Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom resource name, source account, and source region. You can narrow the results to include only resources that have specific resource IDs, or a resource name, or source account ID, or source region.
#'
#' See [https://paws-r.github.io/docs/configservice/list_aggregate_discovered_resources.html](https://paws-r.github.io/docs/configservice/list_aggregate_discovered_resources.html) for full documentation.
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param ResourceType &#91;required&#93; The type of resources that you want Config to list in the response.
#' @param Filters Filters the results based on the `ResourceFilters` object.
#' @param Limit The maximum number of resource identifiers returned on each page. You
#' cannot specify a number greater than 100. If you specify 0, Config uses
#' the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_list_aggregate_discovered_resources
configservice_list_aggregate_discovered_resources <- function(ConfigurationAggregatorName, ResourceType, Filters = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAggregateDiscoveredResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$list_aggregate_discovered_resources_input(ConfigurationAggregatorName = ConfigurationAggregatorName, ResourceType = ResourceType, Filters = Filters, Limit = Limit, NextToken = NextToken)
  output <- .configservice$list_aggregate_discovered_resources_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$list_aggregate_discovered_resources <- configservice_list_aggregate_discovered_resources

#' Returns a list of conformance pack compliance scores
#'
#' @description
#' Returns a list of conformance pack compliance scores. A compliance score is the percentage of the number of compliant rule-resource combinations in a conformance pack compared to the number of total possible rule-resource combinations in the conformance pack. This metric provides you with a high-level view of the compliance state of your conformance packs, and can be used to identify, investigate, and understand the level of compliance in your conformance packs.
#'
#' See [https://paws-r.github.io/docs/configservice/list_conformance_pack_compliance_scores.html](https://paws-r.github.io/docs/configservice/list_conformance_pack_compliance_scores.html) for full documentation.
#'
#' @param Filters Filters the results based on the
#' `ConformancePackComplianceScoresFilters`.
#' @param SortOrder Determines the order in which conformance pack compliance scores are
#' sorted. Either in ascending or descending order.
#' 
#' Conformance packs with a compliance score of `INSUFFICIENT_DATA` will be
#' first when sorting by ascending order and last when sorting by
#' descending order.
#' @param SortBy Sorts your conformance pack compliance scores in either ascending or
#' descending order, depending on `SortOrder`.
#' 
#' By default, conformance pack compliance scores are sorted in ascending
#' order by compliance score and alphabetically by name of the conformance
#' pack if there is more than one conformance pack with the same compliance
#' score.
#' @param Limit The maximum number of conformance pack compliance scores returned on
#' each page.
#' @param NextToken The `nextToken` string in a prior request that you can use to get the
#' paginated response for next set of conformance pack compliance scores.
#'
#' @keywords internal
#'
#' @rdname configservice_list_conformance_pack_compliance_scores
configservice_list_conformance_pack_compliance_scores <- function(Filters = NULL, SortOrder = NULL, SortBy = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConformancePackComplianceScores",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$list_conformance_pack_compliance_scores_input(Filters = Filters, SortOrder = SortOrder, SortBy = SortBy, Limit = Limit, NextToken = NextToken)
  output <- .configservice$list_conformance_pack_compliance_scores_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$list_conformance_pack_compliance_scores <- configservice_list_conformance_pack_compliance_scores

#' Accepts a resource type and returns a list of resource identifiers for
#' the resources of that type
#'
#' @description
#' Accepts a resource type and returns a list of resource identifiers for the resources of that type. A resource identifier includes the resource type, ID, and (if available) the custom resource name. The results consist of resources that Config has discovered, including those that Config is not currently recording. You can narrow the results to include only resources that have specific resource IDs or a resource name.
#'
#' See [https://paws-r.github.io/docs/configservice/list_discovered_resources.html](https://paws-r.github.io/docs/configservice/list_discovered_resources.html) for full documentation.
#'
#' @param resourceType &#91;required&#93; The type of resources that you want Config to list in the response.
#' @param resourceIds The IDs of only those resources that you want Config to list in the
#' response. If you do not specify this parameter, Config lists all
#' resources of the specified type that it has discovered.
#' @param resourceName The custom name of only those resources that you want Config to list in
#' the response. If you do not specify this parameter, Config lists all
#' resources of the specified type that it has discovered.
#' @param limit The maximum number of resource identifiers returned on each page. The
#' default is 100. You cannot specify a number greater than 100. If you
#' specify 0, Config uses the default.
#' @param includeDeletedResources Specifies whether Config includes deleted resources in the results. By
#' default, deleted resources are not included.
#' @param nextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_list_discovered_resources
configservice_list_discovered_resources <- function(resourceType, resourceIds = NULL, resourceName = NULL, limit = NULL, includeDeletedResources = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListDiscoveredResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$list_discovered_resources_input(resourceType = resourceType, resourceIds = resourceIds, resourceName = resourceName, limit = limit, includeDeletedResources = includeDeletedResources, nextToken = nextToken)
  output <- .configservice$list_discovered_resources_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$list_discovered_resources <- configservice_list_discovered_resources

#' Lists the stored queries for a single Amazon Web Services account and a
#' single Amazon Web Services Region
#'
#' @description
#' Lists the stored queries for a single Amazon Web Services account and a single Amazon Web Services Region. The default is 100.
#'
#' See [https://paws-r.github.io/docs/configservice/list_stored_queries.html](https://paws-r.github.io/docs/configservice/list_stored_queries.html) for full documentation.
#'
#' @param NextToken The nextToken string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#' @param MaxResults The maximum number of results to be returned with a single call.
#'
#' @keywords internal
#'
#' @rdname configservice_list_stored_queries
configservice_list_stored_queries <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListStoredQueries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$list_stored_queries_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .configservice$list_stored_queries_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$list_stored_queries <- configservice_list_stored_queries

#' List the tags for Config resource
#'
#' @description
#' List the tags for Config resource.
#'
#' See [https://paws-r.github.io/docs/configservice/list_tags_for_resource.html](https://paws-r.github.io/docs/configservice/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags. Currently, the supported resources are `ConfigRule`,
#' `ConfigurationAggregator` and `AggregatorAuthorization`.
#' @param Limit The maximum number of tags returned on each page. The limit maximum is
#' 50. You cannot specify a number greater than 50. If you specify 0,
#' Config uses the default.
#' @param NextToken The `nextToken` string returned on a previous page that you use to get
#' the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_list_tags_for_resource
configservice_list_tags_for_resource <- function(ResourceArn, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$list_tags_for_resource_input(ResourceArn = ResourceArn, Limit = Limit, NextToken = NextToken)
  output <- .configservice$list_tags_for_resource_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$list_tags_for_resource <- configservice_list_tags_for_resource

#' Authorizes the aggregator account and region to collect data from the
#' source account and region
#'
#' @description
#' Authorizes the aggregator account and region to collect data from the source account and region.
#'
#' See [https://paws-r.github.io/docs/configservice/put_aggregation_authorization.html](https://paws-r.github.io/docs/configservice/put_aggregation_authorization.html) for full documentation.
#'
#' @param AuthorizedAccountId &#91;required&#93; The 12-digit account ID of the account authorized to aggregate data.
#' @param AuthorizedAwsRegion &#91;required&#93; The region authorized to collect aggregated data.
#' @param Tags An array of tag object.
#'
#' @keywords internal
#'
#' @rdname configservice_put_aggregation_authorization
configservice_put_aggregation_authorization <- function(AuthorizedAccountId, AuthorizedAwsRegion, Tags = NULL) {
  op <- new_operation(
    name = "PutAggregationAuthorization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_aggregation_authorization_input(AuthorizedAccountId = AuthorizedAccountId, AuthorizedAwsRegion = AuthorizedAwsRegion, Tags = Tags)
  output <- .configservice$put_aggregation_authorization_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_aggregation_authorization <- configservice_put_aggregation_authorization

#' Adds or updates an Config rule to evaluate if your Amazon Web Services
#' resources comply with your desired configurations
#'
#' @description
#' Adds or updates an Config rule to evaluate if your Amazon Web Services resources comply with your desired configurations. For information on how many Config rules you can have per account, see [**Service Limits**](https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html) in the *Config Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/configservice/put_config_rule.html](https://paws-r.github.io/docs/configservice/put_config_rule.html) for full documentation.
#'
#' @param ConfigRule &#91;required&#93; The rule that you want to add to your account.
#' @param Tags An array of tag object.
#'
#' @keywords internal
#'
#' @rdname configservice_put_config_rule
configservice_put_config_rule <- function(ConfigRule, Tags = NULL) {
  op <- new_operation(
    name = "PutConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_config_rule_input(ConfigRule = ConfigRule, Tags = Tags)
  output <- .configservice$put_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_config_rule <- configservice_put_config_rule

#' Creates and updates the configuration aggregator with the selected
#' source accounts and regions
#'
#' @description
#' Creates and updates the configuration aggregator with the selected source accounts and regions. The source account can be individual account(s) or an organization.
#'
#' See [https://paws-r.github.io/docs/configservice/put_configuration_aggregator.html](https://paws-r.github.io/docs/configservice/put_configuration_aggregator.html) for full documentation.
#'
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param AccountAggregationSources A list of AccountAggregationSource object.
#' @param OrganizationAggregationSource An OrganizationAggregationSource object.
#' @param Tags An array of tag object.
#'
#' @keywords internal
#'
#' @rdname configservice_put_configuration_aggregator
configservice_put_configuration_aggregator <- function(ConfigurationAggregatorName, AccountAggregationSources = NULL, OrganizationAggregationSource = NULL, Tags = NULL) {
  op <- new_operation(
    name = "PutConfigurationAggregator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_configuration_aggregator_input(ConfigurationAggregatorName = ConfigurationAggregatorName, AccountAggregationSources = AccountAggregationSources, OrganizationAggregationSource = OrganizationAggregationSource, Tags = Tags)
  output <- .configservice$put_configuration_aggregator_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_configuration_aggregator <- configservice_put_configuration_aggregator

#' Creates a new configuration recorder to record the selected resource
#' configurations
#'
#' @description
#' Creates a new configuration recorder to record the selected resource configurations.
#'
#' See [https://paws-r.github.io/docs/configservice/put_configuration_recorder.html](https://paws-r.github.io/docs/configservice/put_configuration_recorder.html) for full documentation.
#'
#' @param ConfigurationRecorder &#91;required&#93; The configuration recorder object that records each configuration change
#' made to the resources.
#'
#' @keywords internal
#'
#' @rdname configservice_put_configuration_recorder
configservice_put_configuration_recorder <- function(ConfigurationRecorder) {
  op <- new_operation(
    name = "PutConfigurationRecorder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_configuration_recorder_input(ConfigurationRecorder = ConfigurationRecorder)
  output <- .configservice$put_configuration_recorder_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_configuration_recorder <- configservice_put_configuration_recorder

#' Creates or updates a conformance pack
#'
#' @description
#' Creates or updates a conformance pack. A conformance pack is a collection of Config rules that can be easily deployed in an account and a region and across Amazon Web Services Organization. For information on how many conformance packs you can have per account, see [**Service Limits**](https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html) in the Config Developer Guide.
#'
#' See [https://paws-r.github.io/docs/configservice/put_conformance_pack.html](https://paws-r.github.io/docs/configservice/put_conformance_pack.html) for full documentation.
#'
#' @param ConformancePackName &#91;required&#93; Name of the conformance pack you want to create.
#' @param TemplateS3Uri Location of file containing the template body
#' (`s3://bucketname/prefix`). The uri must point to the conformance pack
#' template (max size: 300 KB) that is located in an Amazon S3 bucket in
#' the same region as the conformance pack.
#' 
#' You must have access to read Amazon S3 bucket.
#' @param TemplateBody A string containing full conformance pack template body. Structure
#' containing the template body with a minimum length of 1 byte and a
#' maximum length of 51,200 bytes.
#' 
#' You can only use a YAML template with two resource types: Config rule
#' (`AWS::Config::ConfigRule`) and a remediation action
#' (`AWS::Config::RemediationConfiguration`).
#' @param DeliveryS3Bucket The name of the Amazon S3 bucket where Config stores conformance pack
#' templates.
#' 
#' This field is optional.
#' @param DeliveryS3KeyPrefix The prefix for the Amazon S3 bucket.
#' 
#' This field is optional.
#' @param ConformancePackInputParameters A list of `ConformancePackInputParameter` objects.
#'
#' @keywords internal
#'
#' @rdname configservice_put_conformance_pack
configservice_put_conformance_pack <- function(ConformancePackName, TemplateS3Uri = NULL, TemplateBody = NULL, DeliveryS3Bucket = NULL, DeliveryS3KeyPrefix = NULL, ConformancePackInputParameters = NULL) {
  op <- new_operation(
    name = "PutConformancePack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_conformance_pack_input(ConformancePackName = ConformancePackName, TemplateS3Uri = TemplateS3Uri, TemplateBody = TemplateBody, DeliveryS3Bucket = DeliveryS3Bucket, DeliveryS3KeyPrefix = DeliveryS3KeyPrefix, ConformancePackInputParameters = ConformancePackInputParameters)
  output <- .configservice$put_conformance_pack_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_conformance_pack <- configservice_put_conformance_pack

#' Creates a delivery channel object to deliver configuration information
#' to an Amazon S3 bucket and Amazon SNS topic
#'
#' @description
#' Creates a delivery channel object to deliver configuration information to an Amazon S3 bucket and Amazon SNS topic.
#'
#' See [https://paws-r.github.io/docs/configservice/put_delivery_channel.html](https://paws-r.github.io/docs/configservice/put_delivery_channel.html) for full documentation.
#'
#' @param DeliveryChannel &#91;required&#93; The configuration delivery channel object that delivers the
#' configuration information to an Amazon S3 bucket and to an Amazon SNS
#' topic.
#'
#' @keywords internal
#'
#' @rdname configservice_put_delivery_channel
configservice_put_delivery_channel <- function(DeliveryChannel) {
  op <- new_operation(
    name = "PutDeliveryChannel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_delivery_channel_input(DeliveryChannel = DeliveryChannel)
  output <- .configservice$put_delivery_channel_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_delivery_channel <- configservice_put_delivery_channel

#' Used by an Lambda function to deliver evaluation results to Config
#'
#' @description
#' Used by an Lambda function to deliver evaluation results to Config. This action is required in every Lambda function that is invoked by an Config rule.
#'
#' See [https://paws-r.github.io/docs/configservice/put_evaluations.html](https://paws-r.github.io/docs/configservice/put_evaluations.html) for full documentation.
#'
#' @param Evaluations The assessments that the Lambda function performs. Each evaluation
#' identifies an Amazon Web Services resource and indicates whether it
#' complies with the Config rule that invokes the Lambda function.
#' @param ResultToken &#91;required&#93; An encrypted token that associates an evaluation with an Config rule.
#' Identifies the rule and the event that triggered the evaluation.
#' @param TestMode Use this parameter to specify a test run for
#' [`put_evaluations`][configservice_put_evaluations]. You can verify
#' whether your Lambda function will deliver evaluation results to Config.
#' No updates occur to your existing evaluations, and evaluation results
#' are not sent to Config.
#' 
#' When `TestMode` is `true`,
#' [`put_evaluations`][configservice_put_evaluations] doesn't require a
#' valid value for the `ResultToken` parameter, but the value cannot be
#' null.
#'
#' @keywords internal
#'
#' @rdname configservice_put_evaluations
configservice_put_evaluations <- function(Evaluations = NULL, ResultToken, TestMode = NULL) {
  op <- new_operation(
    name = "PutEvaluations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_evaluations_input(Evaluations = Evaluations, ResultToken = ResultToken, TestMode = TestMode)
  output <- .configservice$put_evaluations_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_evaluations <- configservice_put_evaluations

#' Add or updates the evaluations for process checks
#'
#' @description
#' Add or updates the evaluations for process checks. This API checks if the rule is a process check when the name of the Config rule is provided.
#'
#' See [https://paws-r.github.io/docs/configservice/put_external_evaluation.html](https://paws-r.github.io/docs/configservice/put_external_evaluation.html) for full documentation.
#'
#' @param ConfigRuleName &#91;required&#93; The name of the Config rule.
#' @param ExternalEvaluation &#91;required&#93; An `ExternalEvaluation` object that provides details about compliance.
#'
#' @keywords internal
#'
#' @rdname configservice_put_external_evaluation
configservice_put_external_evaluation <- function(ConfigRuleName, ExternalEvaluation) {
  op <- new_operation(
    name = "PutExternalEvaluation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_external_evaluation_input(ConfigRuleName = ConfigRuleName, ExternalEvaluation = ExternalEvaluation)
  output <- .configservice$put_external_evaluation_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_external_evaluation <- configservice_put_external_evaluation

#' Adds or updates an Config rule for your entire organization to evaluate
#' if your Amazon Web Services resources comply with your desired
#' configurations
#'
#' @description
#' Adds or updates an Config rule for your entire organization to evaluate if your Amazon Web Services resources comply with your desired configurations. For information on how many organization Config rules you can have per account, see [**Service Limits**](https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html) in the *Config Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/configservice/put_organization_config_rule.html](https://paws-r.github.io/docs/configservice/put_organization_config_rule.html) for full documentation.
#'
#' @param OrganizationConfigRuleName &#91;required&#93; The name that you assign to an organization Config rule.
#' @param OrganizationManagedRuleMetadata An `OrganizationManagedRuleMetadata` object. This object specifies
#' organization managed rule metadata such as resource type and ID of
#' Amazon Web Services resource along with the rule identifier. It also
#' provides the frequency with which you want Config to run evaluations for
#' the rule if the trigger type is periodic.
#' @param OrganizationCustomRuleMetadata An `OrganizationCustomRuleMetadata` object. This object specifies
#' organization custom rule metadata such as resource type, resource ID of
#' Amazon Web Services resource, Lambda function ARN, and organization
#' trigger types that trigger Config to evaluate your Amazon Web Services
#' resources against a rule. It also provides the frequency with which you
#' want Config to run evaluations for the rule if the trigger type is
#' periodic.
#' @param ExcludedAccounts A comma-separated list of accounts that you want to exclude from an
#' organization Config rule.
#' @param OrganizationCustomPolicyRuleMetadata An `OrganizationCustomPolicyRuleMetadata` object. This object specifies
#' metadata for your organization's Config Custom Policy rule. The metadata
#' includes the runtime system in use, which accounts have debug logging
#' enabled, and other custom rule metadata, such as resource type, resource
#' ID of Amazon Web Services resource, and organization trigger types that
#' initiate Config to evaluate Amazon Web Services resources against a
#' rule.
#'
#' @keywords internal
#'
#' @rdname configservice_put_organization_config_rule
configservice_put_organization_config_rule <- function(OrganizationConfigRuleName, OrganizationManagedRuleMetadata = NULL, OrganizationCustomRuleMetadata = NULL, ExcludedAccounts = NULL, OrganizationCustomPolicyRuleMetadata = NULL) {
  op <- new_operation(
    name = "PutOrganizationConfigRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_organization_config_rule_input(OrganizationConfigRuleName = OrganizationConfigRuleName, OrganizationManagedRuleMetadata = OrganizationManagedRuleMetadata, OrganizationCustomRuleMetadata = OrganizationCustomRuleMetadata, ExcludedAccounts = ExcludedAccounts, OrganizationCustomPolicyRuleMetadata = OrganizationCustomPolicyRuleMetadata)
  output <- .configservice$put_organization_config_rule_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_organization_config_rule <- configservice_put_organization_config_rule

#' Deploys conformance packs across member accounts in an Amazon Web
#' Services Organization
#'
#' @description
#' Deploys conformance packs across member accounts in an Amazon Web Services Organization. For information on how many organization conformance packs and how many Config rules you can have per account, see [**Service Limits**](https://docs.aws.amazon.com/config/latest/developerguide/configlimits.html) in the Config Developer Guide.
#'
#' See [https://paws-r.github.io/docs/configservice/put_organization_conformance_pack.html](https://paws-r.github.io/docs/configservice/put_organization_conformance_pack.html) for full documentation.
#'
#' @param OrganizationConformancePackName &#91;required&#93; Name of the organization conformance pack you want to create.
#' @param TemplateS3Uri Location of file containing the template body. The uri must point to the
#' conformance pack template (max size: 300 KB).
#' 
#' You must have access to read Amazon S3 bucket.
#' @param TemplateBody A string containing full conformance pack template body. Structure
#' containing the template body with a minimum length of 1 byte and a
#' maximum length of 51,200 bytes.
#' @param DeliveryS3Bucket The name of the Amazon S3 bucket where Config stores conformance pack
#' templates.
#' 
#' This field is optional. If used, it must be prefixed with
#' `awsconfigconforms`.
#' @param DeliveryS3KeyPrefix The prefix for the Amazon S3 bucket.
#' 
#' This field is optional.
#' @param ConformancePackInputParameters A list of `ConformancePackInputParameter` objects.
#' @param ExcludedAccounts A list of Amazon Web Services accounts to be excluded from an
#' organization conformance pack while deploying a conformance pack.
#'
#' @keywords internal
#'
#' @rdname configservice_put_organization_conformance_pack
configservice_put_organization_conformance_pack <- function(OrganizationConformancePackName, TemplateS3Uri = NULL, TemplateBody = NULL, DeliveryS3Bucket = NULL, DeliveryS3KeyPrefix = NULL, ConformancePackInputParameters = NULL, ExcludedAccounts = NULL) {
  op <- new_operation(
    name = "PutOrganizationConformancePack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_organization_conformance_pack_input(OrganizationConformancePackName = OrganizationConformancePackName, TemplateS3Uri = TemplateS3Uri, TemplateBody = TemplateBody, DeliveryS3Bucket = DeliveryS3Bucket, DeliveryS3KeyPrefix = DeliveryS3KeyPrefix, ConformancePackInputParameters = ConformancePackInputParameters, ExcludedAccounts = ExcludedAccounts)
  output <- .configservice$put_organization_conformance_pack_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_organization_conformance_pack <- configservice_put_organization_conformance_pack

#' Adds or updates the remediation configuration with a specific Config
#' rule with the selected target or action
#'
#' @description
#' Adds or updates the remediation configuration with a specific Config rule with the selected target or action. The API creates the `RemediationConfiguration` object for the Config rule. The Config rule must already exist for you to add a remediation configuration. The target (SSM document) must exist and have permissions to use the target.
#'
#' See [https://paws-r.github.io/docs/configservice/put_remediation_configurations.html](https://paws-r.github.io/docs/configservice/put_remediation_configurations.html) for full documentation.
#'
#' @param RemediationConfigurations &#91;required&#93; A list of remediation configuration objects.
#'
#' @keywords internal
#'
#' @rdname configservice_put_remediation_configurations
configservice_put_remediation_configurations <- function(RemediationConfigurations) {
  op <- new_operation(
    name = "PutRemediationConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_remediation_configurations_input(RemediationConfigurations = RemediationConfigurations)
  output <- .configservice$put_remediation_configurations_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_remediation_configurations <- configservice_put_remediation_configurations

#' A remediation exception is when a specific resource is no longer
#' considered for auto-remediation
#'
#' @description
#' A remediation exception is when a specific resource is no longer considered for auto-remediation. This API adds a new exception or updates an existing exception for a specific resource with a specific Config rule.
#'
#' See [https://paws-r.github.io/docs/configservice/put_remediation_exceptions.html](https://paws-r.github.io/docs/configservice/put_remediation_exceptions.html) for full documentation.
#'
#' @param ConfigRuleName &#91;required&#93; The name of the Config rule for which you want to create remediation
#' exception.
#' @param ResourceKeys &#91;required&#93; An exception list of resource exception keys to be processed with the
#' current request. Config adds exception for each resource key. For
#' example, Config adds 3 exceptions for 3 resource keys.
#' @param Message The message contains an explanation of the exception.
#' @param ExpirationTime The exception is automatically deleted after the expiration date.
#'
#' @keywords internal
#'
#' @rdname configservice_put_remediation_exceptions
configservice_put_remediation_exceptions <- function(ConfigRuleName, ResourceKeys, Message = NULL, ExpirationTime = NULL) {
  op <- new_operation(
    name = "PutRemediationExceptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_remediation_exceptions_input(ConfigRuleName = ConfigRuleName, ResourceKeys = ResourceKeys, Message = Message, ExpirationTime = ExpirationTime)
  output <- .configservice$put_remediation_exceptions_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_remediation_exceptions <- configservice_put_remediation_exceptions

#' Records the configuration state for the resource provided in the request
#'
#' @description
#' Records the configuration state for the resource provided in the request. The configuration state of a resource is represented in Config as Configuration Items. Once this API records the configuration item, you can retrieve the list of configuration items for the custom resource type using existing Config APIs.
#'
#' See [https://paws-r.github.io/docs/configservice/put_resource_config.html](https://paws-r.github.io/docs/configservice/put_resource_config.html) for full documentation.
#'
#' @param ResourceType &#91;required&#93; The type of the resource. The custom resource type must be registered
#' with CloudFormation.
#' 
#' You cannot use the organization names “amzn”, “amazon”, “alexa”,
#' “custom” with custom resource types. It is the first part of the
#' ResourceType up to the first ::.
#' @param SchemaVersionId &#91;required&#93; Version of the schema registered for the ResourceType in CloudFormation.
#' @param ResourceId &#91;required&#93; Unique identifier of the resource.
#' @param ResourceName Name of the resource.
#' @param Configuration &#91;required&#93; The configuration object of the resource in valid JSON format. It must
#' match the schema registered with CloudFormation.
#' 
#' The configuration JSON must not exceed 64 KB.
#' @param Tags Tags associated with the resource.
#' 
#' This field is not to be confused with the Amazon Web Services-wide tag
#' feature for Amazon Web Services resources. Tags for
#' [`put_resource_config`][configservice_put_resource_config] are tags that
#' you supply for the configuration items of your custom resources.
#'
#' @keywords internal
#'
#' @rdname configservice_put_resource_config
configservice_put_resource_config <- function(ResourceType, SchemaVersionId, ResourceId, ResourceName = NULL, Configuration, Tags = NULL) {
  op <- new_operation(
    name = "PutResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_resource_config_input(ResourceType = ResourceType, SchemaVersionId = SchemaVersionId, ResourceId = ResourceId, ResourceName = ResourceName, Configuration = Configuration, Tags = Tags)
  output <- .configservice$put_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_resource_config <- configservice_put_resource_config

#' Creates and updates the retention configuration with details about
#' retention period (number of days) that Config stores your historical
#' information
#'
#' @description
#' Creates and updates the retention configuration with details about retention period (number of days) that Config stores your historical information. The API creates the `RetentionConfiguration` object and names the object as **default**. When you have a `RetentionConfiguration` object named **default**, calling the API modifies the default object.
#'
#' See [https://paws-r.github.io/docs/configservice/put_retention_configuration.html](https://paws-r.github.io/docs/configservice/put_retention_configuration.html) for full documentation.
#'
#' @param RetentionPeriodInDays &#91;required&#93; Number of days Config stores your historical information.
#' 
#' Currently, only applicable to the configuration item history.
#'
#' @keywords internal
#'
#' @rdname configservice_put_retention_configuration
configservice_put_retention_configuration <- function(RetentionPeriodInDays) {
  op <- new_operation(
    name = "PutRetentionConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_retention_configuration_input(RetentionPeriodInDays = RetentionPeriodInDays)
  output <- .configservice$put_retention_configuration_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_retention_configuration <- configservice_put_retention_configuration

#' Saves a new query or updates an existing saved query
#'
#' @description
#' Saves a new query or updates an existing saved query. The `QueryName` must be unique for a single Amazon Web Services account and a single Amazon Web Services Region. You can create upto 300 queries in a single Amazon Web Services account and a single Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/configservice/put_stored_query.html](https://paws-r.github.io/docs/configservice/put_stored_query.html) for full documentation.
#'
#' @param StoredQuery &#91;required&#93; A list of `StoredQuery` objects. The mandatory fields are `QueryName`
#' and `Expression`.
#' 
#' When you are creating a query, you must provide a query name and an
#' expression. When you are updating a query, you must provide a query name
#' but updating the description is optional.
#' @param Tags A list of `Tags` object.
#'
#' @keywords internal
#'
#' @rdname configservice_put_stored_query
configservice_put_stored_query <- function(StoredQuery, Tags = NULL) {
  op <- new_operation(
    name = "PutStoredQuery",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$put_stored_query_input(StoredQuery = StoredQuery, Tags = Tags)
  output <- .configservice$put_stored_query_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$put_stored_query <- configservice_put_stored_query

#' Accepts a structured query language (SQL) SELECT command and an
#' aggregator to query configuration state of Amazon Web Services resources
#' across multiple accounts and regions, performs the corresponding search,
#' and returns resource configurations matching the properties
#'
#' @description
#' Accepts a structured query language (SQL) SELECT command and an aggregator to query configuration state of Amazon Web Services resources across multiple accounts and regions, performs the corresponding search, and returns resource configurations matching the properties.
#'
#' See [https://paws-r.github.io/docs/configservice/select_aggregate_resource_config.html](https://paws-r.github.io/docs/configservice/select_aggregate_resource_config.html) for full documentation.
#'
#' @param Expression &#91;required&#93; The SQL query SELECT command.
#' @param ConfigurationAggregatorName &#91;required&#93; The name of the configuration aggregator.
#' @param Limit The maximum number of query results returned on each page.
#' @param MaxResults The maximum number of query results returned on each page. Config also
#' allows the Limit request parameter.
#' @param NextToken The nextToken string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_select_aggregate_resource_config
configservice_select_aggregate_resource_config <- function(Expression, ConfigurationAggregatorName, Limit = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "SelectAggregateResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$select_aggregate_resource_config_input(Expression = Expression, ConfigurationAggregatorName = ConfigurationAggregatorName, Limit = Limit, MaxResults = MaxResults, NextToken = NextToken)
  output <- .configservice$select_aggregate_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$select_aggregate_resource_config <- configservice_select_aggregate_resource_config

#' Accepts a structured query language (SQL) SELECT command, performs the
#' corresponding search, and returns resource configurations matching the
#' properties
#'
#' @description
#' Accepts a structured query language (SQL) `SELECT` command, performs the corresponding search, and returns resource configurations matching the properties.
#'
#' See [https://paws-r.github.io/docs/configservice/select_resource_config.html](https://paws-r.github.io/docs/configservice/select_resource_config.html) for full documentation.
#'
#' @param Expression &#91;required&#93; The SQL query `SELECT` command.
#' @param Limit The maximum number of query results returned on each page.
#' @param NextToken The `nextToken` string returned in a previous request that you use to
#' request the next page of results in a paginated response.
#'
#' @keywords internal
#'
#' @rdname configservice_select_resource_config
configservice_select_resource_config <- function(Expression, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "SelectResourceConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$select_resource_config_input(Expression = Expression, Limit = Limit, NextToken = NextToken)
  output <- .configservice$select_resource_config_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$select_resource_config <- configservice_select_resource_config

#' Runs an on-demand evaluation for the specified Config rules against the
#' last known configuration state of the resources
#'
#' @description
#' Runs an on-demand evaluation for the specified Config rules against the last known configuration state of the resources. Use [`start_config_rules_evaluation`][configservice_start_config_rules_evaluation] when you want to test that a rule you updated is working as expected. [`start_config_rules_evaluation`][configservice_start_config_rules_evaluation] does not re-record the latest configuration state for your resources. It re-runs an evaluation against the last known state of your resources.
#'
#' See [https://paws-r.github.io/docs/configservice/start_config_rules_evaluation.html](https://paws-r.github.io/docs/configservice/start_config_rules_evaluation.html) for full documentation.
#'
#' @param ConfigRuleNames The list of names of Config rules that you want to run evaluations for.
#'
#' @keywords internal
#'
#' @rdname configservice_start_config_rules_evaluation
configservice_start_config_rules_evaluation <- function(ConfigRuleNames = NULL) {
  op <- new_operation(
    name = "StartConfigRulesEvaluation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$start_config_rules_evaluation_input(ConfigRuleNames = ConfigRuleNames)
  output <- .configservice$start_config_rules_evaluation_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$start_config_rules_evaluation <- configservice_start_config_rules_evaluation

#' Starts recording configurations of the Amazon Web Services resources you
#' have selected to record in your Amazon Web Services account
#'
#' @description
#' Starts recording configurations of the Amazon Web Services resources you have selected to record in your Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/configservice/start_configuration_recorder.html](https://paws-r.github.io/docs/configservice/start_configuration_recorder.html) for full documentation.
#'
#' @param ConfigurationRecorderName &#91;required&#93; The name of the recorder object that records each configuration change
#' made to the resources.
#'
#' @keywords internal
#'
#' @rdname configservice_start_configuration_recorder
configservice_start_configuration_recorder <- function(ConfigurationRecorderName) {
  op <- new_operation(
    name = "StartConfigurationRecorder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$start_configuration_recorder_input(ConfigurationRecorderName = ConfigurationRecorderName)
  output <- .configservice$start_configuration_recorder_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$start_configuration_recorder <- configservice_start_configuration_recorder

#' Runs an on-demand remediation for the specified Config rules against the
#' last known remediation configuration
#'
#' @description
#' Runs an on-demand remediation for the specified Config rules against the last known remediation configuration. It runs an execution against the current state of your resources. Remediation execution is asynchronous.
#'
#' See [https://paws-r.github.io/docs/configservice/start_remediation_execution.html](https://paws-r.github.io/docs/configservice/start_remediation_execution.html) for full documentation.
#'
#' @param ConfigRuleName &#91;required&#93; The list of names of Config rules that you want to run remediation
#' execution for.
#' @param ResourceKeys &#91;required&#93; A list of resource keys to be processed with the current request. Each
#' element in the list consists of the resource type and resource ID.
#'
#' @keywords internal
#'
#' @rdname configservice_start_remediation_execution
configservice_start_remediation_execution <- function(ConfigRuleName, ResourceKeys) {
  op <- new_operation(
    name = "StartRemediationExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$start_remediation_execution_input(ConfigRuleName = ConfigRuleName, ResourceKeys = ResourceKeys)
  output <- .configservice$start_remediation_execution_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$start_remediation_execution <- configservice_start_remediation_execution

#' Stops recording configurations of the Amazon Web Services resources you
#' have selected to record in your Amazon Web Services account
#'
#' @description
#' Stops recording configurations of the Amazon Web Services resources you have selected to record in your Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/configservice/stop_configuration_recorder.html](https://paws-r.github.io/docs/configservice/stop_configuration_recorder.html) for full documentation.
#'
#' @param ConfigurationRecorderName &#91;required&#93; The name of the recorder object that records each configuration change
#' made to the resources.
#'
#' @keywords internal
#'
#' @rdname configservice_stop_configuration_recorder
configservice_stop_configuration_recorder <- function(ConfigurationRecorderName) {
  op <- new_operation(
    name = "StopConfigurationRecorder",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$stop_configuration_recorder_input(ConfigurationRecorderName = ConfigurationRecorderName)
  output <- .configservice$stop_configuration_recorder_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$stop_configuration_recorder <- configservice_stop_configuration_recorder

#' Associates the specified tags to a resource with the specified
#' resourceArn
#'
#' @description
#' Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
#'
#' See [https://paws-r.github.io/docs/configservice/tag_resource.html](https://paws-r.github.io/docs/configservice/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags. Currently, the supported resources are `ConfigRule`,
#' `ConfigurationAggregator` and `AggregatorAuthorization`.
#' @param Tags &#91;required&#93; An array of tag object.
#'
#' @keywords internal
#'
#' @rdname configservice_tag_resource
configservice_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .configservice$tag_resource_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$tag_resource <- configservice_tag_resource

#' Deletes specified tags from a resource
#'
#' @description
#' Deletes specified tags from a resource.
#'
#' See [https://paws-r.github.io/docs/configservice/untag_resource.html](https://paws-r.github.io/docs/configservice/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags. Currently, the supported resources are `ConfigRule`,
#' `ConfigurationAggregator` and `AggregatorAuthorization`.
#' @param TagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @keywords internal
#'
#' @rdname configservice_untag_resource
configservice_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .configservice$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .configservice$untag_resource_output()
  config <- get_config()
  svc <- .configservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.configservice$operations$untag_resource <- configservice_untag_resource
