% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applicationautoscaling_operations.R
\name{applicationautoscaling_put_scheduled_action}
\alias{applicationautoscaling_put_scheduled_action}
\title{Creates or updates a scheduled action for an Application Auto Scaling
scalable target}
\usage{
applicationautoscaling_put_scheduled_action(ServiceNamespace, Schedule,
  ScheduledActionName, ResourceId, ScalableDimension, StartTime, EndTime,
  ScalableTargetAction)
}
\arguments{
\item{ServiceNamespace}{[required] The namespace of the AWS service that provides the resource. For a
resource provided by your own application or service, use
\code{custom-resource} instead.}

\item{Schedule}{The schedule for this action. The following formats are supported:
\itemize{
\item At expressions -
\"\verb{at(<i>yyyy</i>-<i>mm</i>-<i>dd</i>T<i>hh</i>:<i>mm</i>:<i>ss</i>)}\"
\item Rate expressions - \"\verb{rate(<i>value</i> <i>unit</i>)}\"
\item Cron expressions - \"\verb{cron(<i>fields</i>)}\"
}

At expressions are useful for one-time schedules. Specify the time in
UTC.

For rate expressions, \emph{value} is a positive integer and \emph{unit} is
\code{minute} \\| \code{minutes} \\| \code{hour} \\| \code{hours} \\| \code{day} \\| \code{days}.

For more information about cron expressions, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions}{Cron Expressions}
in the \emph{Amazon CloudWatch Events User Guide}.

For examples of using these expressions, see \href{https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html}{Scheduled Scaling}
in the \emph{Application Auto Scaling User Guide}.}

\item{ScheduledActionName}{[required] The name of the scheduled action. This name must be unique among all
other scheduled actions on the specified scalable target.}

\item{ResourceId}{[required] The identifier of the resource associated with the scheduled action.
This string consists of the resource type and unique identifier.
\itemize{
\item ECS service - The resource type is \code{service} and the unique
identifier is the cluster name and service name. Example:
\code{service/default/sample-webapp}.
\item Spot Fleet request - The resource type is \code{spot-fleet-request} and
the unique identifier is the Spot Fleet request ID. Example:
\verb{spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE}.
\item EMR cluster - The resource type is \code{instancegroup} and the unique
identifier is the cluster ID and instance group ID. Example:
\verb{instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0}.
\item AppStream 2.0 fleet - The resource type is \code{fleet} and the unique
identifier is the fleet name. Example: \code{fleet/sample-fleet}.
\item DynamoDB table - The resource type is \code{table} and the unique
identifier is the table name. Example: \code{table/my-table}.
\item DynamoDB global secondary index - The resource type is \code{index} and
the unique identifier is the index name. Example:
\code{table/my-table/index/my-table-index}.
\item Aurora DB cluster - The resource type is \code{cluster} and the unique
identifier is the cluster name. Example: \code{cluster:my-db-cluster}.
\item Amazon SageMaker endpoint variant - The resource type is \code{variant}
and the unique identifier is the resource ID. Example:
\code{endpoint/my-end-point/variant/KMeansClustering}.
\item Custom resources are not supported with a resource type. This
parameter must specify the \code{OutputValue} from the CloudFormation
template stack used to access the resources. The unique identifier
is defined by the service provider. More information is available in
our \href{https://github.com/aws/aws-auto-scaling-custom-resource}{GitHub repository}.
\item Amazon Comprehend document classification endpoint - The resource
type and unique identifier are specified using the endpoint ARN.
Example:
\code{arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE}.
\item Lambda provisioned concurrency - The resource type is \code{function} and
the unique identifier is the function name with a function version
or alias name suffix that is not \verb{$LATEST}. Example:
\verb{function:my-function:prod} or \verb{function:my-function:1}.
\item Amazon Keyspaces table - The resource type is \code{table} and the unique
identifier is the table name. Example:
\code{keyspace/mykeyspace/table/mytable}.
}}

\item{ScalableDimension}{[required] The scalable dimension. This string consists of the service namespace,
resource type, and scaling property.
\itemize{
\item \code{ecs:service:DesiredCount} - The desired task count of an ECS
service.
\item \code{ec2:spot-fleet-request:TargetCapacity} - The target capacity of a
Spot Fleet request.
\item \code{elasticmapreduce:instancegroup:InstanceCount} - The instance count
of an EMR Instance Group.
\item \code{appstream:fleet:DesiredCapacity} - The desired capacity of an
AppStream 2.0 fleet.
\item \code{dynamodb:table:ReadCapacityUnits} - The provisioned read capacity
for a DynamoDB table.
\item \code{dynamodb:table:WriteCapacityUnits} - The provisioned write capacity
for a DynamoDB table.
\item \code{dynamodb:index:ReadCapacityUnits} - The provisioned read capacity
for a DynamoDB global secondary index.
\item \code{dynamodb:index:WriteCapacityUnits} - The provisioned write capacity
for a DynamoDB global secondary index.
\item \code{rds:cluster:ReadReplicaCount} - The count of Aurora Replicas in an
Aurora DB cluster. Available for Aurora MySQL-compatible edition and
Aurora PostgreSQL-compatible edition.
\item \code{sagemaker:variant:DesiredInstanceCount} - The number of EC2
instances for an Amazon SageMaker model endpoint variant.
\item \code{custom-resource:ResourceType:Property} - The scalable dimension for
a custom resource provided by your own application or service.
\item \code{comprehend:document-classifier-endpoint:DesiredInferenceUnits} -
The number of inference units for an Amazon Comprehend document
classification endpoint.
\item \verb{lambda:function:ProvisionedConcurrency} - The provisioned
concurrency for a Lambda function.
\item \code{cassandra:table:ReadCapacityUnits} - The provisioned read capacity
for an Amazon Keyspaces table.
\item \code{cassandra:table:WriteCapacityUnits} - The provisioned write
capacity for an Amazon Keyspaces table.
}}

\item{StartTime}{The date and time for this scheduled action to start.}

\item{EndTime}{The date and time for the recurring schedule to end.}

\item{ScalableTargetAction}{The new minimum and maximum capacity. You can set both values or just
one. At the scheduled time, if the current capacity is below the minimum
capacity, Application Auto Scaling scales out to the minimum capacity.
If the current capacity is above the maximum capacity, Application Auto
Scaling scales in to the maximum capacity.}
}
\description{
Creates or updates a scheduled action for an Application Auto Scaling
scalable target.
}
\details{
Each scalable target is identified by a service namespace, resource ID,
and scalable dimension. A scheduled action applies to the scalable
target identified by those three attributes. You cannot create a
scheduled action until you have registered the resource as a scalable
target.

When start and end times are specified with a recurring schedule using a
cron expression or rates, they form the boundaries of when the recurring
action starts and stops.

To update a scheduled action, specify the parameters that you want to
change. If you don\'t specify start and end times, the old values are
deleted.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scheduled-scaling.html}{Scheduled Scaling}
in the \emph{Application Auto Scaling User Guide}.

If a scalable target is deregistered, the scalable target is no longer
available to run scheduled actions. Any scheduled actions that were
specified for the scalable target are deleted.
}
\section{Request syntax}{
\preformatted{svc$put_scheduled_action(
  ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource"|"comprehend"|"lambda"|"cassandra",
  Schedule = "string",
  ScheduledActionName = "string",
  ResourceId = "string",
  ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"|"comprehend:document-classifier-endpoint:DesiredInferenceUnits"|"lambda:function:ProvisionedConcurrency"|"cassandra:table:ReadCapacityUnits"|"cassandra:table:WriteCapacityUnits",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  ScalableTargetAction = list(
    MinCapacity = 123,
    MaxCapacity = 123
  )
)
}
}

\keyword{internal}
